/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.search;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ObjectUsageAccessorClient;
import ca.infodata.ofys.data.dataaccess.ProfessionnalAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.IDDataObject;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XWebSearchProvince;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.form.combo.BooleanFilterCombo;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchCompositeWeb;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.controls.windows.DisclaimerDialog;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.professionnal.ProfessionnalMultiEditor;
import ca.infodata.ofys.util.EnumWithValueFactory;
import ca.infodata.util1.EventLock;
import ca.infodata.util1.StringUtils;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ProfessionnalSearchComposite
extends BaseSearchCompositeWeb {
    private static final Logger logger = Logger.getLogger(ProfessionnalSearchComposite.class.getName());
    private static final String MSG_WEB_SEARCH_INVALID = Messages.getString((String)"MSG_WEB_SEARCH_INVALID", (String[])new String[0]);
    private boolean mustContinue;
    private Integer type;
    private MyCombo<XWebSearchProvince> cmbProvinceWebSearch;
    private String cmbProvinceWebSearchPrefKey;
    protected MyLabel lblName;
    protected MyText txtName;
    private boolean layout2RowOn;
    protected FontAwareSection secPlus;
    protected BooleanFilterCombo cmbDeleted;

    public ProfessionnalSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
    }

    public ProfessionnalSearchComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void setFocus() {
        this.txtName.setFocus();
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        this.isWithTemplateTool = true;
        this.templateType = XCompletionProposalType.PROFESSIONNAL_SEARCH;
        super.createMyPartControl(theParent, toolkit, style);
    }

    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        this.setViewSelectInactive();
        FormLayout layout = new FormLayout();
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.spacing = 0;
        parent.setLayout((Layout)layout);
        this.lblName = new MyLabel(parent, Messages.getString((String)"NOM_PRENOM_NUMERO", (String[])new String[0]), 0, toolkit);
        this.txtName = new MyText(parent, toolkit);
        this.txtName.setTextLimit(95);
        this.txtName.addKeyListener(this.enterCtrlEnterListener);
        this.txtName.setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.addSearchControl("txtName", (IControl)this.txtName);
        this.secPlus = new FontAwareSection(parent, 2050, toolkit);
        toolkit.createCompositeSeparator((Composite)this.secPlus);
        this.secPlus.setText(Messages.getString((String)"RAFFINER", (String[])new String[0]));
        Composite compPlus = toolkit.createComposite((Composite)this.secPlus);
        compPlus.setLayout((Layout)new FormLayout());
        this.secPlus.setClient((Control)compPlus);
        MyLabel lblDeleted = new MyLabel(compPlus, String.valueOf(Messages.getString((String)"DESACTIVEE", (String[])new String[0])) + " : ", 0, toolkit);
        this.cmbDeleted = new BooleanFilterCombo(compPlus, toolkit);
        this.cmbDeleted.select((Object)Boolean.FALSE);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.secPlus.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbDeleted.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(0);
        lblDeleted.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(lblDeleted.getControl());
        this.cmbDeleted.setLayoutData(data);
    }

    protected void search() throws ErrorWhileSearchingException {
        this.search(false);
    }

    protected void searchWeb() throws ErrorWhileSearchingException {
        this.mustContinue = true;
        if (PersonUiPlugin.showDisclaimerProfessionnal) {
            DisclaimerDialog disclaimer = new DisclaimerDialog((Composite)this.getControl().getShell());
            disclaimer.open(Messages.getString((String)"AVIS", (String[])new String[0]));
            this.mustContinue = disclaimer.isOkPressed();
            if (this.mustContinue) {
                PersonUiPlugin.showDisclaimerProfessionnal = false;
            }
        }
        if (this.mustContinue) {
            this.search(true);
        }
    }

    private void search(final boolean web) throws ErrorWhileSearchingException {
        block6: {
            this.disposeTableColumns();
            this.createLoadingTableColumns();
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    if (response == null || response.getObj() == null) {
                        ProfessionnalSearchComposite.this.searchResponse(new ArrayList(0), web);
                    } else {
                        ProfessionnalSearchComposite.this.searchResponse((List)response.getObj(), web);
                    }
                }
            };
            try {
                if (web && StringUtils.trim((String)this.txtName.getText()).length() < 3) {
                    this.searchResponse(new ArrayList<XBaseProfessionnal>(), web, true);
                } else {
                    Boolean isActive = this.cmbDeleted.getSelection() == null ? null : Boolean.valueOf((Boolean)this.cmbDeleted.getSelection() == false);
                    ProfessionnalAccessorClient.getInstance().findProfesssionnals(Application.get().getGlobalInstances().getSession(), (ICallback)callback, this.txtName.getText(), this.getType(), web, false, (XWebSearchProvince)this.cmbProvinceWebSearch.getSelection(), isActive);
                }
            }
            catch (CannotConnectToServerException e) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
                throw new ErrorWhileSearchingException((Exception)((Object)e));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
                if (callback == null || callback.killed()) break block6;
                callback.kill();
            }
        }
    }

    private void searchResponse(List<XBaseProfessionnal> list, boolean web) {
        this.searchResponse(list, web, false);
    }

    private void searchResponse(final List<XBaseProfessionnal> list, final boolean web, final boolean notMinimalRequirement) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!ProfessionnalSearchComposite.this.parent.isDisposed()) {
                        if (Application.get().getGlobalInstances().getSession().getClientPreferences().getReturnListLength() <= list.size()) {
                            ProfessionnalSearchComposite.this.setMessage(MSG_TROP_DONNEES);
                        } else if (list.isEmpty()) {
                            if (web && notMinimalRequirement) {
                                ProfessionnalSearchComposite.this.setMessage(MSG_WEB_SEARCH_INVALID);
                            } else {
                                ProfessionnalSearchComposite.this.setMessage(MSG_AUCUNES_DONNEES);
                            }
                            ProfessionnalSearchComposite.this.txtName.setFocus();
                        } else {
                            ProfessionnalSearchComposite.this.setMessage(null);
                        }
                        ProfessionnalSearchComposite.this.disposeTableColumns();
                        if (web) {
                            ProfessionnalSearchComposite.this.createWebTableColumns();
                        } else {
                            ProfessionnalSearchComposite.this.createTableColumns();
                        }
                        SearchItem[] search = new SearchItem[list.size()];
                        int i = 0;
                        while (i < list.size()) {
                            XBaseProfessionnal p = (XBaseProfessionnal)list.get(i);
                            search[i] = ProfessionnalSearchComposite.this.newSearchItem(p);
                            ++i;
                        }
                        ProfessionnalSearchComposite.this.loadSearchListInTable(search);
                        ProfessionnalSearchComposite.this.callbackContainerReferenceControlFromTableItems();
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "", e);
                }
            }
        });
    }

    protected void createWebTableColumns() {
        this.tblSearch.setLinesVisible(false);
        this.tblSearch.setHeaderVisible(false);
        this.tableColumns = new ArrayList();
        SearchColumn<XBaseProfessionnal> sc = new SearchColumn<XBaseProfessionnal>((Table)this.tblSearch, ""){

            public String getText(XBaseProfessionnal e) {
                return e.str;
            }
        };
        this.tableColumns.add(sc);
    }

    protected void createTableColumns() {
        this.tblSearch.setLinesVisible(false);
        this.tblSearch.setHeaderVisible(true);
        this.tableColumns = new ArrayList();
        if (Application.get().getGlobalInstances().inDebugMode()) {
            this.tableColumns.add(new SearchColumn<XBaseProfessionnal>((Table)this.tblSearch, "ID"){

                public String getText(XBaseProfessionnal e) {
                    return String.valueOf(e.getId());
                }
            });
        }
        SearchColumn sc = new SearchColumn<XBaseProfessionnal>((Table)this.tblSearch, "NOM"){

            public String getText(XBaseProfessionnal e) {
                return e.getName();
            }
        };
        sc.getColumn().setData("maxWidth", (Object)150);
        this.tableColumns.add(sc);
        SearchColumn<XBaseProfessionnal> scCode = new SearchColumn<XBaseProfessionnal>((Table)this.tblSearch, "CODE"){

            public String getText(XBaseProfessionnal e) {
                return e.getCode();
            }
        };
        scCode.getColumn().setData("maxWidth", (Object)80);
        this.tableColumns.add(scCode);
        this.tableColumns.add(new SearchColumn<XBaseProfessionnal>((Table)this.tblSearch, "TRAITANT?"){

            public String getText(XBaseProfessionnal e) {
                return e.isProfTx() ? "\u221a" : "";
            }
        });
        this.tableColumns.add(new SearchColumn<XBaseProfessionnal>((Table)this.tblSearch, "VILLE"){

            public String getText(XBaseProfessionnal e) {
                return e.getCityName() == null ? "" : e.getCityName();
            }
        });
        this.tableColumns.add(new SearchColumn<XBaseProfessionnal>((Table)this.tblSearch, "NOTE"){

            public String getText(XBaseProfessionnal e) {
                return e.getNote();
            }
        });
        sc = new SearchColumn<XBaseProfessionnal>((Table)this.tblSearch, Messages.getString((String)"DESACTIVEE", (String[])new String[0])){

            public String getText(XBaseProfessionnal e) {
                return e.getIsDeleted() != false ? "\u221a" : "";
            }
        };
        sc.getColumn().setData("maxWidth", (Object)100);
        this.tableColumns.add(sc);
    }

    protected void createNew() {
        try {
            XProfessionnal professionnal = new XProfessionnal();
            professionnal.initialize();
            BaseEditor.openEditor((IEditorInput)new EditorInput((IDataObject)professionnal), (String)"ca.infodata.ofys.ui.person.professionnal.ProfessionnalMultiEditor");
        }
        catch (PartInitException e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    private XBaseProfessionnal createProf(XBaseProfessionnal baseProf) {
        XBaseProfessionnal[] prof;
        block4: {
            prof = new XBaseProfessionnal[1];
            final EventLock lock = new EventLock();
            SaveCallback callback = new SaveCallback(Application.get().getGlobalInstances().getSession()){

                public void responseReceived(ReturnObject response) {
                    try {
                        if (response != null && response.getObj() != null) {
                            XProfessionnal a = (XProfessionnal)response.getObj();
                            prof[0] = a == null ? null : new XBaseProfessionnal(a);
                        }
                    }
                    finally {
                        lock.eventOccured();
                    }
                }

                public void exception(Exception e) {
                    super.exception(e);
                    lock.eventOccured();
                }
            };
            try {
                XProfessionnal a = new XProfessionnal();
                a.setNew();
                a.initialize();
                a.setFirstName(baseProf.getFirstName());
                a.setLastName(baseProf.getLastName());
                a.setCode(baseProf.getCode());
                a.setIsProfTx(false);
                a.setIsSetSeenManual(false);
                a.setUseAppointment(false);
                a.setProfessionnalType(baseProf.getProfessionalType());
                a.setSpeciality(baseProf.getSpeciality());
                ProfessionnalAccessorClient.getInstance().save(((Object)((Object)this)).hashCode(), Application.get().getGlobalInstances().getSession(), callback, (IDataObject)a, false);
                lock.waitUntilEvent(10000L);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
        return prof[0];
    }

    private XBaseProfessionnal find(String code) {
        XBaseProfessionnal[] prof;
        block4: {
            prof = new XBaseProfessionnal[1];
            final EventLock lock = new EventLock();
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    try {
                        if (response != null && response.getObj() != null) {
                            List list = (List)response.getObj();
                            prof[0] = list.size() > 0 ? (XBaseProfessionnal)list.get(0) : null;
                        }
                    }
                    finally {
                        lock.eventOccured();
                    }
                }

                public void exception(Exception e) {
                    super.exception(e);
                    lock.eventOccured();
                }
            };
            try {
                ProfessionnalAccessorClient.getInstance().findProfesssionnals(Application.get().getGlobalInstances().getSession(), (ICallback)callback, code, null, false, true, null, null);
                lock.waitUntilEvent(10000L);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
        return prof[0];
    }

    protected Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setSearchText(String s) {
        this.txtName.setText(s);
        if (this.txtName.getText() != null) {
            this.txtName.setSelection(this.txtName.getText().length());
        }
    }

    public void doSearch() {
        try {
            this.search();
        }
        catch (ErrorWhileSearchingException e) {
            logger.log(Level.WARNING, "Coudn't search.", e);
        }
    }

    protected void itemSelected(SearchItem item) {
        this.processSelection(item);
    }

    protected void processSelection(SearchItem item) {
        if (item != null && item.getData() instanceof XBaseProfessionnal) {
            XBaseProfessionnal prof = (XBaseProfessionnal)item.getData();
            if (prof.getId() != null) {
                try {
                    IDDataObject idDataObject = new IDDataObject(prof.getId(), prof.getClass(), "");
                    ObjectUsageAccessorClient.getInstance().setObjectUsed(prof.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)new Callback(), (IDataObject)idDataObject);
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "", e);
                }
            }
            if (prof.getId() == null) {
                XBaseProfessionnal prof2 = this.find(prof.getCode());
                if (prof2 == null) {
                    boolean confirm = MessageUtil.askQuestion((Shell)this.getControl().getShell(), (String)"Le professionnel selectionn\u00e9 n'a pas \u00e9t\u00e9 trouv\u00e9 dans le syst\u00e8me. \nIl sera donc ajouter.\n\n\u00cates-vous certains de vouloir continuer?", (boolean)false);
                    if (confirm) {
                        prof = this.createProf(prof);
                    }
                } else {
                    prof = prof2;
                }
            }
            this.close();
            if (prof != null && prof.getId() != null) {
                if (this.getSelectionReferenceControl() instanceof IReferenceControl) {
                    ((IReferenceControl)this.getSelectionReferenceControl()).callback((Object)prof);
                } else {
                    BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)prof), (String)ProfessionnalMultiEditor.class.getName());
                }
            }
        }
    }

    public void reset() {
        super.reset();
        this.txtName.setText("");
    }

    protected void showContextMenu(Control parent) {
        Menu menu = new Menu(parent);
        menu.setVisible(true);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Ajouter aux favoris");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Properties prop = ProfessionnalSearchComposite.this.getSearchProperties();
                    XTemplate template2 = new XTemplate();
                    template2.setId(null);
                    TableItem item = ProfessionnalSearchComposite.this.tblSearch.getSelection()[0];
                    SearchItem data = (SearchItem)item.getData();
                    XBaseProfessionnal prof = (XBaseProfessionnal)data.getData();
                    if (prof.getId() == null) {
                        template2.setName(prof.str);
                    } else {
                        template2.setName(prof.getName());
                    }
                    prop.setProperty("txtName", prof.getName().replace(",", ""));
                    template2.setType(Integer.valueOf(((ProfessionnalSearchComposite)ProfessionnalSearchComposite.this).templateType.id));
                    StringWriter writer = new StringWriter();
                    prop.store(writer, "");
                    template2.setText(writer.toString());
                    ProfessionnalSearchComposite.this.templateContentProposalAdapter.getAccessor().save(template2);
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "", e2);
                }
            }
        });
    }

    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return null;
    }

    protected String getPreferencesKeys() {
        return null;
    }

    protected void buildBtnBar(final Composite parent, final MyButton btnSearch, final MyButton btnNew, final MyButton btnCustom, FormToolkit toolkit, final MyButton btnListTemplates, final MyButton btnTemplateActionMenu) {
        this.btnSearchWeb = new MyButton(parent, Messages.getString((String)"RECHERCHER_WEB", (String[])new String[0]), 8, toolkit);
        this.btnSearchWeb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ProfessionnalSearchComposite.this.webSearchButtonSelected();
            }
        });
        this.btnSearchWeb.setToolTipText(Messages.getString((String)"CTRLRETOUR", (String[])new String[0]));
        this.cmbProvinceWebSearch = new MyCombo(parent, 8, toolkit);
        this.cmbProvinceWebSearch.add((Object)XWebSearchProvince.QC);
        this.cmbProvinceWebSearch.add((Object)XWebSearchProvince.NB);
        this.cmbProvinceWebSearchPrefKey = "ProfessionnalSearchComposite.provinceWebSearch";
        XWebSearchProvince def = (XWebSearchProvince)EnumWithValueFactory.fromInt(XWebSearchProvince.class, (Integer)PreferencesSettings.getInstance().getIntSafe(this.cmbProvinceWebSearchPrefKey, XWebSearchProvince.QC.value));
        this.cmbProvinceWebSearch.forceSelect((Object)def);
        this.cmbProvinceWebSearch.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XWebSearchProvince selection = (XWebSearchProvince)ProfessionnalSearchComposite.this.cmbProvinceWebSearch.getSelection();
                int value = selection == null ? XWebSearchProvince.QC.value : selection.value;
                PreferencesSettings.getInstance().put(ProfessionnalSearchComposite.this.cmbProvinceWebSearchPrefKey, value);
            }
        });
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ProfessionnalSearchComposite.this.adaptSize(parent, btnSearch, btnNew, btnCustom, btnListTemplates, btnTemplateActionMenu);
            }
        });
        this.adaptSize(parent, btnSearch, btnNew, btnCustom, btnListTemplates, btnTemplateActionMenu);
    }

    protected void adaptSize(Composite parent, MyButton btnSearch, MyButton btnNew, MyButton btnCustom, MyButton btnListTemplates, MyButton btnTemplateActionMenu) {
        Point size = parent.getSize();
        int w = 0;
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!c.isDisposed() && c.getVisible()) {
                w += c.getSize().x;
            }
            ++n2;
        }
        if (w > size.x - 20) {
            this.layout2Row(btnSearch, btnNew, btnCustom, btnListTemplates, btnTemplateActionMenu);
        } else {
            this.layout1Row(btnSearch, btnNew, btnCustom, btnListTemplates, btnTemplateActionMenu);
        }
    }

    private void layout2Row(MyButton btnSearch, MyButton btnNew, MyButton btnCustom, MyButton btnListTemplates, MyButton btnTemplateActionMenu) {
        if (this.layout2RowOn) {
            return;
        }
        this.layout2RowOn = true;
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(this.btnSearchWeb.getControl(), 5);
        data.width = MyButton.getStandardButtonWidth();
        btnNew.setLayoutData((Object)data);
        btnNew.setVisible(false);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(this.btnSearchWeb.getControl(), 5);
        data.width = MyButton.getStandardButtonWidth();
        btnCustom.setLayoutData((Object)data);
        btnCustom.setVisible(false);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = MyButton.getStandardButtonWidth();
        btnSearch.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)btnSearch);
        data.left = new FormAttachment(0);
        this.btnSearchWeb.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnSearchWeb.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(this.btnSearchWeb.getControl());
        this.cmbProvinceWebSearch.setLayoutData(data);
        if (this.isWithTemplateTool) {
            data = new FormData();
            data.top = new FormAttachment(0);
            data.right = new FormAttachment(btnTemplateActionMenu.getControl(), 0);
            btnListTemplates.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.right = new FormAttachment(100);
            btnTemplateActionMenu.setLayoutData((Object)data);
        }
        this.parent.layout(true, true);
    }

    private void layout1Row(MyButton btnSearch, MyButton btnNew, MyButton btnCustom, MyButton btnListTemplates, MyButton btnTemplateActionMenu) {
        if (!this.layout2RowOn) {
            return;
        }
        this.layout2RowOn = false;
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(this.btnSearchWeb.getControl(), 5);
        data.width = MyButton.getStandardButtonWidth();
        btnNew.setLayoutData((Object)data);
        btnNew.setVisible(false);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.width = MyButton.getStandardButtonWidth();
        btnSearch.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(btnSearch.getControl());
        this.btnSearchWeb.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnSearchWeb.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(this.btnSearchWeb.getControl());
        this.cmbProvinceWebSearch.setLayoutData(data);
        if (this.isWithTemplateTool) {
            data = new FormData();
            data.top = new FormAttachment(0);
            data.right = new FormAttachment(btnTemplateActionMenu.getControl(), 0);
            btnListTemplates.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.right = new FormAttachment(100);
            btnTemplateActionMenu.setLayoutData((Object)data);
        }
        this.parent.layout(true, true);
    }
}

