/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.export;

import ca.infodata.ofys.data.middle.dataobjects.export.XExportableField;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.FontAwareButton;
import ca.infodata.ofys.ui.controls.FontAwareGroup;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.patient.search.export.ExportBean;
import ca.infodata.ofys.ui.person.patient.search.export.ExportFormat;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;

class ExportConfigPage
extends WizardPage {
    private Composite parent;
    private ExportBean bean;
    private MyText txtFileChoosed;
    private FontAwareButton btnXls;
    private FontAwareButton btnCsv;

    public ExportConfigPage(ExportBean bean) {
        super("config", "Configuration", ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)"images/persons-icon32.png")));
        this.bean = bean;
    }

    public void createControl(Composite parent) {
        parent = this.parent = new Composite(parent, 0);
        FontAwareGroup grpFormat = new FontAwareGroup(parent, -1);
        grpFormat.setText("1. S\u00e9lectionnez le format du fichier de sortie");
        grpFormat.setFont(0, 1);
        GridLayout glayout = new GridLayout();
        glayout.marginTop = 5;
        glayout.marginLeft = 5;
        glayout.makeColumnsEqualWidth = true;
        glayout.numColumns = 1;
        grpFormat.setLayout((Layout)glayout);
        this.btnXls = new FontAwareButton((Composite)grpFormat, 16);
        this.btnXls.setText(ExportFormat.XLS97.description);
        this.btnXls.setSelection(this.bean.format == ExportFormat.XLS97);
        this.btnCsv = new FontAwareButton((Composite)grpFormat, 16);
        this.btnCsv.setText(ExportFormat.CSV.description);
        this.btnCsv.setSelection(this.bean.format == ExportFormat.CSV);
        FontAwareGroup grpFile = new FontAwareGroup(parent, -1);
        grpFile.setFont(0, 1);
        grpFile.setText("2. Choisissez le fichier de sortie");
        FormLayout formLayout = new FormLayout();
        formLayout.marginTop = 5;
        formLayout.marginBottom = 5;
        formLayout.marginLeft = 5;
        grpFile.setLayout((Layout)formLayout);
        MyButton btnFile = new MyButton((Composite)grpFile, "Choisir", 8, null);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        btnFile.setLayoutData((Object)formData);
        this.txtFileChoosed = new MyText((Composite)grpFile, 8);
        this.txtFileChoosed.setText(this.bean.toFile == null ? "" : this.bean.toFile.getAbsolutePath());
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment((Control)btnFile);
        formData.right = new FormAttachment(100);
        this.txtFileChoosed.setLayoutData((Object)formData);
        FontAwareGroup grpFields = new FontAwareGroup(parent, -1);
        grpFields.setText("3. S\u00e9lectionnez les champs \u00e0 exporter");
        grpFields.setFont(0, 1);
        XExportableField[] xExportableFieldArray = XExportableField.values();
        int n = xExportableFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            XExportableField f = xExportableFieldArray[n2];
            MyButton button = new MyButton((Composite)grpFields, 32);
            button.setText(f.toString());
            button.setData((Object)f);
            button.setSelection(false);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button2 = (Button)e.widget;
                    XExportableField f2 = (XExportableField)button2.getData();
                    if (button2.getSelection()) {
                        ((ExportConfigPage)ExportConfigPage.this).bean.fields.add(f2);
                    } else {
                        ((ExportConfigPage)ExportConfigPage.this).bean.fields.remove(f2);
                    }
                    System.out.println(((ExportConfigPage)ExportConfigPage.this).bean.fields);
                }
            });
            ++n2;
        }
        glayout = new GridLayout();
        glayout.makeColumnsEqualWidth = true;
        glayout.numColumns = 3;
        glayout.marginTop = 5;
        glayout.marginBottom = 5;
        glayout.marginLeft = 5;
        grpFields.setLayout((Layout)glayout);
        this.btnXls.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ExportConfigPage)ExportConfigPage.this).bean.format = ExportFormat.XLS97;
                ExportConfigPage.this.btnCsv.setSelection(false);
                ((ExportConfigPage)ExportConfigPage.this).bean.toFile = ExportBean.getDefaultTargetFile(((ExportConfigPage)ExportConfigPage.this).bean.format);
                ExportConfigPage.this.txtFileChoosed.setText(((ExportConfigPage)ExportConfigPage.this).bean.toFile == null ? "" : ((ExportConfigPage)ExportConfigPage.this).bean.toFile.getAbsolutePath());
            }
        });
        this.btnCsv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ExportConfigPage)ExportConfigPage.this).bean.format = ExportFormat.CSV;
                ExportConfigPage.this.btnXls.setSelection(false);
                ((ExportConfigPage)ExportConfigPage.this).bean.toFile = ExportBean.getDefaultTargetFile(((ExportConfigPage)ExportConfigPage.this).bean.format);
                ExportConfigPage.this.txtFileChoosed.setText(((ExportConfigPage)ExportConfigPage.this).bean.toFile == null ? "" : ((ExportConfigPage)ExportConfigPage.this).bean.toFile.getAbsolutePath());
            }
        });
        btnFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ExportConfigPage)ExportConfigPage.this).bean.toFile = ExportConfigPage.this.getTargetFile();
                ExportConfigPage.this.txtFileChoosed.setText(((ExportConfigPage)ExportConfigPage.this).bean.toFile == null ? "" : ((ExportConfigPage)ExportConfigPage.this).bean.toFile.getAbsolutePath());
            }
        });
        FormLayout layout = formLayout;
        layout.marginTop = 10;
        layout.marginWidth = 10;
        layout.spacing = 10;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        grpFormat.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)grpFormat);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        grpFile.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)grpFile);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        grpFields.setLayoutData((Object)data);
        this.setControl((Control)parent);
        this.setPageComplete(true);
    }

    protected File getTargetFile() {
        if (UI.OS_MAC) {
            return ExportBean.getDefaultTargetFile(this.bean.format);
        }
        File file = this.getTargetFileFromDialog();
        return file == null ? this.bean.toFile : file;
    }

    private File getTargetFileFromDialog() {
        String extension = this.bean.format == ExportFormat.XLS97 ? "*.xls" : "*.csv";
        String defaultDir = ControlsPlugin.getDefault().getSettings().get("ca.infodata.default_csv_directory");
        FileDialog fd = new FileDialog(this.getShell(), 8192);
        fd.setText("Choisissez le fichier de sortie");
        if (defaultDir != null) {
            fd.setFilterPath(defaultDir);
        } else {
            fd.setFilterPath(LibPlugin.OFYS_HOME);
        }
        fd.setFilterExtensions(new String[]{extension});
        String filename = fd.open();
        if (filename != null && !fd.getFilterPath().equals(defaultDir)) {
            ControlsPlugin.getDefault().getSettings().put("ca.infodata.default_csv_directory", fd.getFilterPath());
        }
        return filename == null ? null : new File(filename);
    }

    public boolean canFlipToNextPage() {
        if (this.bean.format == null) {
            this.setErrorMessage("Veuillez s\u00e9lectionner le format de sortie");
            return false;
        }
        if (this.bean.toFile == null) {
            this.setErrorMessage("Veuillez choisir le fichier de sortie");
            return false;
        }
        if (this.bean.fields.isEmpty()) {
            this.setErrorMessage("Veuillez s\u00e9lectionner les champs \u00e0 exporter");
            return false;
        }
        if (this.bean.format.nbRowsLimit != null && this.bean.format.nbRowsLimit <= this.bean.patientIds.size()) {
            this.setErrorMessage("Trop de patients pour ce format. Le format a une limite de " + this.bean.format.nbRowsLimit + " lignes.");
            return false;
        }
        if (this.bean.toFile.exists()) {
            this.setErrorMessage("Un fichier existe d\u00e9j\u00e0 avec ce nom " + this.bean.toFile.getName());
            return false;
        }
        try {
            boolean created = this.bean.toFile.createNewFile();
            if (!created) {
                this.setErrorMessage("La cr\u00e9ation du fichier " + this.bean.toFile.getName() + " \u00e0 \u00e9chou\u00e9");
            } else {
                this.bean.toFile.delete();
            }
        }
        catch (IOException e) {
            this.setErrorMessage("La cr\u00e9ation du fichier " + this.bean.toFile.getName() + " \u00e0 \u00e9chou\u00e9.\n" + e.getLocalizedMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

