/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.criteria;

import apple.finder.search.ui.ICriteriaOperator;
import ca.infodata.ofys.data.middle.dataobjects.encounter.ICode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCode;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCodeClassification;
import ca.infodata.ofys.data.middle.dataobjects.search.CID;
import ca.infodata.ofys.data.middle.dataobjects.search.Operator;
import ca.infodata.ofys.data.middle.dataobjects.search.ServerCriteria;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.CriteriaOperator;
import ca.infodata.ofys.ui.person.patient.search.criteria.CodeSearchListPopupFeature;
import ca.infodata.util1.IPair;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.MutablePair;
import ca.infodata.util1.StringUtils;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class AbstractCodeCriteria
extends AbstractCriteria {
    private XCodeClassification classification;

    public AbstractCodeCriteria(CID cid, XCodeClassification classification) {
        super(cid);
        this.classification = classification;
    }

    public String getOperatorPrefix() {
        return null;
    }

    public List<? extends ICriteriaOperator> getOperators() {
        List<CriteriaOperator> list = Arrays.asList(CriteriaOperator.IN);
        return list;
    }

    public ICriteriaOperator getDefaultOperator() {
        return CriteriaOperator.IN;
    }

    public Object createValueControl(Composite parent, ICriteriaOperator operator, Object valueReference) {
        final MutablePair value = (MutablePair)(valueReference == null ? new MutablePair() : valueReference);
        value.first = value.first == null ? new LinkedHashSet() : (Set)value.first;
        value.second = value.second == null ? "" : (String)value.second;
        System.out.println(value);
        final Label label = new Label(parent, 18432);
        label.setText(this.computeLabel((Set)value.first, (String)value.second));
        final CodeSearchListPopupFeature<ICode> feature = new CodeSearchListPopupFeature<ICode>((Control)label, (Set)value.first, (String)value.second, this.classification){

            @Override
            protected void modelModified() {
                value.second = this.getAlias();
                label.setText(AbstractCodeCriteria.this.computeLabel((Set)value.first, (String)value.second));
            }
        };
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                feature.openPopupWindow();
            }
        });
        return value;
    }

    protected String computeLabel(Set<ICode> list, String alias) {
        if (StringUtils.isNotBlank((String)alias)) {
            return alias;
        }
        JoinList joinList = new JoinList(",", list.size());
        for (ICode e : list) {
            joinList.add((CharSequence)e.getCode());
        }
        if (joinList.size() == 0) {
            return "Cliquez ici pour ouvrir le dialogue de s\u00e9lection";
        }
        return joinList.toString();
    }

    @Override
    public ServerCriteria toCriteria(ICriteriaOperator operator, Object valueReference) {
        IPair value = (IPair)valueReference;
        ServerCriteria sc = new ServerCriteria();
        sc.id = this.cid;
        sc.operator = Operator.IN;
        sc.value = value.getFirst();
        return sc;
    }

    @Override
    public Map<String, String> valueToXml(ICriteriaOperator operator, Object valueReference) {
        IPair value = (IPair)valueReference;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("classification", this.classification.id);
        map.put("alias", (String)value.getSecond());
        if (value != null) {
            int i = 0;
            for (ICode e : (Set)value.getFirst()) {
                map.put("e" + String.valueOf(i++), this.xmlValueOf(e));
            }
        }
        return map;
    }

    protected String xmlValueOf(ICode e) {
        JoinList joinList = new JoinList(";", 2);
        joinList.setAllowBlank(true);
        joinList.add(e.getId().intValue());
        joinList.add((CharSequence)e.getCode());
        joinList.add((CharSequence)e.getDescription());
        return joinList.toString();
    }

    protected ICode objectValueOf(String xml) {
        if (StringUtils.isBlank((CharSequence)xml)) {
            return null;
        }
        String[] split = StringUtils.splitNonDescructive((String)xml, (char)';');
        if (split.length == 3) {
            XCode code = new XCode();
            code.setId(Integer.valueOf(Integer.parseInt(split[0])));
            code.setCode(split[1]);
            code.setDescriptionShort(split[2]);
            code.setClassification(this.classification);
            return code;
        }
        return null;
    }

    @Override
    public Object xmlToValue(Map<String, String> map) {
        String xmlClassification = map.remove("classification");
        if (!this.classification.id.equals(xmlClassification)) {
            throw new IllegalArgumentException("xml classification is != criteria classififcation . " + xmlClassification + " != " + this.classification.id);
        }
        try {
            MutablePair value = new MutablePair();
            value.second = map.remove("alias");
            value.first = new LinkedHashSet();
            for (String xml : map.values()) {
                ICode code = this.objectValueOf(xml);
                if (code == null) continue;
                ((Set)value.first).add(code);
            }
            System.out.println(value);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

