/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search;

import apple.finder.search.ui.ICriteriaField;
import apple.finder.search.ui.ICriteriaOperator;
import apple.finder.search.ui.IGetFactory;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlGetFactory
implements IGetFactory {
    private Map<ICriteriaField, AbstractCriteria> fields;
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;
    private Document doc;
    private Element root;

    public XmlGetFactory(Map<ICriteriaField, AbstractCriteria> fields) throws Exception {
        this.fields = fields;
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.doc = this.docBuilder.newDocument();
        this.root = this.doc.createElement("root");
        this.doc.appendChild(this.root);
    }

    public String toXml() throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(this.doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        return writer.toString();
    }

    public Object newAndGroup() {
        Element groupElement = this.doc.createElement("AndGroup");
        return groupElement;
    }

    public Object newOrGroup() {
        Element groupElement = this.doc.createElement("OrGroup");
        return groupElement;
    }

    public Object newNotGroup() {
        Element groupElement = this.doc.createElement("NotGroup");
        return groupElement;
    }

    public Object newCriteria(ICriteriaField field, ICriteriaOperator operator, Object valueReference) {
        Element element = this.doc.createElement("Criteria");
        Attr a = this.doc.createAttribute("id");
        a.setValue(field.getId());
        element.setAttributeNode(a);
        a = this.doc.createAttribute("operator");
        a.setValue(operator.getId());
        element.setAttributeNode(a);
        AbstractCriteria c = this.fields.get(field);
        Map<String, String> xml = c.valueToXml(operator, valueReference);
        if (xml != null) {
            for (Map.Entry<String, String> e : xml.entrySet()) {
                String key = e.getKey();
                System.out.println(key);
                Element valueElement = this.doc.createElement(key);
                valueElement.setTextContent(e.getValue());
                element.appendChild(valueElement);
            }
        }
        return element;
    }

    public void addTo(Object parent, Object element) {
        if (parent == null) {
            this.root.appendChild((Node)element);
        } else {
            ((Node)parent).appendChild((Node)element);
        }
    }
}

