/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search;

import apple.finder.search.ui.ICriteriaOperator;
import ca.infodata.ofys.data.middle.dataobjects.search.CID;
import ca.infodata.ofys.data.middle.dataobjects.search.ServerCriteria;
import ca.infodata.ofys.ui.controls.SWTDelayedListener;
import ca.infodata.ofys.ui.controls.SimpleNumberText;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.CriteriaOperator;
import ca.infodata.util1.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractIntegerCriteria
extends AbstractCriteria {
    public AbstractIntegerCriteria(CID cid) {
        super(cid);
    }

    public String getOperatorPrefix() {
        return null;
    }

    public List<? extends ICriteriaOperator> getOperators() {
        List<CriteriaOperator> list = Arrays.asList(CriteriaOperator.IS_NULL, CriteriaOperator.LT, CriteriaOperator.LE, CriteriaOperator.EQ, CriteriaOperator.GE, CriteriaOperator.GT);
        return list;
    }

    public ICriteriaOperator getDefaultOperator() {
        return CriteriaOperator.EQ;
    }

    public Object createValueControl(Composite parent, ICriteriaOperator operator, Object valueReference) {
        if (this.operatorIn(operator, CriteriaOperator.LT, CriteriaOperator.LE, CriteriaOperator.EQ, CriteriaOperator.GE, CriteriaOperator.GT)) {
            final Integer[] value = valueReference == null ? new Integer[1] : valueReference;
            final SimpleNumberText text = new SimpleNumberText(parent, 2048);
            text.getMask().setAllowNegative(false);
            text.setNumber(value[0]);
            text.setMessage("Entrez un nombre entier");
            text.addListener(24, (Listener)new SWTDelayedListener(500L, 24){

                public void handleEventOverride(Event e) {
                    value[0] = text.getNumber();
                }
            });
            return value;
        }
        return null;
    }

    @Override
    public ServerCriteria toCriteria(ICriteriaOperator operator, Object valueReference) {
        ServerCriteria c = new ServerCriteria();
        c.id = this.cid;
        c.operator = ((CriteriaOperator)operator).getOperator();
        c.value = valueReference != null ? ((Integer[])valueReference)[0] : null;
        return c;
    }

    @Override
    public Map<String, String> valueToXml(ICriteriaOperator operator, Object valueReference) {
        Integer number = valueReference == null ? null : ((Integer[])valueReference)[0];
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", number == null ? null : number.toString());
        return map;
    }

    @Override
    public Object xmlToValue(Map<String, String> map) {
        String svalue = map.get("value");
        Integer[] value = new Integer[1];
        if (StringUtils.isNotBlank((String)svalue)) {
            value[0] = Integer.parseInt(svalue);
        }
        return value;
    }
}

