/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter;

import ca.infodata.ofys.client.modules.eform.metadata.IMetaDataType;
import ca.infodata.ofys.client.modules.eform.metadata.MetaDataFactory;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnalSpeciality;
import ca.infodata.ofys.data.middle.dataobjects.consultation.XConsultationItem;
import ca.infodata.ofys.data.middle.dataobjects.consultation.XConsultationRequest;
import ca.infodata.ofys.data.middle.dataobjects.consultation.XConsultationSeverity;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.util.EnumWithValues;
import java.util.EnumSet;

public class ConsultationMetaDataType
extends IMetaDataType<XConsultationRequest> {
    public ConsultationMetaDataType() {
        super(3);
    }

    protected XConsultationRequest buildEncounterObject(Object[] args) throws MetaDataFactory.DataTransformationException {
        try {
            Double idProf = (Double)args[0];
            String note = (String)args[1];
            String destination = null;
            Double severity = null;
            Double profSpeciality = null;
            String itemsS = null;
            if (args.length > 2) {
                destination = (String)args[2];
            }
            if (args.length > 3) {
                severity = (Double)args[3];
            }
            if (args.length > 4) {
                profSpeciality = (Double)args[4];
            }
            if (args.length > 5) {
                itemsS = (String)args[5];
            }
            XConsultationRequest x = new XConsultationRequest();
            XBaseProfessionnal xprof = PersonUiPlugin.getDefault().getBaseProfessionnal(idProf.intValue());
            if (xprof != null) {
                x.setTargetProfessionnal(xprof.getId());
                x.setNote(note);
                x.setDestination(destination);
                x.setSeverity(severity == null ? XConsultationSeverity.NON_URGENT : XConsultationSeverity.from((Integer)severity.intValue()));
                x.setSpeciality((XProfessionnalSpeciality)EnumWithValues.from(XProfessionnalSpeciality.class, profSpeciality == null ? null : Integer.valueOf(profSpeciality.intValue())));
                if (itemsS != null) {
                    String[] items = itemsS.split(";");
                    EnumSet<XConsultationItem> set = EnumSet.noneOf(XConsultationItem.class);
                    int i = 0;
                    while (i < items.length) {
                        boolean haveIt = Boolean.valueOf(items[i]);
                        if (haveIt) {
                            switch (i) {
                                case 0: {
                                    set.add(XConsultationItem.ALLERGY);
                                    break;
                                }
                                case 1: {
                                    set.add(XConsultationItem.INTOLERANCES);
                                    break;
                                }
                                case 2: {
                                    set.add(XConsultationItem.MEDICATION);
                                    break;
                                }
                                case 3: {
                                    set.add(XConsultationItem.PREVIOUS_MEDICAL_HISTORY);
                                    break;
                                }
                                case 4: {
                                    set.add(XConsultationItem.PREVIOUS_FAMILY_HISTORY);
                                    break;
                                }
                                case 5: {
                                    set.add(XConsultationItem.IMMUNIZATION);
                                    break;
                                }
                                case 6: {
                                    set.add(XConsultationItem.HABITUS);
                                    break;
                                }
                                case 7: {
                                    set.add(XConsultationItem.DIAGNOSTIC);
                                    break;
                                }
                                case 8: {
                                    set.add(XConsultationItem.INTERVENTION);
                                }
                            }
                        }
                        ++i;
                    }
                    x.setItems(set);
                }
                x.setIsFromEform(Boolean.valueOf(true));
                x.setTag();
            }
            return x;
        }
        catch (Exception e) {
            throw new MetaDataFactory.DataTransformationException("Type labo avec " + args, (Throwable)e);
        }
    }

    public IMetaDataType<XConsultationRequest> getNewInstance() {
        return new ConsultationMetaDataType();
    }
}

