/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.nightlabs.util.bean.propertyeditor.PropertyEditorUI;
import org.nightlabs.util.bean.propertyeditor.PropertyEditorUIException;

public class BeanUtil {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_ALL_BEANINFO = 3;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    protected int currentMode = 1;

    public BeanUtil(int mode) {
        if (mode != 1 && mode != 3 && mode != 2) {
            throw new IllegalArgumentException("Param mode is neither USE_ALL_BEANINFO nor IGNORE_ALL_BEANINFO nor IGNORE_IMMEDIATE_BEANINFO!");
        }
        this.currentMode = mode;
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(int mode) {
        this.currentMode = mode;
    }

    public static List getBeanMethods(Class beanClass, int flag) throws IntrospectionException {
        Vector<Method[]> propertyMethods = new Vector<Method[]>();
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass, flag);
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        propertyMethods = new Vector(pds.length);
        int i = 0;
        while (i < pds.length) {
            Method[] methods = new Method[2];
            PropertyDescriptor pd = pds[i];
            methods[0] = pd.getReadMethod();
            methods[1] = pd.getWriteMethod();
            propertyMethods.add(methods);
            ++i;
        }
        return propertyMethods;
    }

    public static List getBeanMethods(Class beanClass, Class stopClass) throws IntrospectionException {
        Vector<Method[]> propertyMethods = new Vector<Method[]>();
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass, stopClass);
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        propertyMethods = new Vector(pds.length);
        int i = 0;
        while (i < pds.length) {
            Method[] methods = new Method[2];
            PropertyDescriptor pd = pds[i];
            methods[0] = pd.getReadMethod();
            methods[1] = pd.getWriteMethod();
            propertyMethods.add(methods);
            ++i;
        }
        return propertyMethods;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class beanClass, int flag) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass, flag);
        return beanInfo.getPropertyDescriptors();
    }

    public static List getPropertyDescriptorsAsVector(Class beanClass, int flag) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass, flag);
        PropertyDescriptor[] pdsArray = beanInfo.getPropertyDescriptors();
        Vector<PropertyDescriptor> pdsVector = new Vector<PropertyDescriptor>(pdsArray.length);
        int i = 0;
        while (i < pdsArray.length) {
            pdsVector.add(pdsArray[i]);
            ++i;
        }
        return pdsVector;
    }

    public Map getProperty2Bean2Pd(List beans) throws IntrospectionException {
        List oldProperties = null;
        Vector<String> oldPropertyNames = new Vector<String>();
        HashMap property2Bean2Pd = new HashMap();
        for (Object bean : beans) {
            HashMap bean2pd;
            List pds = BeanUtil.getPropertyDescriptorsAsVector(bean.getClass(), this.getCurrentMode());
            if (oldProperties == null) {
                oldProperties = pds;
                for (PropertyDescriptor pd : oldProperties) {
                    String propertyName = pd.getName();
                    oldPropertyNames.add(propertyName);
                    bean2pd = new HashMap();
                    bean2pd.put(bean, pd);
                    property2Bean2Pd.put(propertyName, bean2pd);
                }
                continue;
            }
            for (PropertyDescriptor newPD : pds) {
                String newProperyName = newPD.getName();
                if (oldPropertyNames.contains(newProperyName)) {
                    bean2pd = (HashMap)property2Bean2Pd.get(newProperyName);
                    bean2pd.put(bean, newPD);
                    continue;
                }
                property2Bean2Pd.remove(newProperyName);
                oldPropertyNames.remove(newProperyName);
            }
        }
        return property2Bean2Pd;
    }

    public static Class getAllBeansSingleClass(List beans) {
        Class<?> firstClass = null;
        boolean sameClass = true;
        for (Object bean : beans) {
            Class<?> beanClass = bean.getClass();
            if (firstClass == null) {
                firstClass = beanClass;
            }
            if (firstClass.equals(beanClass)) continue;
            sameClass = false;
            break;
        }
        return sameClass ? firstClass : null;
    }

    public List getSamePropertyDescriptors(List beans) throws IntrospectionException {
        List oldPropertyDescriptors = null;
        Vector classes = new Vector();
        for (Object bean : beans) {
            List pds = BeanUtil.getPropertyDescriptorsAsVector(bean.getClass(), this.currentMode);
            if (oldPropertyDescriptors == null) {
                oldPropertyDescriptors = pds;
                classes.add(bean.getClass());
                continue;
            }
            if (classes.contains(bean.getClass())) continue;
            classes.add(bean.getClass());
            Vector<Integer> indexes = new Vector<Integer>();
            int i = oldPropertyDescriptors.size() - 1;
            while (i >= 0) {
                PropertyDescriptor oldPD = (PropertyDescriptor)oldPropertyDescriptors.get(i);
                if (!pds.contains(oldPD)) {
                    indexes.add(new Integer(i));
                }
                --i;
            }
            if (indexes.isEmpty()) continue;
            Iterator itIndex = indexes.iterator();
            while (itIndex.hasNext()) {
                int index = (Integer)itIndex.next();
                oldPropertyDescriptors.remove(index);
            }
        }
        return oldPropertyDescriptors;
    }

    public List getPropertyEditorUIsFromPDs(List _propertyDescriptors) {
        Vector<PropertyEditorUI> editorUIs = new Vector<PropertyEditorUI>();
        for (PropertyDescriptor pd : _propertyDescriptors) {
            if (pd == null) continue;
            PropertyEditorUI editorUI = new PropertyEditorUI(pd);
            editorUIs.addElement(editorUI);
        }
        return editorUIs;
    }

    public List getPropertyEditorUIsFromBeans(List _beans) throws IntrospectionException {
        Class classForAllBeans = BeanUtil.getAllBeansSingleClass(_beans);
        if (classForAllBeans != null) {
            List pds = BeanUtil.getPropertyDescriptorsAsVector(classForAllBeans, this.getCurrentMode());
            List editorUIs = this.getPropertyEditorUIsFromPDs(pds);
            return editorUIs;
        }
        List pds = this.getSamePropertyDescriptors(_beans);
        List editorUIs = this.getPropertyEditorUIsFromPDs(pds);
        return editorUIs;
    }

    public static String getPropertyName(String methodName, boolean spaces) {
        String propertyName = "";
        StringBuffer sb = new StringBuffer(methodName);
        if (sb.substring(0, 3).equals("get") || sb.substring(0, 3).equals("set")) {
            propertyName = methodName.substring(3);
        } else if (sb.substring(0, 2).equals("is")) {
            propertyName = methodName.substring(2);
        }
        if (spaces) {
            char[] buff = propertyName.toCharArray();
            int n = buff != null ? buff.length : 0;
            char[] data = new char[n * 2];
            int j = 1;
            data[0] = buff[0];
            int i = 1;
            while (i < n) {
                char c = buff[i];
                if (Character.isUpperCase(c)) {
                    data[j++] = 32;
                }
                data[j++] = c;
                ++i;
            }
            return new String(data, 0, j);
        }
        return propertyName;
    }

    public Object getValue(Object bean, String propertyName) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(bean.getClass(), this.currentMode);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int i = 0;
            while (i < pds.length) {
                PropertyDescriptor pd = pds[i];
                if (pd.getName().equals(propertyName)) {
                    return pd.getValue(propertyName);
                }
                ++i;
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setValue(Object bean, String propertyName) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(bean.getClass(), this.currentMode);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int i = 0;
            while (i < pds.length) {
                PropertyDescriptor pd = pds[i];
                if (pd.getName().equals(propertyName)) {
                    pd.setValue(propertyName, bean);
                }
                ++i;
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public void loadUIValues(List _editorUIs, List _beans) throws PropertyEditorUIException {
        for (PropertyEditorUI editorUI : _editorUIs) {
            editorUI.load(_beans);
        }
    }

    public void loadUIValues(List _editorUIs, Object _bean) throws PropertyEditorUIException {
        for (PropertyEditorUI editorUI : _editorUIs) {
            editorUI.load(_bean);
        }
    }

    public void saveUIValues(List _editorUIs, List _beans) throws PropertyEditorUIException {
        for (PropertyEditorUI editorUI : _editorUIs) {
            editorUI.save(_beans);
        }
    }

    public void saveUIValues(List _editorUIs, Object _bean) throws PropertyEditorUIException {
        for (PropertyEditorUI editorUI : _editorUIs) {
            editorUI.save(_bean);
        }
    }

    public Map getPropertyDescriptors(String _propertyName, List _beans) throws IntrospectionException {
        HashMap bean2Pd = new HashMap();
        for (Object bean : _beans) {
            PropertyDescriptor[] pds = BeanUtil.getPropertyDescriptors(bean.getClass(), this.currentMode);
            int i = 0;
            while (i < pds.length) {
                PropertyDescriptor pd = pds[i];
                if (pd.getName().equals(_propertyName)) {
                    bean2Pd.put(bean, pd);
                }
                ++i;
            }
        }
        return bean2Pd;
    }

    public Map getPropertyEditorUI(String _propertyName, List _beans) throws IntrospectionException {
        HashMap bean2EditorUI = new HashMap();
        for (Object bean : _beans) {
            PropertyDescriptor[] pds = BeanUtil.getPropertyDescriptors(bean.getClass(), this.currentMode);
            int i = 0;
            while (i < pds.length) {
                PropertyDescriptor pd = pds[i];
                if (pd.getName().equals(_propertyName)) {
                    PropertyEditorUI editorUI = new PropertyEditorUI(pd);
                    bean2EditorUI.put(bean, editorUI);
                }
                ++i;
            }
        }
        return bean2EditorUI;
    }
}

