/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.nightlabs.io.DataBuffer;
import org.nightlabs.util.CollectionUtil;

public abstract class Utils {
    public static final String CHARSET_NAME_UTF_8 = "UTF-8";
    public static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    public static final long GIGABYTE = 0x40000000L;
    private static File tempDir = null;

    public static String addFinalSlash(String directory) {
        if (directory.endsWith(File.separator)) {
            return directory;
        }
        return String.valueOf(directory) + File.separator;
    }

    public static String int2StringMinDigits(int i, int minDigits) {
        String s = Integer.toString(i);
        if (s.length() < minDigits) {
            StringBuffer sBuf = new StringBuffer(s);
            while (sBuf.length() < minDigits) {
                sBuf.insert(0, '0');
            }
            s = sBuf.toString();
        }
        return s;
    }

    public static String getRelativePath(String baseDir, String file) throws IOException {
        return Utils.getRelativePath(new File(baseDir), file);
    }

    public static String getRelativePath(File baseDir, File file) throws IOException {
        return Utils.getRelativePath(baseDir, file.getPath());
    }

    public static String simplifyPath(File path) {
        LinkedList<String> dirs = new LinkedList<String>();
        String pathStr = path.getAbsolutePath();
        boolean startWithSeparator = pathStr.startsWith(File.separator);
        StringTokenizer tk = new StringTokenizer(pathStr, File.separator, false);
        while (tk.hasMoreTokens()) {
            String dir = tk.nextToken();
            if (".".equals(dir)) continue;
            if ("..".equals(dir)) {
                if (dirs.isEmpty()) continue;
                dirs.removeLast();
                continue;
            }
            dirs.addLast(dir);
        }
        StringBuffer sb = new StringBuffer();
        for (String dir : dirs) {
            if (startWithSeparator || sb.length() > 0) {
                sb.append(File.separator);
            }
            sb.append(dir);
        }
        return sb.toString();
    }

    private static String _getRelativePath(File baseDir, String file) throws IOException {
        if (!baseDir.isAbsolute()) {
            throw new IllegalArgumentException("baseDir \"" + baseDir.getPath() + "\" is not absolute!");
        }
        File tmpF = new File(file);
        File absFile = tmpF.isAbsolute() ? tmpF : new File(baseDir, file);
        String absFileStr = null;
        String baseDirStr = null;
        int mode_base = 0;
        while (mode_base < 2) {
            switch (mode_base) {
                case 0: {
                    baseDirStr = Utils.simplifyPath(baseDir);
                    break;
                }
                case 1: {
                    baseDirStr = baseDir.getCanonicalPath();
                    break;
                }
                default: {
                    throw new IllegalStateException("this should never happen!");
                }
            }
            int mode_abs = 0;
            while (mode_abs < 2) {
                baseDirStr = Utils.addFinalSlash(baseDirStr);
                switch (mode_abs) {
                    case 0: {
                        absFileStr = Utils.simplifyPath(absFile);
                        break;
                    }
                    case 1: {
                        absFileStr = absFile.getCanonicalPath();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("this should never happen!");
                    }
                }
                if (absFileStr.startsWith(baseDirStr)) break;
                if (mode_base >= 1 && mode_abs >= 1) {
                    return null;
                }
                ++mode_abs;
            }
            ++mode_base;
        }
        if (baseDirStr == null) {
            throw new NullPointerException("baseDirStr == null");
        }
        if (absFileStr == null) {
            throw new NullPointerException("absFileStr == null");
        }
        return absFileStr.substring(baseDirStr.length(), absFileStr.length());
    }

    public static String getRelativePath(File baseDir, String file) throws IOException {
        File tmpF = new File(file);
        File absFile = tmpF.isAbsolute() ? tmpF : new File(baseDir, file);
        File dest = absFile;
        File b = baseDir;
        String up = "";
        while (b.getParentFile() != null) {
            String res = Utils._getRelativePath(b, dest.getAbsolutePath());
            if (res != null) {
                return String.valueOf(up) + res;
            }
            up = "../" + up;
            b = b.getParentFile();
        }
        return absFile.getAbsolutePath();
    }

    public static long transferStreamData(InputStream in, OutputStream out) throws IOException {
        return Utils.transferStreamData(in, out, 0L, -1L);
    }

    public static boolean equals(Object obj0, Object obj1) {
        if (obj0 instanceof Object[] && obj1 instanceof Object[]) {
            return obj0 == obj1 || Arrays.equals((Object[])obj0, (Object[])obj1);
        }
        return obj0 == obj1 || obj0 != null && obj0.equals(obj1);
    }

    public static int hashCode(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public static boolean deleteDirectoryRecursively(String dir) {
        File dirF = new File(dir);
        return Utils.deleteDirectoryRecursively(dirF);
    }

    public static boolean deleteDirectoryRecursively(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (dir.isDirectory()) {
            File[] content = dir.listFiles();
            int i = 0;
            while (i < content.length) {
                File f = content[i];
                if (f.isDirectory()) {
                    Utils.deleteDirectoryRecursively(f);
                } else {
                    f.delete();
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static File createUniqueRandomFolder(File rootFolder, String prefix) {
        return Utils.createUniqueRandomFolder(rootFolder, prefix, 10000L, 10000L);
    }

    public static File createUniqueRandomFolder(File rootFolder, String prefix, long maxIterations, long uniqueOutOf) {
        final StringBuffer buff = new StringBuffer();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(buff.toString());
            }
        };
        long count = 0L;
        do {
            buff.setLength(0);
            buff.append(prefix);
            buff.append(Long.toHexString((long)(Math.random() * (double)uniqueOutOf)));
            if (++count <= maxIterations) continue;
            throw new RuntimeException("Reached end of maxIteration(" + maxIterations + "), but could not acquire a unique fileName for folder " + rootFolder);
        } while (rootFolder.list(filter).length > 0);
        return new File(rootFolder, buff.toString());
    }

    public static File createUniqueIncrementalFolder(File rootFolder, String prefix) {
        final StringBuffer buff = new StringBuffer();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(buff.toString());
            }
        };
        int count = 0;
        do {
            buff.setLength(0);
            buff.append(prefix);
            buff.append(Integer.toHexString(count++));
            if (count >= 0) continue;
            throw new RuntimeException("Iterated to Integer.MAX_VALUE and could not find a unique folder!");
        } while (rootFolder.list(filter).length > 0);
        return new File(rootFolder, buff.toString());
    }

    public static long transferStreamData(InputStream in, OutputStream out, long inputOffset, long inputLen) throws IOException {
        int bytesRead;
        int transferred = 0;
        byte[] buf = new byte[4096];
        if (inputOffset > 0L && in.skip(inputOffset) != inputOffset) {
            throw new IOException("Input skip failed (offset " + inputOffset + ")");
        }
        while ((bytesRead = inputLen >= 0L ? in.read(buf, 0, (int)Math.min((long)buf.length, inputLen - (long)transferred)) : in.read(buf)) > 0) {
            out.write(buf, 0, bytesRead);
            if (inputLen < 0L || (long)(transferred += bytesRead) < inputLen) continue;
        }
        out.flush();
        return transferred;
    }

    public static void copyResource(Class sourceResClass, String sourceResName, String dest_name) throws IOException {
        File destination_file = new File(dest_name);
        Utils.copyResource(sourceResClass, sourceResName, destination_file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyResource(Class sourceResClass, String sourceResName, File destination_file) throws IOException {
        InputStream source = null;
        FileOutputStream destination = null;
        try {
            source = sourceResClass.getResourceAsStream(sourceResName);
            if (source == null) {
                throw new FileNotFoundException("Class " + sourceResClass.getName() + " could not find resource " + sourceResName);
            }
            if (destination_file.exists()) {
                if (!destination_file.isFile()) throw new IOException("FileCopy: destination is not a file: " + destination_file.getCanonicalPath());
                if (!destination_file.canWrite()) {
                    throw new IOException("FileCopy: destination file is unwriteable: " + destination_file.getCanonicalPath());
                }
            } else {
                File parentdir = Utils.parent(destination_file);
                if (!parentdir.exists()) {
                    throw new IOException("FileCopy: destination directory doesn't exist: " + destination_file.getCanonicalPath());
                }
                if (!parentdir.canWrite()) {
                    throw new IOException("FileCopy: destination directory is unwriteable: " + destination_file.getCanonicalPath());
                }
            }
            destination = new FileOutputStream(destination_file);
            Utils.transferStreamData(source, destination);
        }
        catch (Throwable throwable) {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (destination == null) throw throwable;
            try {
                destination.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (source != null) {
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
        if (destination == null) return;
        try {
            destination.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static void copyFile(String source_name, String dest_name) throws IOException {
        File source_file = new File(source_name);
        File destination_file = new File(dest_name);
        Utils.copyFile(source_file, destination_file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(File source_file, File destination_file) throws IOException {
        FileInputStream source = null;
        FileOutputStream destination = null;
        try {
            if (!source_file.exists() || !source_file.isFile()) {
                throw new IOException("FileCopy: no such source file: " + source_file.getCanonicalPath());
            }
            if (!source_file.canRead()) {
                throw new IOException("FileCopy: source file is unreadable: " + source_file.getCanonicalPath());
            }
            if (destination_file.exists()) {
                if (!destination_file.isFile()) throw new IOException("FileCopy: destination is not a file: " + destination_file.getCanonicalPath());
                if (!destination_file.canWrite()) {
                    throw new IOException("FileCopy: destination file is unwriteable: " + destination_file.getCanonicalPath());
                }
            } else {
                File parentdir = Utils.parent(destination_file);
                if (!parentdir.exists()) {
                    throw new IOException("FileCopy: destination directory doesn't exist: " + destination_file.getCanonicalPath());
                }
                if (!parentdir.canWrite()) {
                    throw new IOException("FileCopy: destination directory is unwriteable: " + destination_file.getCanonicalPath());
                }
            }
            source = new FileInputStream(source_file);
            destination = new FileOutputStream(destination_file);
            Utils.transferStreamData(source, destination);
        }
        catch (Throwable throwable) {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (destination == null) throw throwable;
            try {
                destination.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (source != null) {
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
        if (destination == null) return;
        try {
            destination.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private static File parent(File f) {
        String dirname = f.getParent();
        if (dirname == null) {
            return new File(File.separator);
        }
        return new File(dirname);
    }

    public static String addLeadingZeros(String base, int strLength) {
        StringBuffer sb = new StringBuffer(strLength);
        int i = 0;
        while (i < strLength - base.length()) {
            sb.append('0');
            ++i;
        }
        sb.append(base);
        return sb.toString();
    }

    public static String encodeHexStr(byte[] buf) {
        return Utils.encodeHexStr(buf, 0, buf.length);
    }

    @Deprecated
    public static String decodeHexStr(byte[] buf, int pos, int len) {
        return Utils.encodeHexStr(buf, pos, len);
    }

    public static byte[] decodeHexStr(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("The hex string must have an even number of characters!");
        }
        byte[] res = new byte[hex.length() / 2];
        int m = 0;
        int i = 0;
        while (i < hex.length()) {
            res[m++] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
            i += 2;
        }
        return res;
    }

    public static String encodeHexStr(byte[] buf, int pos, int len) {
        StringBuffer hex = new StringBuffer();
        while (len-- > 0) {
            byte ch;
            int d;
            hex.append((char)((d = (ch = buf[pos++]) >> 4 & 0xF) >= 10 ? 87 + d : 48 + d));
            d = ch & 0xF;
            hex.append((char)(d >= 10 ? 87 + d : 48 + d));
        }
        return hex.toString();
    }

    public static String getMD5HexString(String clear) throws NoSuchAlgorithmException {
        byte[] enc = MessageDigest.getInstance("MD5").digest(clear.getBytes());
        return Utils.encodeHexStr(enc, 0, enc.length);
    }

    public static String htmlEncode(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\n') {
                sb.append("<br>");
            } else if (ch == '<') {
                sb.append("&lt;");
            } else if (ch == '>') {
                sb.append("&gt;");
            } else if (ch == '\t') {
                sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    @Deprecated
    public static <T> ArrayList<T> array2ArrayList(T[] objects) {
        return CollectionUtil.array2ArrayList(objects);
    }

    @Deprecated
    public static <T> ArrayList<T> array2ArrayList(T[] objects, boolean canReturnNull) {
        return CollectionUtil.array2ArrayList(objects, canReturnNull);
    }

    @Deprecated
    public static <T> HashSet<T> array2HashSet(T[] objects) {
        return CollectionUtil.array2HashSet(objects);
    }

    @Deprecated
    public static <T> HashSet<T> array2HashSet(T[] objects, boolean canReturnNull) {
        return CollectionUtil.array2HashSet(objects, canReturnNull);
    }

    @Deprecated
    public static <T> T[] collection2TypedArray(Collection<T> c, Class<T> clazz) {
        return CollectionUtil.collection2TypedArray(c, clazz);
    }

    @Deprecated
    public static <T> T[] collection2TypedArray(Collection<T> c, Class<T> clazz, boolean canReturnNull) {
        return CollectionUtil.collection2TypedArray(c, clazz, canReturnNull);
    }

    @Deprecated
    public static void moveListElementUp(List list, Object element) {
        CollectionUtil.moveListElementUp(list, element);
    }

    @Deprecated
    public static void moveListElementDown(List list, Object element) {
        CollectionUtil.moveListElementDown(list, element);
    }

    public static String readTextFile(File f) throws FileNotFoundException, IOException {
        return Utils.readTextFile(f, CHARSET_NAME_UTF_8);
    }

    public static String readTextFile(File f, String encoding) throws FileNotFoundException, IOException {
        if (f.length() > 0x40000000L) {
            throw new IllegalArgumentException("File exceeds 1073741824 bytes: " + f.getAbsolutePath());
        }
        StringBuffer sb = new StringBuffer();
        try (FileInputStream fin = new FileInputStream(f);
             InputStreamReader reader = new InputStreamReader((InputStream)fin, encoding);){
            int bytesRead;
            char[] cbuf = new char[1024];
            while ((bytesRead = reader.read(cbuf)) > 0) {
                sb.append(cbuf, 0, bytesRead);
            }
        }
        return sb.toString();
    }

    public static String readTextFile(InputStream in) throws FileNotFoundException, IOException {
        return Utils.readTextFile(in, CHARSET_NAME_UTF_8);
    }

    public static String readTextFile(InputStream in, String encoding) throws FileNotFoundException, IOException {
        int bytesRead;
        StringBuffer sb = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(in, encoding);
        char[] cbuf = new char[1024];
        while ((bytesRead = reader.read(cbuf)) > 0) {
            sb.append(cbuf, 0, bytesRead);
            if ((long)sb.length() <= 0x40000000L) continue;
            throw new IllegalArgumentException("Text exceeds 1073741824 bytes!");
        }
        return sb.toString();
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex < 0) {
            return null;
        }
        return fileName.substring(lastIndex + 1);
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int lastIndex = fileName.lastIndexOf(".");
        if (lastIndex < 0) {
            return fileName;
        }
        return fileName.substring(0, lastIndex);
    }

    public static File getTempDir() throws IOException {
        if (tempDir == null) {
            File tmp = File.createTempFile("tmp.", ".tmp");
            File res = tmp.getParentFile();
            if (!res.isAbsolute()) {
                res = res.getAbsoluteFile();
            }
            tempDir = res;
            tmp.delete();
        }
        return tempDir;
    }

    public static byte[] generateUniqueKey(byte[] data, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean compareByteArrays(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        int i = 0;
        while (i < b1.length) {
            byte byte1 = b1[i];
            byte byte2 = b2[i];
            if (byte1 != byte2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean compareInputStreams(InputStream in1, InputStream in2, int length) throws IOException {
        boolean identical = true;
        int i = 0;
        while (i < length) {
            int int2;
            int int1 = in1.read();
            if (int1 != (int2 = in2.read())) {
                identical = false;
                System.out.println("Byte " + i + " differs.");
            }
            ++i;
        }
        return identical;
    }

    public static void zipFolder(File zipOutputFile, File zipInputFolder) throws IOException {
        FileOutputStream fout = new FileOutputStream(zipOutputFile);
        try (ZipOutputStream out = new ZipOutputStream(fout);){
            File[] files = zipInputFolder.listFiles();
            Utils.zipFilesRecursively(out, zipOutputFile, files, zipInputFolder.getAbsoluteFile());
        }
    }

    public static void zipFilesRecursively(ZipOutputStream out, File zipOutputFile, File[] files, File entryRoot) throws IOException {
        if (entryRoot == null && files == null) {
            throw new IllegalArgumentException("entryRoot and files must not both be null!");
        }
        if (entryRoot != null && !entryRoot.isDirectory()) {
            throw new IllegalArgumentException("entryRoot is not a directory!");
        }
        if (files == null) {
            files = new File[]{entryRoot};
        }
        byte[] buf = new byte[5120];
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (zipOutputFile == null || !file.equals(zipOutputFile)) {
                if (file.isDirectory()) {
                    File[] dirFiles = file.listFiles();
                    Utils.zipFilesRecursively(out, zipOutputFile, dirFiles, entryRoot);
                } else {
                    int len;
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                    String relativePath = entryRoot == null ? file.getName() : Utils.getRelativePath(entryRoot, file.getAbsoluteFile());
                    ZipEntry entry = new ZipEntry(relativePath);
                    entry.setTime(file.lastModified());
                    out.putNextEntry(entry);
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                }
            }
            ++i;
        }
    }

    public static void unzipArchive(File zipArchive, File unzipRootFolder) throws IOException {
        ZipFile zipFile = new ZipFile(zipArchive);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                File dir = new File(unzipRootFolder, entry.getName());
                if (dir.mkdirs()) continue;
                throw new IllegalStateException("Could not create directory entry, possibly permission issues.");
            }
            InputStream in = zipFile.getInputStream(entry);
            File file = new File(unzipRootFolder, entry.getName());
            File dir = new File(file.getParent());
            if (dir.exists()) {
                assert (dir.isDirectory());
            } else {
                dir.mkdirs();
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buf = new byte[5120];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
        zipFile.close();
    }

    public static void main(String[] args) {
        byte[] buf = Utils.decodeHexStr("a4ff0200f2");
        System.out.println(Utils.encodeHexStr(buf));
    }

    @Deprecated
    public static <T extends Enum<T>> List<T> enum2List(Enum<T> e) {
        return CollectionUtil.enum2List(e);
    }

    public static double shortenDouble(double d, int numDigits) {
        double multiplier = Math.pow(10.0, numDigits);
        double shortedValue = (double)((int)(d * multiplier)) / multiplier;
        return shortedValue;
    }

    public static double getDouble(int value, int numDigits) {
        double multiplier = Math.pow(10.0, numDigits);
        return (double)value / multiplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T cloneSerializable(T original) {
        DataBuffer db;
        try {
            db = new DataBuffer(10240L);
            try (ObjectOutputStream out = new ObjectOutputStream(db.createOutputStream());){
                out.writeObject(original);
            }
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        try (ObjectInputStream in = new ObjectInputStream(db.createInputStream());){
            Object object = in.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException x) {
            throw new RuntimeException(x);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    @Deprecated
    public static String getStacktraceAsString(Throwable t) {
        return Utils.getStackTraceAsString(t);
    }

    public static String getStackTraceAsString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static void toFieldString(Object o, StringBuffer s) {
        Field[] fields = o.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            s.append(",");
            s.append(fields[i].getName());
            s.append("=");
            try {
                fields[i].setAccessible(true);
                s.append(fields[i].get(o));
            }
            catch (IllegalAccessException illegalAccessException) {
                s.append("*private*");
            }
            ++i;
        }
    }

    public static String toFieldString(Object o) {
        StringBuffer s = new StringBuffer();
        Utils.toFieldString(o, s);
        return s.toString();
    }

    public static String toString(Object o) {
        StringBuffer s = new StringBuffer();
        s.append(o.getClass().getName());
        s.append("@");
        s.append(Integer.toHexString(o.hashCode()));
        s.append("[");
        Utils.toFieldString(o, s);
        s.append("]");
        return s.toString();
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        int i = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        while (i < in.length) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            ++i;
        }
        return out.toString();
    }
}

