/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.lang.ref.Reference;
import java.util.ArrayList;

public class ReferenceList
extends ArrayList {
    protected static boolean referenceEquals(Reference ref, Object other) {
        if (ref == null) {
            throw new NullPointerException("Param ref must not be null!");
        }
        if (other instanceof Reference) {
            Reference otherRef = (Reference)other;
            if (ref.get() == null) {
                return otherRef.get() == null;
            }
            return ref.get().equals(otherRef.get());
        }
        if (ref.get() == null) {
            return other == null;
        }
        return ref.get().equals(other);
    }

    @Override
    public void add(int index, Object reference) {
        if (reference == null) {
            throw new NullPointerException("Param reference must not be null!");
        }
        if (!(reference instanceof Reference)) {
            throw new IllegalArgumentException("Can only add descendants of Reference!");
        }
        super.add(index, reference);
    }

    @Override
    public boolean add(Object reference) {
        if (reference == null) {
            throw new NullPointerException("Param reference must not be null!");
        }
        if (!(reference instanceof Reference)) {
            throw new IllegalArgumentException("Can only add descendants of Reference!");
        }
        return super.add(reference);
    }

    @Override
    public int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(Object elem, int index) {
        if (elem == null) {
            throw new NullPointerException("Param elem must not be null!");
        }
        int i = index;
        while (i < this.size()) {
            if (ReferenceList.referenceEquals((Reference)this.get(i), elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.size() - 1);
    }

    public int lastIndexOf(Object elem, int index) {
        if (elem == null) {
            throw new NullPointerException("Param elem must not be null!");
        }
        int i = index;
        while (i >= 0) {
            if (ReferenceList.referenceEquals((Reference)this.get(i), elem)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public boolean remove(Object o) {
        return super.remove(o);
    }
}

