/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.awt.Font;
import java.awt.GraphicsEnvironment;

public class FontUtil {
    public static final Font DEFAULT_FONT = new Font("Arial", 0, 24);
    protected static String[] fontSizes = new String[]{"8", "10", "12", "14", "16", "18", "24", "30", "36", "48"};
    protected static String[] systemFonts;

    protected FontUtil() {
    }

    public static String[] getFontSizes() {
        return fontSizes;
    }

    public static String[] getSystemFonts() {
        if (systemFonts == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            systemFonts = ge.getAvailableFontFamilyNames();
        }
        return systemFonts;
    }

    public static void initSystemFonts() {
        FontUtil.getSystemFonts();
    }

    public static boolean isFontAvailable(String fontName) {
        int j = 0;
        while (j < FontUtil.getSystemFonts().length) {
            String f = FontUtil.getSystemFonts()[j];
            if (f.equals(fontName)) {
                return true;
            }
            ++j;
        }
        return false;
    }
}

