/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class CacheDirTag {
    private static final Logger logger = Logger.getLogger(CacheDirTag.class);
    private File cacheDir;
    private File cacheDirTagFile;
    public static final String CACHE_DIR_TAG_FILE = "CACHEDIR.TAG";
    public static final char[] CACHE_DIR_SIGNATURE = "Signature: 8a477f597d28d172789f06886806bc55".toCharArray();

    public CacheDirTag(File cacheDir) {
        this.cacheDir = cacheDir;
        this.cacheDirTagFile = new File(cacheDir, CACHE_DIR_TAG_FILE);
    }

    public void tag(String applicationName, boolean createDir, boolean retag) throws FileNotFoundException, IOException {
        if (!this.cacheDir.exists()) {
            if (!createDir) {
                throw new FileNotFoundException("The cache directory does not exist and createDir==false: " + this.cacheDir.getAbsolutePath());
            }
            if (!this.cacheDir.mkdirs()) {
                throw new FileNotFoundException("Creating cache directory failed: " + this.cacheDir.getAbsolutePath());
            }
        }
        if (this.isTagged() && !retag) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache directory is correctly tagged and will not be retagged: " + this.cacheDir.getAbsolutePath()));
            }
            return;
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.cacheDirTagFile));
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");){
            w.write(CACHE_DIR_SIGNATURE);
            ((Writer)w).write(10);
            w.write("# This file is a cache directory tag created by:\n");
            w.write("# \t" + applicationName + "\n");
            w.write("# \n");
            w.write("# Creation timestamp:\n");
            w.write("# \t" + System.currentTimeMillis() + "\n");
            w.write("# \n");
            w.write("# For information about cache directory tags, see:\n");
            w.write("# \thttp://www.brynosaurus.com/cachedir/\n");
        }
    }

    public boolean isTagged() throws IOException {
        if (!this.cacheDir.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache directory does not exist: " + this.cacheDir.getAbsolutePath()));
            }
            return false;
        }
        if (!this.cacheDirTagFile.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache dir tag file does not exist: " + this.cacheDirTagFile.getAbsolutePath()));
            }
            return false;
        }
        if (this.cacheDirTagFile.length() < (long)CACHE_DIR_SIGNATURE.length) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache dir tag file is shorter than required signature length (" + CACHE_DIR_SIGNATURE.length + "): " + this.cacheDirTagFile.getAbsolutePath()));
            }
            return false;
        }
        try (FileInputStream fin = new FileInputStream(this.cacheDirTagFile);){
            InputStreamReader r;
            block18: {
                block16: {
                    block17: {
                        r = new InputStreamReader((InputStream)fin, "UTF-8");
                        try {
                            int off = 0;
                            char[] cbuf = new char[CACHE_DIR_SIGNATURE.length];
                            int bytesRead = 0;
                            while (bytesRead >= 0 && off < CACHE_DIR_SIGNATURE.length) {
                                bytesRead = ((Reader)r).read(cbuf, off, CACHE_DIR_SIGNATURE.length - off);
                                if (bytesRead <= 0) continue;
                                off += bytesRead;
                            }
                            if (off < CACHE_DIR_SIGNATURE.length) {
                                throw new IOException("Even though the file claims to be long enough, I could only read " + off + " of " + CACHE_DIR_SIGNATURE.length + " bytes from the cache dir tag file: " + this.cacheDirTagFile.getAbsolutePath());
                            }
                            if (!Arrays.equals(CACHE_DIR_SIGNATURE, cbuf)) break block16;
                            if (!logger.isDebugEnabled()) break block17;
                            logger.debug((Object)("The cache dir tag file exists and is valid: " + this.cacheDirTagFile.getAbsolutePath()));
                        }
                        catch (Throwable throwable) {
                            ((Reader)r).close();
                            throw throwable;
                        }
                    }
                    ((Reader)r).close();
                    return true;
                }
                if (!logger.isDebugEnabled()) break block18;
                logger.debug((Object)("The first " + CACHE_DIR_SIGNATURE.length + " bytes of the cache dir tag file are not a valid cache dir signature! File: " + this.cacheDirTagFile.getAbsolutePath()));
            }
            ((Reader)r).close();
            return false;
        }
    }
}

