/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Binary {
    public InputStream in = null;
    public OutputStream out = null;
    public static String CHARSET = "ISO-8859-1";

    public Binary(InputStream in) {
        this.in = in;
    }

    public Binary(OutputStream out) {
        this.out = out;
    }

    public int read() throws IOException {
        if (this.in == null) {
            throw new IllegalStateException("This binary is in write mode! Can't execute read()!");
        }
        return this.in.read();
    }

    public long skip(long n) throws IOException {
        if (this.in == null) {
            throw new IllegalStateException("This binary is in write mode! Can't execute skip()!");
        }
        return this.in.skip(n);
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    private long readReversedBytes(int byteCount) throws IOException {
        if (byteCount > 8) {
            throw new IllegalArgumentException("nByteCount > 8!!!");
        }
        if (byteCount < 1) {
            throw new IllegalArgumentException("nByteCount < 1!!!");
        }
        long[] bBytes = new long[byteCount];
        int i = 0;
        while (i < byteCount) {
            bBytes[i] = this.read();
            ++i;
        }
        long nResult = 0L;
        int i2 = byteCount - 1;
        while (i2 > 0) {
            nResult |= (0xFFL & bBytes[i2]) << 8 * i2;
            --i2;
        }
        return nResult |= bBytes[0];
    }

    public byte readByte() throws IOException {
        int res = this.read();
        if (res < 0) {
            throw new EOFException("Cannot read one more byte!");
        }
        return (byte)res;
    }

    public int readUnsignedByte() throws IOException {
        int res = this.read();
        if (res < 0) {
            throw new EOFException("Cannot read one more byte!");
        }
        return res;
    }

    public short readReversedShort() throws IOException {
        return (short)this.readReversedBytes(2);
    }

    public int readReversedUnsignedShort() throws IOException {
        return (int)this.readReversedBytes(2);
    }

    public int readReversedInt() throws IOException {
        return (int)this.readReversedBytes(4);
    }

    public long readReversedUnsignedInt() throws IOException {
        long nTest = this.readReversedBytes(4);
        return nTest;
    }

    public String readString() throws IOException {
        StringBuffer sRead = new StringBuffer();
        int c = this.read();
        while (c != 0) {
            sRead.append((char)c);
            c = this.read();
        }
        return sRead.toString();
    }

    public String readString(int _length) throws IOException {
        StringBuffer sRead = new StringBuffer();
        int i = 0;
        while (i < _length) {
            int c = this.read();
            sRead.append((char)c);
            ++i;
        }
        return sRead.toString();
    }

    public int readNumber() throws NumberFormatException, IOException {
        StringBuffer sRead = new StringBuffer();
        if (this.in.markSupported()) {
            this.in.mark(256);
        }
        boolean doReset = true;
        try {
            int c = this.read();
            while (c == 48 || c == 49 || c == 50 || c == 51 || c == 52 || c == 53 || c == 54 || c == 55 || c == 56 || c == 57) {
                sRead.append((char)c);
                c = this.read();
            }
            doReset = false;
        }
        finally {
            if (doReset && this.in.markSupported()) {
                this.in.reset();
            }
        }
        return Integer.parseInt(sRead.toString());
    }

    public long readReversedLong() throws IOException {
        long nTest = this.readReversedBytes(8);
        return nTest;
    }

    private void writeReversedBytes(byte[] bytes) throws IOException {
        byte[] rBytes = new byte[bytes.length];
        int m = 0;
        int i = bytes.length - 1;
        while (i >= 0) {
            rBytes[m++] = bytes[i];
            --i;
        }
        this.out.write(rBytes);
    }

    public void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public byte[] getByteArray(long v, int length) {
        byte[] b = new byte[length];
        int i = 0;
        int shift = (length - 1) * 8;
        while (i < length) {
            b[i] = (byte)(v >> shift);
            ++i;
            shift -= 8;
        }
        return b;
    }

    public void writeReversedUnsignedByte(short val) throws IOException {
        this.writeReversedBytes(this.getByteArray(val, 1));
    }

    public void writeReversedUnsignedShort(int val) throws IOException {
        this.writeReversedBytes(this.getByteArray(val, 2));
    }

    public void writeReversedShort(short val) throws IOException {
        this.writeReversedBytes(this.getByteArray(val, 2));
    }

    public void writeReversedUnsignedInt(long val) throws IOException {
        this.writeReversedBytes(this.getByteArray(val, 4));
    }

    public void writeReversedInt(int val) throws IOException {
        this.writeReversedBytes(this.getByteArray(val, 4));
    }

    public void writeString(String s) throws IOException {
        this.write(s.getBytes(CHARSET));
        this.write(0);
    }

    public void writeString(String s, int length) throws IOException {
        if (s.length() != length) {
            throw new IllegalArgumentException("Param length does not match String.length()! s=\"" + s + "\" length=\"" + length + "\"");
        }
        this.write(s.getBytes(CHARSET));
    }
}

