/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io.pcx;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import org.nightlabs.io.pcx.PCXHeader;
import org.nightlabs.util.Binary;

public class PCXWriter {
    public void write(OutputStream out, BufferedImage image) throws IOException {
        Binary binary = new Binary(out);
        PCXHeader pcxHeader = new PCXHeader(image);
        pcxHeader.write(binary);
        int bytesPerLine = pcxHeader.getBytesPerLine();
        int height = pcxHeader.getHeight();
        WritableRaster raster = image.getRaster();
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < bytesPerLine) {
                int byteValue = PCXWriter.get8BlackWhitePixels(col, row, raster);
                int byteCount = 1;
                ++col;
                while (col < bytesPerLine) {
                    int nextByteValue = PCXWriter.get8BlackWhitePixels(col, row, raster);
                    if (byteValue != nextByteValue) break;
                    ++col;
                    if (++byteCount == 63) break;
                }
                if (byteCount > 1 || byteValue > 63) {
                    int b = byteCount | 0xC0;
                    binary.write(b);
                    binary.write(byteValue);
                    continue;
                }
                binary.write(byteValue);
            }
            ++row;
        }
    }

    protected static int get8BlackWhitePixels(int col, int row, WritableRaster raster) {
        int xmax = raster.getBounds().width - 1;
        int res = 0;
        int[] iArray = new int[1];
        int base = col * 8;
        int i = 0;
        while (i < 8) {
            if (base + i > xmax) {
                iArray[0] = 1;
            } else {
                raster.getPixel(base + i, row, iArray);
            }
            res |= iArray[0] << 7 - i;
            ++i;
        }
        return res;
    }
}

