/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io;

import java.io.IOException;
import java.io.OutputStream;
import org.nightlabs.io.DataBuffer;

public class DataBufferOutputStream
extends OutputStream {
    DataBuffer dataBuffer;
    protected boolean closed = false;
    byte[] oneByteByteArray = null;

    protected DataBufferOutputStream(DataBuffer _dataBuffer) {
        this.dataBuffer = _dataBuffer;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.dataBuffer.closeOutputStream();
        this.closed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream is already closed!");
        }
        this.dataBuffer.flushOutputStream();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream is already closed!");
        }
        this.dataBuffer.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream is already closed!");
        }
        this.dataBuffer.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("OutputStream is already closed!");
        }
        if (this.oneByteByteArray == null) {
            this.oneByteByteArray = new byte[1];
        }
        this.oneByteByteArray[0] = (byte)b;
        this.dataBuffer.write(this.oneByteByteArray, 0, 1);
    }
}

