/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.eclipse.ui.pdfviewer;

import java.awt.geom.Point2D;

public class Point2DDouble
extends Point2D {
    private volatile boolean readOnly;
    private double x;
    private double y;

    public Point2DDouble() {
    }

    public Point2DDouble(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point2DDouble(Point2D other) {
        this.x = other.getX();
        this.y = other.getY();
    }

    private void assertNotReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("This instance of Dimension2DDouble is read-only!");
        }
    }

    @Override
    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.assertNotReadOnly();
        this.x = x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.assertNotReadOnly();
        this.y = y;
    }

    @Override
    public void setLocation(double x, double y) {
        this.assertNotReadOnly();
        this.x = x;
        this.y = y;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj.getClass() != this.getClass() && !(obj instanceof Point2D)) {
            return false;
        }
        Point2D other = (Point2D)obj;
        return this.x == other.getX() && this.y == other.getY();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '@' + Integer.toHexString(System.identityHashCode(this)) + '[' + this.x + ',' + this.y + ']';
    }
}

