/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.log;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

class FrameworkLogRecord
extends LogRecord {
    private static final long serialVersionUID = 1L;
    private final int code;
    private final int stackCode;
    private final List<FrameworkLogRecord> children;

    private FrameworkLogRecord(String plugin, Level level, int code, String message, int stackCode, Throwable thrown, List<FrameworkLogRecord> children) {
        super(level, message);
        this.code = code;
        this.stackCode = stackCode;
        this.children = children == null ? null : new ArrayList<FrameworkLogRecord>(children);
        this.setLoggerName(plugin);
        this.setThrown(thrown);
    }

    static FrameworkLogRecord getLog(IStatus status) {
        IStatus coreStatus;
        int stackCode;
        Throwable t = status.getException();
        ArrayList<FrameworkLogRecord> children = new ArrayList<FrameworkLogRecord>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            children.add(FrameworkLogRecord.getLog(coreStatus));
        }
        if (status.isMultiStatus()) {
            IStatus[] schildren = status.getChildren();
            int i = 0;
            while (i < schildren.length) {
                children.add(FrameworkLogRecord.getLog(schildren[i]));
                ++i;
            }
        }
        StringBuilder sb = new StringBuilder(status.getMessage());
        sb.append(" code=");
        sb.append(status.getCode());
        sb.append(" stackCode=");
        sb.append(stackCode);
        String message = sb.toString();
        return new FrameworkLogRecord(status.getPlugin(), FrameworkLogRecord.getStatusLevel(status), status.getCode(), message, stackCode, t, children);
    }

    private static Level getStatusLevel(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                return Level.FINE;
            }
            case 1: {
                return Level.INFO;
            }
            case 4: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.WARNING;
            }
            case 8: {
                return Level.INFO;
            }
        }
        return Level.SEVERE;
    }

    public int getCode() {
        return this.code;
    }

    public int getStackCode() {
        return this.stackCode;
    }

    public FrameworkLogRecord[] getChildren() {
        return this.children == null ? null : this.children.toArray(new FrameworkLogRecord[this.children.size()]);
    }
}

