/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library;

import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceDialog;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.mb.listeners.GenListenerManager;

public class ResourceGetter {
    private static final Logger logger = Logger.getLogger(ResourceGetter.class.getName());
    public static final int DEFAULT_FONT_SIZE = UI.OS_CARBON ? 10 : 9;
    public static String P_LOCAL_FONT = "Arial";
    public static String P_LOCAL_FONTD = "Arial";
    private static ConcurrentHashMap<String, Resource<Image>> lstImages;
    private static ConcurrentHashMap<String, Resource<Color>> lstColors;
    private static ConcurrentHashMap<String, Resource<Font>> lstFonts;
    private static ConcurrentHashMap<String, Resource<Cursor>> lstCursors;
    private static ConcurrentHashMap<Image, String> lstInvertedImages;
    private static ConcurrentHashMap<Color, String> lstInvertedColors;
    private static ConcurrentHashMap<Font, String> lstInvertedFonts;
    private static ConcurrentHashMap<Cursor, String> lstInvertedCursors;
    private static int fontSizeInc;
    private static String normalFontName;
    private static final GenListenerManager<IRefreshFont> fontListeners;
    private static final int RGBMAX = 255;
    private static final int HSLMAX = 255;
    private static final int UNDEFINED = 170;
    public static final RGB RED_WARNING_COLOR;
    public static final RGB GREEN_WARNING_COLOR;
    public static final RGB YELLOW_WARNING_COLOR;
    public static final RGB ORANGE_WARNING_COLOR;
    public static final RGB LIGHT_ORANGE_WARNING_COLOR;

    static {
        P_LOCAL_FONT = Display.getDefault().getSystemFont().getFontData()[0].getName();
        P_LOCAL_FONTD = Display.getDefault().getSystemFont().getFontData()[0].getName();
        lstImages = new ConcurrentHashMap();
        lstColors = new ConcurrentHashMap();
        lstFonts = new ConcurrentHashMap();
        lstCursors = new ConcurrentHashMap();
        lstInvertedImages = new ConcurrentHashMap();
        lstInvertedColors = new ConcurrentHashMap();
        lstInvertedFonts = new ConcurrentHashMap();
        lstInvertedCursors = new ConcurrentHashMap();
        fontSizeInc = 0;
        normalFontName = P_LOCAL_FONTD;
        fontListeners = new GenListenerManager(IRefreshFont.class);
        RED_WARNING_COLOR = new RGB(236, 96, 96);
        GREEN_WARNING_COLOR = new RGB(100, 205, 205);
        YELLOW_WARNING_COLOR = new RGB(245, 225, 0);
        ORANGE_WARNING_COLOR = new RGB(255, 150, 0);
        LIGHT_ORANGE_WARNING_COLOR = new RGB(245, 171, 0);
    }

    public static int transfertColorToInteger(Color color) {
        return ResourceGetter.transfertColorToInteger(color.getRGB());
    }

    public static int transfertColorToInteger(RGB rgb) {
        return rgb.red * (int)Math.pow(16.0, 4.0) + rgb.green * (int)Math.pow(16.0, 2.0) + rgb.blue;
    }

    public static Color darkenColor(RGB colorToFade) {
        int[] hsl = ResourceGetter.RGBToHSL(colorToFade.red, colorToFade.green, colorToFade.blue);
        hsl[2] = hsl[2] - (int)((double)hsl[2] * 0.5);
        int[] rgb = ResourceGetter.HSLToRGB(hsl[0], hsl[1], hsl[2]);
        return ResourceGetter.getColor(rgb[0], rgb[1], rgb[2]);
    }

    public static int[] RGBToHSL(int R, int G, int B) {
        int cMax = Math.max(Math.max(R, G), B);
        int cMin = Math.min(Math.min(R, G), B);
        int cMinus = cMax - cMin;
        int cPlus = cMax + cMin;
        int pSat = 170;
        int pHue = 170;
        int pLum = (cPlus * 255 + 255) / 510;
        if (cMax == cMin) {
            pSat = 0;
            pHue = 170;
        } else {
            pSat = pLum <= 127 ? (int)(((double)(cMinus * 255) + 0.5) / (double)cPlus) : (int)(((double)(cMinus * 255) + 0.5) / (double)(510 - cPlus));
            int RDelta = (int)(((double)((cMax - R) * 42) + 0.5) / (double)cMinus);
            int GDelta = (int)(((double)((cMax - G) * 42) + 0.5) / (double)cMinus);
            int BDelta = (int)(((double)((cMax - B) * 42) + 0.5) / (double)cMinus);
            if (cMax == R) {
                pHue = BDelta - GDelta;
            } else if (cMax == G) {
                pHue = 85 + RDelta - BDelta;
            } else if (cMax == B) {
                pHue = 170 + GDelta - RDelta;
            }
            if (pHue < 0) {
                pHue += 255;
            }
        }
        return new int[]{pHue, pSat, pLum};
    }

    public static int[] HSLToRGB(int H, int S, int L) {
        int pBlue;
        int pGreen;
        int pRed;
        if (S == 0) {
            pGreen = pRed = L * 255 / 255;
            pBlue = pRed;
        } else {
            int Magic2 = L <= 127 ? (L * (255 + S) + 127) / 255 : L + S - (L * S + 127) / 255;
            int Magic1 = 2 * L - Magic2;
            pRed = (ResourceGetter.hueToRGB(Magic1, Magic2, H + 85) * 255 + 127) / 255;
            if (pRed > 255) {
                pRed = 255;
            }
            if ((pGreen = (ResourceGetter.hueToRGB(Magic1, Magic2, H) * 255 + 127) / 255) > 255) {
                pGreen = 255;
            }
            if ((pBlue = (ResourceGetter.hueToRGB(Magic1, Magic2, H - 85) * 255 + 127) / 255) > 255) {
                pBlue = 255;
            }
        }
        return new int[]{pRed, pGreen, pBlue};
    }

    private static int hueToRGB(int mag1, int mag2, int Hue) {
        if (Hue < 0) {
            Hue += 255;
        } else if (Hue > 255) {
            Hue -= 255;
        }
        if (Hue < 42) {
            return mag1 + ((mag2 - mag1) * Hue + 21) / 42;
        }
        if (Hue < 127) {
            return mag2;
        }
        if (Hue < 170) {
            return mag1 + ((mag2 - mag1) * (170 - Hue) + 21) / 42;
        }
        return mag1;
    }

    public static boolean isManaged(String imageName) {
        ResourceGetter.checkCurrentThreadIsUIThread();
        if (imageName == null) {
            throw new IllegalArgumentException("imageName cant be null");
        }
        return lstImages.get(imageName) != null;
    }

    public static void manageImage(String imageName, Image image) {
        ResourceGetter.checkCurrentThreadIsUIThread();
        ResourceGetter.intern_manageImage(imageName, image);
    }

    private static Resource<Image> intern_manageImage(String imageName, Image image) {
        if (imageName == null) {
            throw new IllegalArgumentException("imageName cant be null");
        }
        if (image == null) {
            throw new IllegalArgumentException("image cant be null");
        }
        if (image.isDisposed()) {
            throw new IllegalArgumentException("image is disposed");
        }
        if (ResourceGetter.isManaged(imageName)) {
            throw new IllegalArgumentException("image is already managed");
        }
        Resource<Image> res = new Resource<Image>(imageName);
        res.object = image;
        lstImages.put(res.name, res);
        lstInvertedImages.put((Image)res.object, res.name);
        if (Platform.inDebugMode()) {
            ResourceDialog.redrawResourceDialog();
        }
        return res;
    }

    public static Image getScaledImageFixed(String imageName, float width, float height) {
        Image image = ResourceGetter.getImage(imageName);
        return ResourceGetter.getScaledImageFixed(image, width, height);
    }

    public static Image getScaledImageFixed(Image source, float width, float height) {
        ResourceGetter.checkCurrentThreadIsUIThread();
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        String imageName = "ScaledFixed:" + source.hashCode() + "w:" + width + "h:" + height;
        if (ResourceGetter.isManaged(imageName)) {
            return ResourceGetter.getImage(imageName);
        }
        Resource<Image> res = ResourceGetter.getImageResource(source);
        if (res != null) {
            Image image = new Image((Device)Display.getDefault(), source.getImageData().scaledTo((int)width, (int)height));
            res = ResourceGetter.intern_manageImage(imageName, image);
        } else {
            res = ResourceGetter.getFallbackResource();
        }
        ++res.useCount;
        return (Image)res.object;
    }

    public static Image getScaledImageSameAs(String imageName, Image sameAs) {
        if (sameAs == null) {
            throw new NullPointerException("sameAs");
        }
        Image image = ResourceGetter.getImage(imageName);
        return ResourceGetter.getScaledImageFixed(image, (float)sameAs.getBounds().width, (float)sameAs.getBounds().height);
    }

    public static Image getScaledImageFactor(String imageName, float wr, float hr) {
        Image image = ResourceGetter.getImage(imageName);
        return ResourceGetter.getScaledImageFactor(image, wr, hr);
    }

    public static Image getScaledImageFactor(Image source, float wr, float hr) {
        ResourceGetter.checkCurrentThreadIsUIThread();
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        String imageName = "ScaledFactor:" + source.hashCode() + "wr:" + wr + "hr:" + hr;
        if (ResourceGetter.isManaged(imageName)) {
            return ResourceGetter.getImage(imageName);
        }
        Resource<Image> res = ResourceGetter.getImageResource(source);
        if (res != null) {
            int width = source.getBounds().width;
            int height = source.getBounds().width;
            Image image = new Image((Device)Display.getDefault(), source.getImageData().scaledTo((int)((float)width * wr), (int)((float)height * hr)));
            res = ResourceGetter.intern_manageImage(imageName, image);
        } else {
            res = ResourceGetter.getFallbackResource();
        }
        ++res.useCount;
        return (Image)res.object;
    }

    public static Image getGrayImage(String imageName) {
        ResourceGetter.checkCurrentThreadIsUIThread();
        if (imageName == null) {
            throw new IllegalArgumentException("imageName cant be null");
        }
        String grayImageName = "GRAY" + imageName;
        if (ResourceGetter.isManaged(grayImageName)) {
            return ResourceGetter.getImage(grayImageName);
        }
        Resource<Image> res = ResourceGetter.getImageResource(imageName);
        if (res != null) {
            Image image = new Image((Device)Display.getDefault(), (Image)res.object, 2);
            res = ResourceGetter.intern_manageImage(grayImageName, image);
        } else {
            res = ResourceGetter.getGrayFallbackResource();
        }
        ++res.useCount;
        return (Image)res.object;
    }

    public static Image getSystemImage(int id) {
        Resource<Image> res = ResourceGetter.getSystemImageResource(id);
        if (res == null) {
            res = ResourceGetter.getFallbackResource();
        }
        ++res.useCount;
        return (Image)res.object;
    }

    public static void linkResourceWithWidgetLife(final Object resource, Widget widget) {
        if (resource != null) {
            if (widget == null) {
                throw new NullPointerException("widget");
            }
            widget.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ResourceGetter.dispose(resource);
                }
            });
        }
    }

    public static Image getImage(int height) {
        Resource<Image> res = ResourceGetter.getFallbackResource(height);
        ++res.useCount;
        return (Image)res.object;
    }

    public static Image getImage(String imageName) {
        if (imageName == null) {
            throw new IllegalArgumentException("imageName cant be null");
        }
        Resource<Image> res = ResourceGetter.getImageResource(imageName);
        if (res == null) {
            res = ResourceGetter.getFallbackResource();
        }
        ++res.useCount;
        return (Image)res.object;
    }

    private static Resource<Image> getSystemImageResource(int id) {
        Image image;
        String imageName = "System" + id;
        Resource<Object> res = lstImages.get(imageName);
        if (res == null) {
            res = new Resource(imageName, false);
        }
        if ((image = (Image)res.object) != null && image.isDisposed()) {
            logger.log(Level.WARNING, "ATTENTION : L'image " + imageName + " est dispos\ufffd");
            image = null;
        }
        boolean newImage = false;
        if (image == null) {
            image = Display.getDefault().getSystemImage(id);
            boolean bl = newImage = image != null;
        }
        if (image == null) {
            res = null;
            logger.log(Level.WARNING, "Image " + imageName + " not found");
            return null;
        }
        res.object = image;
        if (newImage) {
            lstImages.put(res.name, res);
            lstInvertedImages.put((Image)res.object, res.name);
        }
        if (Platform.inDebugMode()) {
            ResourceDialog.redrawResourceDialog();
        }
        return res;
    }

    private static Resource<Image> getImageResource(Image source) {
        if (source != null) {
            String name = lstInvertedImages.get(source);
            return name == null ? null : lstImages.get(name);
        }
        return null;
    }

    private static Resource<Image> getImageResource(String imageName) {
        Image image;
        Resource<Object> res = lstImages.get(imageName);
        if (res == null) {
            res = new Resource(imageName);
        }
        if ((image = (Image)res.object) != null && image.isDisposed()) {
            logger.log(Level.WARNING, "ATTENTION : L'image " + imageName + " est dispos\u00e9");
            image = null;
        }
        boolean newImage = false;
        if (image == null) {
            InputStream imageStream = ResourceGetter.getImageStream(imageName);
            if (imageStream != null) {
                image = new Image((Device)Display.getDefault(), imageStream);
            }
            newImage = image != null;
            res.object = image;
        }
        if (image == null) {
            res = null;
            return null;
        }
        if (newImage) {
            lstImages.put(res.name, res);
            lstInvertedImages.put((Image)res.object, res.name);
        }
        if (Platform.inDebugMode()) {
            ResourceDialog.redrawResourceDialog();
        }
        return res;
    }

    private static InputStream getImageStream(String imageName) {
        InputStream image = null;
        try {
            ClassLoader loader = ResourceGetter.getNonNullClassLoader();
            image = loader.getResourceAsStream(imageName);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Error loading image resource " + imageName, e);
        }
        if (image == null) {
            String stacktrace = Log.getPrintedStackTrace(1, 4);
            logger.log(Level.WARNING, "Resource " + imageName + " not found. \n" + stacktrace);
        }
        return image;
    }

    private static Resource<Image> getGrayFallbackResource() {
        Resource<Image> res = lstImages.get("GRAYfallback");
        if (res == null) {
            Image image = new Image((Device)Display.getDefault(), (Image)ResourceGetter.getFallbackResource().object, 2);
            res = ResourceGetter.intern_manageImage("GRAYfallback", image);
        }
        return res;
    }

    private static Resource<Image> getFallbackResource() {
        Resource<Image> res = lstImages.get("fallback");
        if (res == null) {
            Image image = new Image((Device)Display.getDefault(), 28, 28);
            GC gc = new GC((Drawable)image);
            gc.setBackground(ResourceGetter.getColor(255, 0, 0));
            gc.fillRectangle(0, 0, 28, 28);
            gc.drawLine(0, 0, 28, 28);
            gc.drawLine(28, 0, 0, 28);
            gc.drawRectangle(0, 0, 28, 28);
            gc.dispose();
            res = ResourceGetter.intern_manageImage("fallback", image);
        }
        return res;
    }

    private static Resource<Image> getFallbackResource(int height) {
        String key = "fallback" + height;
        Resource<Image> res = lstImages.get(key);
        if (res == null) {
            Image image = new Image((Device)Display.getDefault(), 15, height);
            GC gc = new GC((Drawable)image);
            gc.setBackground(ResourceGetter.getColor(255, 255, 255));
            gc.fillRectangle(0, 0, 15, height);
            gc.dispose();
            res = ResourceGetter.intern_manageImage(key, image);
        }
        return res;
    }

    public static RGB getRGB(int red, int green, int blue) {
        return new RGB(red, green, blue);
    }

    public static RGB getRGB(int[] value) {
        if (value == null) {
            return null;
        }
        return new RGB(value[0], value[1], value[2]);
    }

    public static Color getColor(int[] rgb) {
        return ResourceGetter.getColor(rgb[0], rgb[1], rgb[2]);
    }

    public static Color getColor(RGB rgb) {
        return ResourceGetter.getColor(rgb.red, rgb.green, rgb.blue);
    }

    public static Color getColorForWidget(int red, int green, int blue, Widget widget) {
        Color color = ResourceGetter.getColor(red, green, blue);
        ResourceGetter.linkResourceWithWidgetLife(color, widget);
        return color;
    }

    public static Color getColor(int red, int green, int blue) {
        Color color;
        ResourceGetter.checkCurrentThreadIsUIThread();
        String key = String.valueOf(red) + green + blue;
        Resource<Object> res = lstColors.get(key);
        if (res == null) {
            res = new Resource(key);
        }
        if ((color = (Color)res.object) != null && color.isDisposed()) {
            logger.log(Level.WARNING, "ATTENTION : La couleur R=" + red + ", V=" + green + ", B=" + blue + " est dispos\ufffd");
            color = null;
        }
        boolean newColor = false;
        if (color == null) {
            try {
                color = new Color((Device)Display.getDefault(), red, green, blue);
                newColor = true;
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.SEVERE, "Error loading color R=" + red + ", V=" + green + ", B=" + blue);
            }
            res.object = color;
        }
        ++res.useCount;
        if (newColor) {
            lstColors.put(key, res);
            lstInvertedColors.put(color, key);
        }
        if (Platform.inDebugMode()) {
            ResourceDialog.redrawResourceDialog();
        }
        return color;
    }

    public static Color transfertIntegerToColor(int intValue) {
        return ResourceGetter.getColor(ResourceGetter.transfertIntegerToRGB(intValue));
    }

    public static RGB transfertIntegerToRGB(int intValue) {
        return new RGB((intValue & 0xFF0000) / 65536, (intValue & 0xFF00) / 256 % 256, intValue % 256);
    }

    public static Cursor getCursor(int type) {
        Cursor cursor;
        ResourceGetter.checkCurrentThreadIsUIThread();
        String key = String.valueOf(type);
        Resource<Object> res = lstCursors.get(key);
        if (res == null) {
            res = new Resource("Cursor " + key);
        }
        if ((cursor = (Cursor)res.object) != null && cursor.isDisposed()) {
            logger.log(Level.WARNING, "ATTENTION : Le curseur Type=" + type + " est dispos\ufffd");
            cursor = null;
        }
        boolean newCursor = false;
        if (cursor == null) {
            try {
                cursor = new Cursor((Device)Display.getDefault(), type);
                newCursor = true;
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.SEVERE, "Error loading cursor " + type);
            }
            res.object = cursor;
        }
        ++res.useCount;
        if (newCursor) {
            lstCursors.put(key, res);
            lstInvertedCursors.put(cursor, key);
        }
        if (Platform.inDebugMode()) {
            ResourceDialog.redrawResourceDialog();
        }
        return cursor;
    }

    public static Cursor getCursor(ImageData sourceData, ImageData maskData, int hotspotX, int hotspotY) {
        Cursor cursor;
        ResourceGetter.checkCurrentThreadIsUIThread();
        String key = String.valueOf(sourceData.toString()) + maskData.toString() + hotspotX + hotspotY;
        Resource<Object> res = lstCursors.get(key);
        if (res == null) {
            res = new Resource("Cursor " + key);
        }
        if ((cursor = (Cursor)res.object) != null && cursor.isDisposed()) {
            logger.log(Level.WARNING, "ATTENTION : Le curseur Type=" + key + " est dispos\ufffd");
            cursor = null;
        }
        boolean newCursor = false;
        if (cursor == null) {
            try {
                cursor = new Cursor((Device)Display.getDefault(), sourceData, maskData, hotspotX, hotspotY);
                newCursor = true;
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.SEVERE, "Error loading cursor " + key);
            }
            res.object = cursor;
        }
        ++res.useCount;
        if (newCursor) {
            lstCursors.put(String.valueOf(key), res);
            lstInvertedCursors.put(cursor, String.valueOf(key));
        }
        if (Platform.inDebugMode()) {
            ResourceDialog.redrawResourceDialog();
        }
        return cursor;
    }

    public static Font getFontNormal() {
        return ResourceGetter.getFont(ResourceGetter.getNormalFontPolicy(), DEFAULT_FONT_SIZE, 0, true);
    }

    public static Font getFontSmallNormal() {
        return ResourceGetter.getFont(ResourceGetter.getNormalFontPolicy(), DEFAULT_FONT_SIZE - 1, 0, true);
    }

    public static Font getFontBold() {
        return ResourceGetter.getFont(ResourceGetter.getNormalFontPolicy(), DEFAULT_FONT_SIZE, 1, true);
    }

    public static Font getFontItalic() {
        return ResourceGetter.getFont(ResourceGetter.getNormalFontPolicy(), DEFAULT_FONT_SIZE, 2, true);
    }

    public static Font getFontItalic(int sizeIncrement) {
        return ResourceGetter.getFont(ResourceGetter.getNormalFontPolicy(), DEFAULT_FONT_SIZE + sizeIncrement, 2, true);
    }

    public static Font getFontNormal(int sizeIncrement) {
        return ResourceGetter.getFont(ResourceGetter.getNormalFontPolicy(), DEFAULT_FONT_SIZE + sizeIncrement, 0, true);
    }

    public static Font getFontBold(int sizeIncrement) {
        return ResourceGetter.getFont(ResourceGetter.getNormalFontPolicy(), DEFAULT_FONT_SIZE + sizeIncrement, 1, true);
    }

    public static Font getFontSmallBold() {
        return ResourceGetter.getFont(ResourceGetter.getNormalFontPolicy(), DEFAULT_FONT_SIZE - 1, 1, true);
    }

    public static Font getFont(int sizeIncrement, int style) {
        return ResourceGetter.getFont(ResourceGetter.getNormalFontPolicy(), DEFAULT_FONT_SIZE + sizeIncrement, style, true);
    }

    public static Font getFont(String fontName, int sizeIncrement, int style) {
        return ResourceGetter.getFont(fontName, DEFAULT_FONT_SIZE + sizeIncrement, style, true);
    }

    public static String getNormalFontPolicy() {
        return normalFontName;
    }

    public static Font getFont(Font font) {
        ResourceGetter.checkCurrentThreadIsUIThread();
        return ResourceGetter.getFont(font.getFontData()[0]);
    }

    public static Font getFont(FontData fontdata) {
        ResourceGetter.checkCurrentThreadIsUIThread();
        return ResourceGetter.getFont(fontdata.getName(), fontdata.getHeight(), fontdata.getStyle(), true);
    }

    private static String computeFontKey(String name, int height, int style) {
        return String.valueOf(name) + height + style;
    }

    public static Font getFont(String name, int style) {
        return ResourceGetter.getFont(name, DEFAULT_FONT_SIZE, style, true);
    }

    public static Font getFont(String name, int height, int style, boolean fontSizeInc) {
        Font font;
        ResourceGetter.checkCurrentThreadIsUIThread();
        height = fontSizeInc ? Math.max(1, height + ResourceGetter.getFontSizeIncrement()) : Math.max(1, height);
        String key = ResourceGetter.computeFontKey(name, height, style);
        Resource<Object> res = lstFonts.get(key);
        boolean newFont = false;
        if (res == null) {
            res = new Resource(key);
        }
        if ((font = (Font)res.object) != null && font.isDisposed()) {
            logger.log(Level.WARNING, "Le Font " + name + ", height=" + height + ", style=" + style + " est dispos\ufffd");
            font = null;
        }
        if (font == null) {
            try {
                font = new Font((Device)Display.getDefault(), name, height, style);
                newFont = true;
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.SEVERE, "Error loading font " + name + ", height=" + height + ", style=" + style);
            }
            res.object = font;
        }
        ++res.useCount;
        if (newFont) {
            lstFonts.put(key, res);
            lstInvertedFonts.put(font, key);
        }
        if (Platform.inDebugMode()) {
            ResourceDialog.redrawResourceDialog();
        }
        return font;
    }

    public static final int getFontSizeIncrement() {
        ResourceGetter.checkCurrentThreadIsUIThread();
        return fontSizeInc;
    }

    public static final void setFontSizeIncrement(int f) {
        ResourceGetter.checkCurrentThreadIsUIThread();
        f = Math.max(f, 0);
        f = Math.min(f, 6);
        System.out.println(f);
        JFaceResources.getFontRegistry().put("org.eclipse.jface.dialogfont", ResourceGetter.getFontNormal().getFontData());
        JFaceResources.getFontRegistry().put("org.eclipse.jface.bannerfont", ResourceGetter.getFontBold().getFontData());
        if (f != fontSizeInc) {
            fontSizeInc = f;
            ((IRefreshFont)fontListeners.getProxy()).refreshFont();
        }
    }

    public static void dispose(Object resource) {
    }

    public static void disposeAllResouces() {
        logger.info("disposing all resources");
        ResourceGetter.checkCurrentThreadIsUIThread();
        for (Resource<Image> resource : lstImages.values()) {
            if (!resource.disposable || ((Image)resource.object).isDisposed()) continue;
            ((Image)resource.object).dispose();
        }
        lstImages.clear();
        lstInvertedImages.clear();
        for (Resource<Image> resource : lstColors.values()) {
            if (!resource.disposable || ((Color)resource.object).isDisposed()) continue;
            ((Color)resource.object).dispose();
        }
        lstColors.clear();
        lstInvertedColors.clear();
        for (Resource<Image> resource : lstFonts.values()) {
            if (!resource.disposable || ((Font)resource.object).isDisposed()) continue;
            ((Font)resource.object).dispose();
        }
        lstFonts.clear();
        lstInvertedFonts.clear();
        for (Resource<Image> resource : lstCursors.values()) {
            if (!resource.disposable || ((Cursor)resource.object).isDisposed()) continue;
            ((Cursor)resource.object).dispose();
        }
        lstCursors.clear();
        lstInvertedCursors.clear();
    }

    public static Collection<Resource<Image>> getListImages() {
        ResourceGetter.checkCurrentThreadIsUIThread();
        return lstImages.values();
    }

    public static Collection<Resource<Font>> getListFonts() {
        ResourceGetter.checkCurrentThreadIsUIThread();
        return lstFonts.values();
    }

    public static Collection<Resource<Color>> getListColors() {
        ResourceGetter.checkCurrentThreadIsUIThread();
        return lstColors.values();
    }

    public static Collection<Resource<Cursor>> getListCursors() {
        ResourceGetter.checkCurrentThreadIsUIThread();
        return lstCursors.values();
    }

    public static void adapt(Control control) {
        ResourceGetter.checkCurrentThreadIsUIThread();
        final Color white = ResourceGetter.getColor(255, 255, 255);
        control.getParent().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ResourceGetter.dispose(white);
            }
        });
        control.setBackground(white);
    }

    public static void addListener(IRefreshFont listener) throws IllegalArgumentException {
        fontListeners.addListener((Object)listener);
    }

    public static void removeListener(IRefreshFont listener) throws IllegalArgumentException {
        fontListeners.removeListener((Object)listener);
    }

    private static void checkCurrentThreadIsUIThread() {
        Thread thread = (Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent()).getThread();
        if (thread != Thread.currentThread() && thread.getId() != Thread.currentThread().getId()) {
            SWT.error((int)22);
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new RowLayout(512));
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        ResourceGetter.disposeAllResouces();
        display.dispose();
    }

    public static Color getRedWarningColor() {
        return ResourceGetter.getColor(RED_WARNING_COLOR);
    }

    public static Color getOrangeWarningColor() {
        return ResourceGetter.getColor(ORANGE_WARNING_COLOR);
    }

    public static Color getLightOrangeWarningColor() {
        return ResourceGetter.getColor(LIGHT_ORANGE_WARNING_COLOR);
    }

    public static Color getYellowWarningColor() {
        return ResourceGetter.getColor(YELLOW_WARNING_COLOR);
    }

    public static Color getGreenWarningColor() {
        return ResourceGetter.getColor(GREEN_WARNING_COLOR);
    }

    public static ClassLoader getNonNullClassLoader() {
        Thread thread;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null && (thread = (Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent()).getThread()) != null && (loader = thread.getContextClassLoader()) == null) {
            ThreadGroup group = thread.getThreadGroup();
            Thread[] threads = new Thread[group.activeCount()];
            group.enumerate(threads);
            Thread[] threadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                Thread th = threadArray[n2];
                loader = th.getContextClassLoader();
                if (loader != null) break;
                ++n2;
            }
        }
        return loader;
    }

    public static class Resource<T> {
        public final String name;
        public final boolean disposable;
        int useCount = 0;
        T object;

        private Resource(String name) {
            this.name = name;
            this.disposable = true;
        }

        private Resource(String name, boolean disposable) {
            this.name = name;
            this.disposable = disposable;
        }

        public String toString() {
            return String.format("Resource [name=%s, useCount=%s, disposable=%s, object=%s]", this.name, this.useCount, this.disposable, this.object);
        }
    }
}

