/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.laboresults.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.LaboResultsAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalQuery;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XNumberByLaboResultsProfessionnalQuery;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.laboresults.Messages;
import ca.infodata.ofys.ui.laboresults.menu.LaboResultsElement;
import ca.infodata.ofys.ui.laboresults.menu.ListResultats;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;

public class ListResultatsToSee
extends ListResultats {
    private static final Logger logger = Logger.getLogger(ListResultatsToSee.class.getName());
    private boolean isLoading;

    public ListResultatsToSee(ITreeElements parent, IPatient patient, XBaseProfessionnal professionnal) {
        super(parent);
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        this.container = new XLaboResultsProfessionnalQuery();
        this.container.setIdPatient(patient.getId());
        this.container.setIdProfessionnal(professionnal == null ? null : professionnal.getId());
        this.container.setStatus(XLaboResultsProfessionnalStatus.UNSEEN);
        this.initAsLoading();
    }

    public ListResultatsToSee(ITreeElements parent, XBaseProfessionnal professionnal) {
        super(parent);
        if (professionnal == null) {
            throw new NullPointerException("professionnal");
        }
        this.container = new XLaboResultsProfessionnalQuery();
        this.container.setIdProfessionnal(professionnal.getId());
        this.container.setStatus(XLaboResultsProfessionnalStatus.UNSEEN);
        this.initAsLoading();
    }

    public void initAsLoading() {
        this.setText(String.valueOf(A_VOIR) + this.getLoadingTextFlag());
        this.childrenNumber = -1;
    }

    @Override
    public void loadCountResponseOverride(XNumberByLaboResultsProfessionnalQuery number) {
        this.setText(A_VOIR);
        this.childrenNumber = number == null ? -1 : number.numberUnseen;
    }

    public Object[] getChildren() {
        if (this.notLoaded()) {
            this.fillAsLoading();
        }
        return this.children;
    }

    private void fillAsLoading() {
        this.isLoading = true;
        this.children = new ITreeElements[]{new LoadingElement((ITreeElements)this)};
        this.find();
    }

    private boolean notLoaded() {
        return this.children == null || this.isLoading;
    }

    private void find() {
        JobCallback callback = new JobCallback(Messages.getString("CHARGEMENT"), (IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(ReturnObject response) {
                if (response != null && response.getObj() instanceof List) {
                    ListResultatsToSee.this.fill((List)response.getObj());
                } else {
                    ListResultatsToSee.this.fill(null);
                }
            }
        };
        try {
            try {
                LaboResultsAccessorClient.getInstance().findLaboResultsProfessionnal(Application.get().getGlobalInstances().getSession(), (ICallback)callback, this.getLaboResultsContainer());
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                callback.kill();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
                callback.kill();
            }
        }
        finally {
            callback.kill();
        }
    }

    private void fill(List<XBaseLaboResultsProfessionnal> list) {
        Integer patient = this.container.getIdPatient();
        Integer professionnal = this.container.getIdProfessionnal();
        if (patient != null) {
            if (list == null) {
                this.children = new ITreeElements[0];
            } else {
                ArrayList<LaboResultsElement> listChild = new ArrayList<LaboResultsElement>(list.size());
                for (XBaseLaboResultsProfessionnal labo : list) {
                    LaboResultsElement e = this.newLaboElement(labo);
                    e.setShowPatientName(false);
                    listChild.add(e);
                }
                this.children = listChild.toArray(new ITreeElements[listChild.size()]);
            }
        } else if (professionnal != null) {
            if (list == null) {
                this.children = new ITreeElements[0];
            } else {
                ArrayList<LaboResultsElement> listChild = new ArrayList<LaboResultsElement>(list.size());
                for (XBaseLaboResultsProfessionnal labo : list) {
                    LaboResultsElement e = this.newLaboElement(labo);
                    e.setShowPatientName(true);
                    listChild.add(e);
                }
                this.children = listChild.toArray(new ITreeElements[listChild.size()]);
            }
        }
        this.isLoading = false;
        DossierPlugin.getDefault().refreshTree((ITreeElements)this);
    }

    private LaboResultsElement newLaboElement(XBaseLaboResultsProfessionnal labo) {
        return new LaboResultsElement(this, labo);
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/pechere.gif");
    }

    @Override
    public XLaboResultsProfessionnalQuery getLaboResultsContainer() {
        return this.container;
    }
}

