/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro.login;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class LogInView
extends BaseView
implements IRefreshFont {
    private static final Logger logger = Logger.getLogger(LogInView.class.getName());
    public static final String ID = "ca.infodata.ofys.ui.intro.login.LogInView";
    private Browser newsBrowser;
    private GlobalInstancesAdapter globalInstancesListener;
    private StackLayout stackLayout;
    private FormToolkit toolkit;
    private Composite loadingComposite;
    private Composite loadedComposite;
    private Composite parent;

    public void setFocus() {
    }

    public void createMyPartControl(Composite parent) {
        this.parent = parent;
        this.toolkit = UI.createToolKit((Widget)parent);
        this.loadingComposite = this.createLoadingComposite(parent, this.toolkit);
        this.newsBrowser = new Browser(parent, 0);
        new BrowserFunction(this.newsBrowser, "open_java"){

            public Object function(Object[] arguments) {
                String href = null;
                try {
                    href = (String)arguments[0];
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    if (browser == null) {
                        browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("loginView");
                    }
                    URL url = new URL(href);
                    browser.openURL(url);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to open url " + href, e);
                }
                return null;
            }
        };
        this.loadedComposite = this.newsBrowser;
        new BrowserFunction(this.newsBrowser, "open_java"){

            public Object function(Object[] arguments) {
                String href = null;
                try {
                    href = (String)arguments[0];
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    if (browser == null) {
                        browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("loginView");
                    }
                    URL url = new URL(href);
                    browser.openURL(url);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to open url " + href, e);
                }
                return null;
            }
        };
        new BrowserFunction(this.newsBrowser, "isLoggedIn"){

            public Object function(Object[] arguments) {
                if (Application.get().getGlobalInstances().getSession() != null) {
                    return true;
                }
                return false;
            }
        };
        ResourceGetter.addListener((IRefreshFont)this);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        parent.setLayout((Layout)this.stackLayout);
        this.updateView();
        this.globalInstancesListener = new GlobalInstancesAdapter(){

            public void appReady() {
                UI.runInSwtThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LogInView.this.updateView();
                    }
                });
            }
        };
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
    }

    private static void openUrl(String href) {
        try {
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            if (browser == null) {
                browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("loginView");
            }
            URL url = new URL(href);
            browser.openURL(url);
        }
        catch (Exception exception) {}
    }

    private static Browser addWindowOpenListenersBrowser(Composite c, Browser b) {
        b.addOpenWindowListener(e -> {
            e.browser = new Browser(c, 0);
        });
        b.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent e) {
                Browser browser = (Browser)e.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent e) {
                Browser browser = (Browser)e.widget;
                LogInView.openUrl(browser.getUrl());
                Shell shell = browser.getShell();
                if (e.location != null) {
                    shell.setLocation(e.location);
                }
                if (e.size != null) {
                    Point size = e.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                shell.open();
            }
        });
        b.addCloseWindowListener(e -> {
            Browser browser1 = (Browser)e.widget;
            Shell shell = browser1.getShell();
            shell.close();
        });
        return b;
    }

    private void updateView() {
        if (Application.get().getGlobalInstances().isAppReady()) {
            this.newsBrowser.setUrl(HtmlBrowserTools.getUrl((String)"/login.html", null));
            this.stackLayout.topControl = this.loadedComposite;
        } else {
            this.stackLayout.topControl = this.loadingComposite;
        }
        this.parent.layout(true);
    }

    public void refreshFont() {
        Composite composite;
        if (this.newsBrowser != null && !this.newsBrowser.isDisposed()) {
            this.newsBrowser.setUrl(HtmlBrowserTools.getUrl((String)"/login.html", null));
        }
        if ((composite = this.getCompMain()) != null && !composite.isDisposed()) {
            FontAwareComposite.refreshFont((Control)composite);
            composite.layout(true, true);
        }
    }

    private FontAwareComposite createLoadingComposite(Composite parent, FormToolkit toolkit) {
        FontAwareComposite main = new FontAwareComposite(parent, toolkit.getBorderStyle());
        if (toolkit != null) {
            toolkit.adapt((Composite)main);
        }
        MyLabel lblLoading = new MyLabel((Composite)main, Messages.getString((String)"CHARGEMENT", (String[])new String[0]), 0x1000000, toolkit);
        lblLoading.setFont(2, 1);
        ProgressBar progressBar = new ProgressBar((Composite)main, 65538);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        FormData data = new FormData();
        data.top = new FormAttachment(50, -30);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblLoading.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblLoading.getControl());
        data.left = new FormAttachment(50, -50);
        data.width = 100;
        progressBar.setLayoutData((Object)data);
        main.setLayout((Layout)layout);
        return main;
    }
}

