/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro.action;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.intro.PerspectiveManager;
import ca.infodata.ofys.ui.library.UI;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ChangeLangueAction
extends Action {
    private static final Logger logger = Logger.getLogger(ChangeLangueAction.class.getName());
    public static ChangeLangueAction oFr = new ChangeLangueAction();
    public static ChangeLangueAction oEn = new ChangeLangueAction();

    public static ChangeLangueAction getFrancais() {
        String strLang = Locale.getDefault().getLanguage();
        oFr.setId("FR");
        oFr.setText(Messages.getString((String)"ChangeLangueAction.FRANCAIS", (String[])new String[0]));
        oFr.setDescription(Messages.getString((String)"ChangeLangueAction.OFYS_FR", (String[])new String[0]));
        oFr.setEnabled(!strLang.equals("fr"));
        oFr.setChecked(strLang.equals("fr"));
        return oFr;
    }

    public static ChangeLangueAction getEnglish() {
        String strLang = Locale.getDefault().getLanguage();
        oEn.setId("EN");
        oEn.setText(Messages.getString((String)"ChangeLangueAction.ENGLISH", (String[])new String[0]));
        oEn.setDescription(Messages.getString((String)"ChangeLangueAction.OFYS_ENGLISH", (String[])new String[0]));
        oEn.setEnabled(!strLang.equals("en"));
        oEn.setChecked(strLang.equals("en"));
        return oEn;
    }

    public static void setActiveAction(String newLang) {
        oFr.setEnabled(!(newLang = newLang.toUpperCase()).equals("FR"));
        oFr.setChecked(newLang.equals("FR"));
        oEn.setEnabled(!newLang.equals("EN"));
        oEn.setChecked(newLang.equals("EN"));
    }

    public void run() {
        ChangeLangueAction.switchLanguage(false);
    }

    public static boolean switchLanguage(boolean seeNoUpdateMsg) {
        boolean mustGo = true;
        File installPath = new File(Platform.getLocation().toString()).getParentFile();
        try {
            mustGo = MessageDialog.openConfirm((Shell)UI.getWorkbenchShell(), (String)Messages.getString((String)"ChangeLangueAction.CHANGEMENT_DE_LANGUE", (String[])new String[0]), (String)Messages.getString((String)"CHANGE_LANGUAGE.message", (String[])new String[0]));
            if (PlatformUI.getWorkbench() != null && mustGo) {
                String[] command = new String[]{"java", "-jar", String.valueOf(installPath.getAbsolutePath()) + "/launcher/OfysLauncher.jar", "-change-langage"};
                Runtime.getRuntime().exec(command);
                PerspectiveManager.closeAll(true);
                PlatformUI.getWorkbench().close();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Erreur", e);
        }
        return mustGo;
    }
}

