/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.intro;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XClientPreferences;
import ca.infodata.ofys.ui.intro.IntroPlugin;
import ca.infodata.ofys.ui.library.DaemonThread;
import ca.infodata.ofys.ui.library.LibPlugin;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class ClientSessionTimeoutTool {
    private static final Logger logger = Logger.getLogger(ClientSessionTimeoutTool.class.getName());
    private static ClientSessionTimeoutTool instance;
    private static GlobalInstancesListener sessionListener;
    private volatile int time;
    private volatile boolean stopTimer;
    private volatile boolean loggingOut;
    private Listener actionListener = new Listener(){

        public void handleEvent(Event event) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(event.toString());
            }
            ClientSessionTimeoutTool.this.resetTimer();
        }
    };
    private Thread thread = new DaemonThread(new Runnable(){

        @Override
        public void run() {
            ClientSessionTimeoutTool.this.run();
        }
    });

    public static ClientSessionTimeoutTool getInstance() {
        return instance;
    }

    public static void init() {
        instance = new ClientSessionTimeoutTool();
        sessionListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                XSession session = Application.get().getGlobalInstances().getSession();
                if (session == null) {
                    instance.stopTimer();
                } else {
                    instance.startTimer();
                }
            }
        };
        Application.get().getGlobalInstances().addGlobalInstancesListener(sessionListener);
    }

    private ClientSessionTimeoutTool() {
    }

    public void startTimer() {
        if (!this.thread.isAlive()) {
            this.thread.start();
        }
        this.stopTimer = false;
        Display current = Display.getCurrent();
        if (current == null) {
            current = Display.getDefault();
        }
        current.syncExec(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().addFilter(1, ClientSessionTimeoutTool.this.actionListener);
                Display.getDefault().addFilter(5, ClientSessionTimeoutTool.this.actionListener);
            }
        });
    }

    public void stopTimer() {
        this.stopTimer = true;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().removeFilter(1, ClientSessionTimeoutTool.this.actionListener);
                Display.getDefault().removeFilter(5, ClientSessionTimeoutTool.this.actionListener);
            }
        });
    }

    public void resetTimer() {
        this.time = 0;
    }

    private void run() {
        try {
            while (true) {
                boolean shouldLockSession;
                TimeUnit.MINUTES.sleep(1L);
                XSession session = Application.get().getGlobalInstances().getSession();
                logger.finer("time=" + this.time);
                if (this.stopTimer || this.loggingOut || session == null) continue;
                ++this.time;
                int stopTime = this.getInactionTimeThreshold(session);
                boolean bl = shouldLockSession = this.time >= stopTime;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(String.format("stoptime=%s vs timeSinceLastEvent=%s", stopTime, this.time));
                }
                if (!shouldLockSession || new File(String.valueOf(LibPlugin.OFYS_HOME) + "/../notimeout.txt").exists()) continue;
                this.lockSession(session);
            }
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Automatic session and application closer was interrupted", e);
            return;
        }
    }

    private int getInactionTimeThreshold(XSession session) {
        Integer inactionTimer;
        XClientPreferences clientPreferences;
        if (session != null && (clientPreferences = session.getClientPreferences()) != null && (inactionTimer = clientPreferences.getInactionTimer()) != null) {
            return inactionTimer / 4;
        }
        logger.warning("Failed to get inactionTimeThreshold from clientPrefenreces, using default 15 min");
        return 15;
    }

    private void lockSession(XSession session) {
        if (logger.isLoggable(Level.INFO)) {
            int stopTime = this.getInactionTimeThreshold(session);
            logger.info("Locking session because of inactivity; inactivity threshold = " + (stopTime == -1 ? "unset" : Integer.valueOf(stopTime)));
        }
        this.loggingOut = true;
        IntroPlugin.getDefault().lockSessionAndWait();
        this.loggingOut = false;
    }
}

