/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.ui.dashboard.models.CLaboFile;
import ca.infodata.ofys.ui.dashboard.models.CPatientImage;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.file.FileUtil;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

public class MVSecureCache {
    private static final Logger logger = Logger.getLogger(MVSecureCache.class.getName());
    private static final String prefix = "secureCache_";
    private GlobalInstancesAdapter globalInstancesListener = new GlobalInstancesAdapter(){

        public void sessionChanged() {
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null && (MVSecureCache.this.activeSessionId == null || !MVSecureCache.this.activeSessionId.equals(session.id)) && Application.get().getGlobalInstances().hasOneOfRoles(new XUserRole[]{XUserRole.HEALTHCARE_PROVIDER, XUserRole.MEDICAL_SECRETARY})) {
                MVSecureCache.this.activeSessionId = session.id;
                MVSecureCache.this.createStore();
            }
        }

        public void logout() {
            MVSecureCache.this.closeStore();
        }
    };
    private File storeFile;
    private MVStore store;
    protected Integer activeSessionId = null;

    public MVSecureCache() {
        this.createStore();
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
    }

    public synchronized Object addObjectToMap(String mapName, Integer k, Object obj) {
        Object put = this.store.openMap(mapName).put((Object)k, obj);
        return put;
    }

    public synchronized Object getObjectFromMap(String mapName, Integer k) {
        Object o = this.store.openMap(mapName).get((Object)k);
        return o;
    }

    public synchronized void removeObjectFromMap(String mapName, Integer k) {
        this.store.openMap(mapName).remove((Object)k);
    }

    public synchronized MVMap<Integer, Object> addMap(String mapName) {
        return this.store.openMap(mapName);
    }

    public synchronized void delMap(String m) {
        if (this.store.hasMap(m)) {
            MVMap openMap = this.store.openMap(m);
            this.store.removeMap(openMap);
        }
    }

    public synchronized void closeStore() {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        if (this.storeFile != null) {
            FileUtil.deleteSingleFile((File)this.storeFile);
            this.storeFile = null;
        }
    }

    public synchronized void createStore() {
        File oldFile = this.storeFile;
        MVStore oldStore = this.store;
        this.storeFile = new File(LibPlugin.OFYS_HOME_FILE, prefix + String.valueOf(StringUtils.random((char[])MiscUtil.alphanumericChars, (int)16)));
        this.store = new MVStore.Builder().fileName(this.storeFile.getAbsolutePath()).encryptionKey(MiscUtil.randomPassword((int)16).toCharArray()).compress().open();
        if (oldStore != null) {
            oldStore.closeImmediately();
        }
        if (oldFile != null) {
            FileUtil.deleteSingleFile((File)oldFile);
        }
    }

    public synchronized void dispose() {
        this.closeStore();
    }

    public static void cleanupOldFilesAsync() {
        try {
            Job job = new Job("Nettoyage des vieux fichiers ... "){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        MVSecureCache.cleanup();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to clean cities old files", e);
                        return new Status(4, "ca.infodata.ofys.ui.library", "Erreur lors du nettoyage des vieux fichiers");
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (Exception exception) {}
    }

    private static void cleanup() {
        try {
            File[] listFiles;
            final long now = System.currentTimeMillis();
            File[] fileArray = listFiles = LibPlugin.OFYS_HOME_FILE.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.canWrite() && pathname.exists() && pathname.getName().startsWith(MVSecureCache.prefix) && pathname.lastModified() < now - TimeUnit.DAYS.toMillis(2L);
                }
            });
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    file.delete();
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public static enum ModifiedObjects {
        XFORM((Class)XEformData.class){};

        Class<?> clazz;

        private ModifiedObjects(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }
    }

    public static enum OpenedObjects {
        ENC((Class)ActionResult.class){}
        ,
        XFORM((Class)XEformData.class){}
        ,
        DOC((Class)CPatientImage.class){}
        ,
        LAB((Class)CLaboFile.class){};

        Class<?> clazz;

        private OpenedObjects(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }
    }
}

