/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IApplicationUiPlugin;
import ca.infodata.ofys.client.IPreSaveController;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.IPrintControllerFactory;
import ca.infodata.ofys.client.cache.IApplicationCaches;
import ca.infodata.ofys.client.plugin.OfysClientPlugin;
import ca.infodata.ofys.client.web.controller.PatientController;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.IWebSocketFilter;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.client.web.core.WebSocketResponse;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.ui.browser.Activator;
import ca.infodata.ofys.ui.browser.ClasspathResourceHandler;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.sonar.SonarDispatcher;
import ca.infodata.ofys.ui.controls.report2.PrintController;
import ca.infodata.ofys.ui.dashboard.ApplicationCacheImpl;
import ca.infodata.ofys.ui.dashboard.ApplicationUIPluginImp;
import ca.infodata.ofys.ui.dashboard.PreSaveController;
import ca.infodata.ofys.ui.dashboard.WebComponents;
import ca.infodata.ofys.ui.dashboard.models.MVSecureCache;
import ca.infodata.util1.date.LocaleProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DashboardPlugin
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger(DashboardPlugin.class.getName());
    private static DashboardPlugin plugin;
    public static final String PLUGIN_ID = "ca.infodata.ofys.ui.dashboard";
    public static final int PROP_CHAT_MESSAGE_NOTIFICATION = 1;
    private GlobalInstancesAdapter globalInstancesListener;
    protected ExecutorService executorCefChromeService = Executors.newFixedThreadPool(5);
    protected List<Future<Process>> ofysChromeService = new ArrayList<Future<Process>>(5);
    protected static Integer activeSessionId;
    public boolean hasOpenedDashboard = false;
    private WebComponents webComponents;
    private ScheduledExecutorService executorService;
    protected String exeAppFile = null;

    static {
        activeSessionId = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        System.out.println("DashboardPlugin.start()");
        plugin = this;
        Application.get().setApplicationUiPlugin((IApplicationUiPlugin)new ApplicationUIPluginImp());
        Application.get().setPrintControllerFactory(new IPrintControllerFactory(){

            public IPrintController newPrintController(Serializable dataObject) {
                PrintController c = new PrintController(dataObject, null);
                c.setShowInPdf(true);
                return c;
            }

            public IPrintController newPrintController(Serializable dataObject, String keyContext) {
                PrintController c = new PrintController(dataObject, keyContext);
                c.setShowInPdf(true);
                return c;
            }

            public void dispose() {
            }
        });
        HtmlBrowserTools.getJettylisteners().add(new HtmlBrowserTools.IJettyListener(){

            public void jettyStopped() {
                DashboardPlugin plugin2 = DashboardPlugin.getDefault();
                if (plugin2 != null) {
                    DashboardPlugin.getDefault().stopControllers();
                }
            }

            public void jettyStarted() {
                DashboardPlugin.getDefault().startControllers();
            }
        });
        Application.get().setCache((IApplicationCaches)new ApplicationCacheImpl());
        Application.get().setPreSaveController((IPreSaveController)new PreSaveController());
        MVSecureCache.cleanupOldFilesAsync();
        this.addLogingEvent();
    }

    public static boolean hasAccessToOfysPro(XSession session) {
        return session != null && !session.id.equals(activeSessionId);
    }

    public void addLogingEvent() {
        this.globalInstancesListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                XSession session = Application.get().getGlobalInstances().getSession();
                if (DashboardPlugin.hasAccessToOfysPro(session)) {
                    activeSessionId = session.id;
                    DashboardPlugin.this.refreshControllers();
                }
            }

            public void logout() {
                DashboardPlugin.this.sendLoggedOutToClient();
                DashboardPlugin.this.refreshControllers();
            }
        };
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
        Activator.getDefault().restartJetty();
        Application.get().getGlobalInstances().appReady();
    }

    public void refreshControllers() {
        DashboardPlugin.getDefault().stopControllers();
        DashboardPlugin.getDefault().startControllers();
    }

    public void startControllers() {
        try {
            BundleContext context = OfysClientPlugin.getInstance().getBundleContext();
            HtmlBrowserTools.getClasspathHandler().addClassLoader("/dashboard/resources/*", context);
            if (this.webComponents != null) {
                try {
                    this.webComponents.dispose();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error disposing web components", e);
                }
            }
            this.webComponents = new WebComponents(context, SonarDispatcher.getInstance());
            this.executorService = Executors.newSingleThreadScheduledExecutor();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    WebApplication.get().getWebSocketDelegate().send(stream -> stream, new WebSocketResponse("ping.pulse", (Object)1));
                }
            };
            this.executorService.scheduleAtFixedRate(run, 5L, 1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Dashboard start error.", e);
        }
    }

    public PatientController getPatientControllerWeb() {
        return this.webComponents.getWebControllers().getPatientController();
    }

    protected void stopControllers() {
        try {
            ClasspathResourceHandler classpathHandler = HtmlBrowserTools.getClasspathHandler();
            if (classpathHandler != null) {
                classpathHandler.removeClassLoader("/dashboard/resources/*");
            }
            if (this.webComponents != null) {
                try {
                    this.webComponents.dispose();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error disposing web components", e);
                }
            }
            SonarDispatcher.getInstance().stopSonar();
            this.hasOpenedDashboard = false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Dashboard start error.", e);
        }
    }

    private void sendLoggedOutToClient() {
        Application.get().getWebApplication().getWebSocketDelegate().send(new IWebSocketFilter(){

            public Stream<? extends IWebSocketChannel> apply(Stream<? extends IWebSocketChannel> stream) {
                return stream;
            }
        }, new WebSocketResponse("session.loggedout", (Object)"true"));
    }

    public void stop(BundleContext context) throws Exception {
        this.stopControllers();
        plugin = null;
        super.stop(context);
        this.shutdownCefChromeService();
    }

    private void shutdownCefChromeService() throws InterruptedException, ExecutionException {
        if (this.executorCefChromeService != null && !this.executorCefChromeService.isShutdown()) {
            for (Future<Process> future : this.ofysChromeService) {
                Process process = future.get();
                if (process == null) continue;
                process.destroy();
            }
            this.executorCefChromeService.shutdown();
        }
    }

    public void openOfysChromeBrowser() {
        boolean hasMaxOpened;
        if (Application.get().getGlobalInstances().isDashboardVisible() && this.exeAppFile != null && !(hasMaxOpened = this.hasMAxOfysChromeOpened())) {
            this.hasOpenedDashboard = true;
            Future<Process> process = this.executorCefChromeService.submit(new Callable<Process>(){

                @Override
                public Process call() throws Exception {
                    try {
                        String[] cmds = new String[]{DashboardPlugin.this.exeAppFile, "--url=" + HtmlBrowserTools.getUrl((String)"/dashboard#/Home", null), "--enable-media-stream", "--lang=" + LocaleProvider.getLocale().getLanguage().toLowerCase().substring(0, 2)};
                        ProcessBuilder processBuilder = new ProcessBuilder(cmds);
                        processBuilder.redirectErrorStream(true);
                        Process proc = processBuilder.start();
                        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
                        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
                        errorGobbler.start();
                        outputGobbler.start();
                        return proc;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
            this.ofysChromeService.add(process);
        }
    }

    public void openOfysChrome() {
        if (!this.hasMAxOfysChromeOpened()) {
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = service.getCommand("ca.infodata.ofys.ui.dashboard.CefHandler");
            try {
                ExecutionEvent event = new ExecutionEvent(command, new HashMap(), null, null);
                command.executeWithChecks(event);
            }
            catch (org.eclipse.core.commands.ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                logger.log(Level.SEVERE, "ERROR Command ca.infodata.ofys.ui.dashboard.CefHandler", e);
            }
        }
    }

    private boolean hasMAxOfysChromeOpened() {
        boolean hasMaxOpened = false;
        if (this.executorCefChromeService != null && !this.executorCefChromeService.isShutdown()) {
            ArrayList<Future<Process>> lstToRemove = new ArrayList<Future<Process>>();
            int nbProcess = 0;
            for (Future<Process> future : this.ofysChromeService) {
                Process process = null;
                try {
                    process = future.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                if (process != null) {
                    try {
                        int exitValue = process.exitValue();
                        System.out.println("exitValue=" + exitValue);
                        if (exitValue == 0) {
                            lstToRemove.add(future);
                            continue;
                        }
                        ++nbProcess;
                    }
                    catch (IllegalThreadStateException e) {
                        System.out.println("IllegalThreadStateException: " + e.getMessage());
                    }
                    continue;
                }
                lstToRemove.add(future);
            }
            this.ofysChromeService.removeAll(lstToRemove);
            if (nbProcess > 4) {
                hasMaxOpened = true;
            }
        }
        return hasMaxOpened;
    }

    public static DashboardPlugin getDefault() {
        return plugin;
    }

    public void setExeOfysChromeBrowser(String absolutePath) {
        this.exeAppFile = absolutePath;
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(String.valueOf(this.type) + ">" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

