/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cert.crmf;

import java.security.SecureRandom;
import org.bouncycastle.cert.crmf.EncryptedValuePadder;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.MGF1BytesGenerator;
import org.bouncycastle.crypto.params.MGFParameters;

public class FixedLengthMGF1Padder
implements EncryptedValuePadder {
    private int length;
    private SecureRandom random;
    private Digest dig = new SHA1Digest();

    public FixedLengthMGF1Padder(int length) {
        this(length, null);
    }

    public FixedLengthMGF1Padder(int length, SecureRandom random) {
        this.length = length;
        this.random = random;
    }

    @Override
    public byte[] getPaddedData(byte[] data) {
        byte[] bytes = new byte[this.length];
        byte[] seed = new byte[this.dig.getDigestSize()];
        byte[] mask = new byte[this.length - this.dig.getDigestSize()];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(seed);
        MGF1BytesGenerator maskGen = new MGF1BytesGenerator(this.dig);
        maskGen.init(new MGFParameters(seed));
        maskGen.generateBytes(mask, 0, mask.length);
        System.arraycopy(seed, 0, bytes, 0, seed.length);
        System.arraycopy(data, 0, bytes, seed.length, data.length);
        int i = seed.length + data.length + 1;
        while (i != bytes.length) {
            byte b = (byte)this.random.nextInt();
            bytes[i] = b == 0 ? (byte)1 : b;
            ++i;
        }
        i = 0;
        while (i != mask.length) {
            int n = i + seed.length;
            bytes[n] = (byte)(bytes[n] ^ mask[i]);
            ++i;
        }
        return bytes;
    }

    @Override
    public byte[] getUnpaddedData(byte[] paddedData) {
        byte[] seed = new byte[this.dig.getDigestSize()];
        byte[] mask = new byte[this.length - this.dig.getDigestSize()];
        System.arraycopy(paddedData, 0, seed, 0, seed.length);
        MGF1BytesGenerator maskGen = new MGF1BytesGenerator(this.dig);
        maskGen.init(new MGFParameters(seed));
        maskGen.generateBytes(mask, 0, mask.length);
        int i = 0;
        while (i != mask.length) {
            int n = i + seed.length;
            paddedData[n] = (byte)(paddedData[n] ^ mask[i]);
            ++i;
        }
        int end = 0;
        int i2 = paddedData.length - 1;
        while (i2 != seed.length) {
            if (paddedData[i2] == 0) {
                end = i2;
                break;
            }
            --i2;
        }
        if (end == 0) {
            throw new IllegalStateException("bad padding in encoding");
        }
        byte[] data = new byte[end - seed.length];
        System.arraycopy(paddedData, seed.length, data, 0, data.length);
        return data;
    }
}

