/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.TwoPhaseCommit;

public final class TwoPhaseCommitTool {
    private TwoPhaseCommitTool() {
    }

    private static void rollback(TwoPhaseCommit ... objects) {
        TwoPhaseCommit[] twoPhaseCommitArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            TwoPhaseCommit tpc = twoPhaseCommitArray[n2];
            if (tpc != null) {
                try {
                    tpc.rollback();
                }
                catch (Throwable throwable) {}
            }
            ++n2;
        }
    }

    public static void execute(TwoPhaseCommit ... objects) throws PrepareCommitFailException, CommitFailException {
        int i;
        TwoPhaseCommit tpc = null;
        try {
            i = 0;
            while (i < objects.length) {
                tpc = objects[i];
                if (tpc != null) {
                    tpc.prepareCommit();
                }
                ++i;
            }
        }
        catch (Throwable t) {
            TwoPhaseCommitTool.rollback(objects);
            throw new PrepareCommitFailException(t, tpc);
        }
        try {
            i = 0;
            while (i < objects.length) {
                tpc = objects[i];
                if (tpc != null) {
                    tpc.commit();
                }
                ++i;
            }
        }
        catch (Throwable t) {
            TwoPhaseCommitTool.rollback(objects);
            throw new CommitFailException(t, tpc);
        }
    }

    public static class CommitFailException
    extends IOException {
        public CommitFailException(Throwable cause, TwoPhaseCommit obj) {
            super("commit() failed on " + obj);
            this.initCause(cause);
        }
    }

    public static class PrepareCommitFailException
    extends IOException {
        public PrepareCommitFailException(Throwable cause, TwoPhaseCommit obj) {
            super("prepareCommit() failed on " + obj);
            this.initCause(cause);
        }
    }
}

