/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterPerThread;

abstract class DocumentsWriterPerThreadPool
implements Cloneable {
    private ThreadState[] threadStates;
    private volatile int numThreadStatesActive;

    DocumentsWriterPerThreadPool(int maxNumThreadStates) {
        if (maxNumThreadStates < 1) {
            throw new IllegalArgumentException("maxNumThreadStates must be >= 1 but was: " + maxNumThreadStates);
        }
        this.threadStates = new ThreadState[maxNumThreadStates];
        this.numThreadStatesActive = 0;
        int i = 0;
        while (i < this.threadStates.length) {
            this.threadStates[i] = new ThreadState(null);
            ++i;
        }
    }

    public DocumentsWriterPerThreadPool clone() {
        DocumentsWriterPerThreadPool clone;
        if (this.numThreadStatesActive != 0) {
            throw new IllegalStateException("clone this object before it is used!");
        }
        try {
            clone = (DocumentsWriterPerThreadPool)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.threadStates = new ThreadState[this.threadStates.length];
        int i = 0;
        while (i < this.threadStates.length) {
            clone.threadStates[i] = new ThreadState(null);
            ++i;
        }
        return clone;
    }

    int getMaxThreadStates() {
        return this.threadStates.length;
    }

    int getActiveThreadState() {
        return this.numThreadStatesActive;
    }

    synchronized ThreadState newThreadState() {
        if (this.numThreadStatesActive < this.threadStates.length) {
            ThreadState threadState = this.threadStates[this.numThreadStatesActive];
            threadState.lock();
            boolean unlock = true;
            try {
                if (threadState.isActive()) {
                    ++this.numThreadStatesActive;
                    assert (threadState.dwpt == null);
                    unlock = false;
                    ThreadState threadState2 = threadState;
                    return threadState2;
                }
                assert (this.assertUnreleasedThreadStatesInactive());
                return null;
            }
            finally {
                if (unlock) {
                    threadState.unlock();
                }
            }
        }
        return null;
    }

    private synchronized boolean assertUnreleasedThreadStatesInactive() {
        int i = this.numThreadStatesActive;
        while (i < this.threadStates.length) {
            assert (this.threadStates[i].tryLock()) : "unreleased threadstate should not be locked";
            try {
                assert (!this.threadStates[i].isInitialized()) : "expected unreleased thread state to be inactive";
            }
            finally {
                this.threadStates[i].unlock();
            }
            ++i;
        }
        return true;
    }

    synchronized void deactivateUnreleasedStates() {
        int i = this.numThreadStatesActive;
        while (i < this.threadStates.length) {
            ThreadState threadState = this.threadStates[i];
            threadState.lock();
            try {
                threadState.deactivate();
            }
            finally {
                threadState.unlock();
            }
            ++i;
        }
    }

    DocumentsWriterPerThread reset(ThreadState threadState, boolean closed) {
        assert (threadState.isHeldByCurrentThread());
        DocumentsWriterPerThread dwpt = threadState.dwpt;
        if (!closed) {
            threadState.reset();
        } else {
            threadState.deactivate();
        }
        return dwpt;
    }

    void recycle(DocumentsWriterPerThread dwpt) {
    }

    abstract ThreadState getAndLock(Thread var1, DocumentsWriter var2);

    ThreadState getThreadState(int ord) {
        return this.threadStates[ord];
    }

    ThreadState minContendedThreadState() {
        ThreadState minThreadState = null;
        int limit = this.numThreadStatesActive;
        int i = 0;
        while (i < limit) {
            ThreadState state = this.threadStates[i];
            if (minThreadState == null || state.getQueueLength() < minThreadState.getQueueLength()) {
                minThreadState = state;
            }
            ++i;
        }
        return minThreadState;
    }

    int numDeactivatedThreadStates() {
        int count = 0;
        int i = 0;
        while (i < this.threadStates.length) {
            ThreadState threadState = this.threadStates[i];
            threadState.lock();
            try {
                if (!threadState.isActive) {
                    ++count;
                }
            }
            finally {
                threadState.unlock();
            }
            ++i;
        }
        return count;
    }

    void deactivateThreadState(ThreadState threadState) {
        assert (threadState.isActive());
        threadState.deactivate();
    }

    static final class ThreadState
    extends ReentrantLock {
        DocumentsWriterPerThread dwpt;
        volatile boolean flushPending = false;
        long bytesUsed = 0L;
        private boolean isActive = true;

        ThreadState(DocumentsWriterPerThread dpwt) {
            this.dwpt = dpwt;
        }

        private void deactivate() {
            assert (this.isHeldByCurrentThread());
            this.isActive = false;
            this.reset();
        }

        private void reset() {
            assert (this.isHeldByCurrentThread());
            this.dwpt = null;
            this.bytesUsed = 0L;
            this.flushPending = false;
        }

        boolean isActive() {
            assert (this.isHeldByCurrentThread());
            return this.isActive;
        }

        boolean isInitialized() {
            assert (this.isHeldByCurrentThread());
            return this.isActive() && this.dwpt != null;
        }

        public long getBytesUsedPerThread() {
            assert (this.isHeldByCurrentThread());
            return this.bytesUsed;
        }

        public DocumentsWriterPerThread getDocumentsWriterPerThread() {
            assert (this.isHeldByCurrentThread());
            return this.dwpt;
        }

        public boolean isFlushPending() {
            return this.flushPending;
        }
    }
}

