/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.plugins.searchview;

import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchColumnPreferenceLoader {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnPreferenceLoader");

    public static ColumnOrderAndShow[] loadPreferences(String key, ColumnOrderAndShow[] defaults) {
        String value = PreferencesSettings.getInstance().get(key);
        System.out.println("PREF: " + value);
        if (value != null) {
            String[] values = value.split("\\|");
            ColumnOrderAndShow[] cos = new ColumnOrderAndShow[values.length];
            try {
                ColumnOrderAndShow coas;
                int i = 0;
                while (i < values.length) {
                    cos[i] = new ColumnOrderAndShow(values[i]);
                    ++i;
                }
                Arrays.sort(cos, new Comparator<ColumnOrderAndShow>(){

                    @Override
                    public int compare(ColumnOrderAndShow o1, ColumnOrderAndShow o2) {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        return o1.order - o2.order;
                    }
                });
                LinkedHashMap<String, ColumnOrderAndShow> maps = new LinkedHashMap<String, ColumnOrderAndShow>();
                ColumnOrderAndShow[] columnOrderAndShowArray = cos;
                int n = cos.length;
                int n2 = 0;
                while (n2 < n) {
                    coas = columnOrderAndShowArray[n2];
                    maps.put(coas.name, coas);
                    ++n2;
                }
                columnOrderAndShowArray = defaults;
                n = defaults.length;
                n2 = 0;
                while (n2 < n) {
                    coas = columnOrderAndShowArray[n2];
                    if (maps.get(coas.name) == null) {
                        maps.put(coas.name, coas);
                    } else {
                        ColumnOrderAndShow c = (ColumnOrderAndShow)maps.get(coas.name);
                        if (c.width < 1) {
                            c.width = coas.width;
                        }
                    }
                    ++n2;
                }
                cos = new ColumnOrderAndShow[maps.size()];
                int i2 = 0;
                for (Map.Entry entry : maps.entrySet()) {
                    cos[i2++] = (ColumnOrderAndShow)entry.getValue();
                }
                return cos;
            }
            catch (Exception e) {
                logger.log(Level.INFO, "", e);
            }
        }
        return defaults;
    }

    public static void savePref(String key, String[][] values) {
        boolean valid = true;
        String[][] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String[] t = stringArray[n2];
            if (t.length != 4) {
                valid = false;
                break;
            }
            ++n2;
        }
        if (!valid) {
            logger.log(Level.INFO, "Couldn't save preferences cause of unusable data.");
            return;
        }
        String st = "";
        int i = 0;
        while (i < values.length) {
            String[] value = values[i];
            if (i != 0) {
                st = String.valueOf(st) + "|";
            }
            int j = 0;
            while (j < value.length) {
                if (j != 0) {
                    st = String.valueOf(st) + ";";
                }
                st = String.valueOf(st) + value[j];
                ++j;
            }
            ++i;
        }
        PreferencesSettings.getInstance().put(key, st);
    }

    public static class ColumnOrderAndShow {
        public String name;
        public boolean show;
        public int order;
        public int width;

        public ColumnOrderAndShow(String baseString) throws Exception {
            String[] parts = baseString.split(";");
            if (parts.length != 3 && parts.length != 4) {
                throw new Exception("Invalid ColumnOrderAndShow");
            }
            this.name = parts[0];
            this.show = Boolean.parseBoolean(parts[1]);
            this.order = Integer.parseInt(parts[2]);
            this.width = parts.length == 4 ? Integer.parseInt(parts[3]) : -1;
        }
    }
}

