/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.grid;

import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.GridData;
import ca.infodata.ofys.ui.controls.grid.Selection;
import ca.infodata.util1.PredicateA;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GridSelection<T extends Cell>
extends Selection<T> {
    private static final Logger logger = Logger.getLogger(GridSelection.class.getName());
    private static final long serialVersionUID = 1L;
    private final GridData<T> data;

    public GridSelection(GridData<T> data) {
        this.setSelectionPredicate(new PredicateA<T>(){

            public boolean evaluate(T cell) {
                return !GridSelection.this.contains(cell);
            }
        });
        this.data = data;
    }

    @Override
    protected Collection<T> generateCollection(T from, boolean inclusiveFrom, T to, boolean inclusiveTo) {
        int endCellLine;
        assert (from != null && to != null);
        T start = from;
        T end = to;
        int compareTo = ((Cell)from).compareTo((Cell)to);
        if (compareTo == 0) {
            if (inclusiveFrom || inclusiveTo) {
                ArrayList<T> cells = new ArrayList<T>();
                cells.add(from);
                return cells;
            }
            return Collections.emptyList();
        }
        if (compareTo > 0) {
            start = to;
            end = from;
        }
        ArrayList<T> cells = new ArrayList<T>();
        if (inclusiveFrom) {
            cells.add(from);
        }
        int startCellColumn = ((Cell)start).getColumn();
        int endCellColumn = ((Cell)end).getColumn();
        int startCellLine = ((Cell)start).getLine();
        if (startCellLine == (endCellLine = ((Cell)end).getLine())) {
            int column = startCellColumn + 1;
            while (column < endCellColumn) {
                cells.add(this.data.getCell(column, startCellLine));
                ++column;
            }
        } else {
            int line = startCellLine;
            while (line <= endCellLine) {
                int endColumn;
                int startColumn;
                if (line == startCellLine) {
                    startColumn = startCellColumn;
                    endColumn = this.data.getAbsoluteEndColumn();
                } else if (line == endCellLine) {
                    startColumn = 0;
                    endColumn = endCellColumn;
                } else {
                    startColumn = 0;
                    endColumn = this.data.getAbsoluteEndColumn();
                }
                int column = startColumn;
                while (column <= endColumn) {
                    cells.add(this.data.getCell(column, line));
                    ++column;
                }
                ++line;
            }
        }
        if (inclusiveTo) {
            cells.add(to);
        }
        for (Cell t : cells) {
            if (t != null) continue;
            String message = String.format("from: %s i:%s to:%s i:%s", from, inclusiveFrom, to, inclusiveTo);
            IllegalStateException e = new IllegalStateException("cannot return a null item " + message);
            logger.log(Level.SEVERE, "Error", e);
            throw e;
        }
        return cells;
    }
}

