/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form.combo;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ProvinceCombo
extends MyCombo<XProvince> {
    private static final List<ProvinceCombo> instances = new CopyOnWriteArrayList<ProvinceCombo>();
    private static final CompletionComboAccessorClient.CompletionComboListener listener = new CompletionComboAccessorClient.CompletionComboListener(){
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                ArrayList<ProvinceCombo> toRemoveList = new ArrayList<ProvinceCombo>();
                for (ProvinceCombo combo : instances) {
                    if (combo == null || combo.getControl().isDisposed()) {
                        toRemoveList.add(combo);
                        continue;
                    }
                    combo.fill();
                }
                instances.removeAll(toRemoveList);
            }
        };

        public void shouldRefresh(ICompletionComboItem item) {
            Display.getDefault().asyncExec(this.refresh);
        }
    };
    private static final int STANDARD_TEXT_LIMIT = 100;

    static {
        CompletionComboAccessorClient.addListener((String)"province", (CompletionComboAccessorClient.CompletionComboListener)listener);
    }

    public ProvinceCombo(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, toolkit);
        this.setAutoComplete(true);
        this.setLabelProvider(new ProviderAR<XProvince, String>(){

            public String get(XProvince country) {
                return country == null || country.getText() == null ? "" : country.getName();
            }
        });
        this.setDisplayPredicate(new PredicateA<XProvince>(){

            public boolean evaluate(XProvince c) {
                return c == null || c.getIsDeleted() != null && c.getIsDeleted() == 0;
            }
        });
        this.setTextLimit(100);
        this.fill();
        instances.add(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                instances.remove(ProvinceCombo.this);
            }
        });
    }

    protected void fill() {
        block4: {
            final String text = this.getText();
            final XProvince selection = (XProvince)this.getSelection();
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ProvinceCombo.this.getControl().isDisposed()) {
                                ProvinceCombo.this.removeAllNoNotify();
                                List cities = (List)response.getObj();
                                Collections.sort(cities, new Comparator<XProvince>(){

                                    @Override
                                    public int compare(XProvince pa, XProvince pb) {
                                        if (pa == null && pb == null) {
                                            return 0;
                                        }
                                        if (pa == null) {
                                            return -1;
                                        }
                                        if (pb == null) {
                                            return 1;
                                        }
                                        if (pa.getName() == null && pb.getName() == null) {
                                            return 0;
                                        }
                                        if (pa.getName() == null) {
                                            return -1;
                                        }
                                        if (pb.getName() == null) {
                                            return 1;
                                        }
                                        return pa.getName().trim().compareToIgnoreCase(pb.getName().trim());
                                    }
                                });
                                ProvinceCombo.this.setItems(cities);
                                if (selection != null) {
                                    ProvinceCombo.this.selectNoNotify(selection);
                                } else {
                                    ProvinceCombo.this.setTextNoNotify(text);
                                }
                            }
                        }
                    });
                }
            };
            try {
                CompletionComboAccessorClient.getInstance().findAllAsync(Application.get().getGlobalInstances().getSession(), (ICallback)callback, "province");
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                Log.severe((Throwable)e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    @Override
    public void select(XProvince item) {
        if (item == null) {
            if (this.getDefaultSelection() != null) {
                this.select((XProvince)this.getDefaultSelection());
            } else {
                this.selectNone();
            }
        } else if (this.contains(item)) {
            super.select(item);
        } else {
            this.add(item);
            super.select(item);
        }
    }
}

