/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form.combo;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CityCombo
extends MyCombo<XCity> {
    private static final List<CityCombo> instances = new CopyOnWriteArrayList<CityCombo>();
    private static final CompletionComboAccessorClient.CompletionComboListener listener = new CompletionComboAccessorClient.CompletionComboListener(){
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                ArrayList<CityCombo> toRemoveList = new ArrayList<CityCombo>();
                System.out.println("run");
                for (CityCombo combo : instances) {
                    if (combo == null || combo.getControl().isDisposed()) {
                        toRemoveList.add(combo);
                        continue;
                    }
                    combo.fill();
                }
                instances.removeAll(toRemoveList);
            }
        };

        public void shouldRefresh(ICompletionComboItem item) {
            Display.getDefault().asyncExec(this.refresh);
        }
    };
    private static final int STANDARD_TEXT_LIMIT = 100;

    static {
        CompletionComboAccessorClient.addListener((String)"city", (CompletionComboAccessorClient.CompletionComboListener)listener);
    }

    public CityCombo(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, toolkit);
        this.setAutoComplete(true);
        this.setLabelProvider(new ProviderAR<XCity, String>(){

            public String get(XCity city) {
                return city == null || city.getName() == null ? "" : city.getName();
            }
        });
        this.setDisplayPredicate(new PredicateA<XCity>(){

            public boolean evaluate(XCity c) {
                return c == null || c.getIsDeleted() != null && c.getIsDeleted() == 0;
            }
        });
        this.setTextLimit(100);
        this.fill();
        instances.add(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                instances.remove(CityCombo.this);
            }
        });
    }

    protected void fill() {
        block4: {
            final String text = this.getText();
            final XCity selection = (XCity)this.getSelection();
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!CityCombo.this.getControl().isDisposed()) {
                                CityCombo.this.removeAllNoNotify();
                                List cities = (List)response.getObj();
                                Collections.sort(cities, new Comparator<XCity>(){

                                    @Override
                                    public int compare(XCity ca, XCity cb) {
                                        if (ca == null && cb == null) {
                                            return 0;
                                        }
                                        if (ca == null) {
                                            return -1;
                                        }
                                        if (cb == null) {
                                            return 1;
                                        }
                                        if (ca.getName() == null && cb.getName() == null) {
                                            return 0;
                                        }
                                        if (ca.getName() == null) {
                                            return -1;
                                        }
                                        if (cb.getName() == null) {
                                            return 1;
                                        }
                                        return ca.getName().trim().compareToIgnoreCase(cb.getName().trim());
                                    }
                                });
                                CityCombo.this.setItems(cities);
                                if (selection != null) {
                                    CityCombo.this.selectNoNotify(selection);
                                } else {
                                    CityCombo.this.setTextNoNotify(text);
                                }
                            }
                        }
                    });
                }
            };
            try {
                CompletionComboAccessorClient.getInstance().findAllAsync(Application.get().getGlobalInstances().getSession(), (ICallback)callback, "city");
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                Log.severe((Throwable)e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    @Override
    public void select(XCity item) {
        if (item == null) {
            if (this.getDefaultSelection() != null) {
                this.select((XCity)this.getDefaultSelection());
            } else {
                this.selectNone();
            }
        } else if (this.contains(item)) {
            super.select(item);
        } else {
            this.add(item);
            super.select(item);
        }
    }
}

