/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.ui.controls.FontAwareTable;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.form.LabelProviderAsList;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MyTable<E>
implements IControl {
    private final Table myTable;
    private final ArrayList<E> items = new ArrayList();
    private ProviderAR<E, String[]> labelProvider;

    public MyTable(Composite parent, int style) {
        this.myTable = new FontAwareTable(parent, style);
    }

    public void addColumn(int width, String title, int style, ProviderAR<E, String> provider) {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProviderAsList();
        }
        ((LabelProviderAsList)this.labelProvider).add(provider);
        TableColumn tc = new TableColumn(this.myTable, style);
        tc.setText(title);
        tc.setWidth(width);
    }

    public void setColumns(String ... columns) {
        TableColumn c;
        TableColumn[] columns2;
        if (columns == null) {
            throw new NullPointerException("columns");
        }
        Object[] objectArray = columns2 = this.myTable.getColumns();
        int n = columns2.length;
        int n2 = 0;
        while (n2 < n) {
            c = objectArray[n2];
            c.dispose();
            ++n2;
        }
        objectArray = columns;
        n = columns.length;
        n2 = 0;
        while (n2 < n) {
            c = objectArray[n2];
            TableColumn tc = new TableColumn(this.myTable, 16384);
            tc.setText((String)c);
            tc.setWidth(100);
            ++n2;
        }
    }

    public void setLabelProvider(ProviderAR<E, String[]> labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void updateLabels() {
        TableItem[] tableItems = this.myTable.getItems();
        int i = 0;
        while (i < tableItems.length) {
            tableItems[i].setText(this.getStringForItem(this.items.get(i)));
            ++i;
        }
        this.myTable.update();
    }

    private String[] getStringForItem(E item) {
        if (this.labelProvider != null) {
            return (String[])this.labelProvider.get(item);
        }
        return new String[]{String.valueOf(item)};
    }

    public TableItem add(E item) {
        this.items.add(item);
        TableItem tbItem = new TableItem(this.myTable, -1);
        tbItem.setText(this.getStringForItem(item));
        return tbItem;
    }

    public TableItem add(E item, int i) {
        this.items.add(i, item);
        TableItem tbItem = new TableItem(this.myTable, -1, i);
        tbItem.setText(this.getStringForItem(item));
        return tbItem;
    }

    public void addControlListener(ControlListener listener) {
        this.myTable.addControlListener(listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.myTable.addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.myTable.addFocusListener(listener);
    }

    public void addHelpListener(HelpListener listener) {
        this.myTable.addHelpListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.myTable.addKeyListener(listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.myTable.addListener(eventType, listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.myTable.addMouseListener(listener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.myTable.addMouseMoveListener(listener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.myTable.addMouseTrackListener(listener);
    }

    public void addPaintListener(PaintListener listener) {
        this.myTable.addPaintListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.myTable.addSelectionListener(listener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.myTable.addTraverseListener(listener);
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        return this.myTable.computeSize(hint, hint2, changed);
    }

    public Point computeSize(int hint, int hint2) {
        return this.myTable.computeSize(hint, hint2);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return this.myTable.computeTrim(x, y, width, height);
    }

    public void deselect(int start, int end) {
        this.myTable.deselect(start, end);
    }

    public void deselect(E e) {
        int index = this.items.indexOf(e);
        if (index != -1) {
            this.myTable.deselect(index);
        }
    }

    public void deselect(int index) {
        this.myTable.deselect(index);
    }

    public void deselect(List<E> items) {
        this.myTable.deselect(this.getIndicesOf(items));
    }

    private int[] getIndicesOf(List<E> items) {
        int[] indices = new int[items.size()];
        int count = 0;
        int i = 0;
        while (i < indices.length) {
            int indexOf = this.items.indexOf(items.get(i));
            if (indexOf != -1) {
                indices[i] = indexOf;
                ++count;
            }
            ++i;
        }
        return MyTable.copyOf(indices, count);
    }

    private static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public void deselect(int[] indices) {
        this.myTable.deselect(indices);
    }

    public void deselectAll() {
        this.myTable.deselectAll();
    }

    public void dispose() {
        this.myTable.dispose();
    }

    public boolean equals(Object obj) {
        return this.myTable.equals(obj);
    }

    public boolean forceFocus() {
        return this.myTable.forceFocus();
    }

    public Accessible getAccessible() {
        return this.myTable.getAccessible();
    }

    public Color getBackground() {
        return this.myTable.getBackground();
    }

    public Image getBackgroundImage() {
        return this.myTable.getBackgroundImage();
    }

    public int getBorderWidth() {
        return this.myTable.getBorderWidth();
    }

    public Rectangle getBounds() {
        return this.myTable.getBounds();
    }

    public Rectangle getClientArea() {
        return this.myTable.getClientArea();
    }

    public Object getData() {
        return this.myTable.getData();
    }

    public Object getData(String key) {
        return this.myTable.getData(key);
    }

    public Display getDisplay() {
        return this.myTable.getDisplay();
    }

    public boolean getEnabled() {
        return this.myTable.getEnabled();
    }

    public Font getFont() {
        return this.myTable.getFont();
    }

    public Color getForeground() {
        return this.myTable.getForeground();
    }

    public ScrollBar getHorizontalBar() {
        return this.myTable.getHorizontalBar();
    }

    public E getItem(int index) {
        return this.items.get(index);
    }

    public int getItemCount() {
        return this.myTable.getItemCount();
    }

    public int getItemHeight() {
        return this.myTable.getItemHeight();
    }

    public List<E> getItems() {
        return new ArrayList<E>(this.items);
    }

    public Object getLayoutData() {
        return this.myTable.getLayoutData();
    }

    public Point getLocation() {
        return this.myTable.getLocation();
    }

    public Menu getMenu() {
        return this.myTable.getMenu();
    }

    public Monitor getMonitor() {
        return this.myTable.getMonitor();
    }

    public Composite getParent() {
        return this.myTable.getParent();
    }

    public E getSelection3() {
        int[] selectionIndices = this.getSelectionIndices();
        if (selectionIndices.length == 0) {
            return null;
        }
        return this.items.get(selectionIndices[0]);
    }

    public List<E> getSelection() {
        int[] selectionIndices = this.myTable.getSelectionIndices();
        ArrayList<E> selection = new ArrayList<E>(selectionIndices.length);
        int i = 0;
        while (i < selectionIndices.length) {
            selection.add(this.items.get(selectionIndices[i]));
            ++i;
        }
        return selection;
    }

    public List<E> getCheckedItems() {
        ArrayList<E> list = new ArrayList<E>();
        TableItem[] items = this.myTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem e = items[i];
            if (e.getChecked()) {
                list.add(this.items.get(i));
            }
            ++i;
        }
        return list;
    }

    public E getFirstSelectedItem() {
        int[] selectionIndices = this.myTable.getSelectionIndices();
        if (selectionIndices.length == 0) {
            return null;
        }
        return this.items.get(selectionIndices[0]);
    }

    public int getSelectionCount() {
        return this.myTable.getSelectionCount();
    }

    public int getSelectionIndex() {
        return this.myTable.getSelectionIndex();
    }

    public int[] getSelectionIndices() {
        return this.myTable.getSelectionIndices();
    }

    public Shell getShell() {
        return this.myTable.getShell();
    }

    public Point getSize() {
        return this.myTable.getSize();
    }

    public int getStyle() {
        return this.myTable.getStyle();
    }

    public String getToolTipText() {
        return this.myTable.getToolTipText();
    }

    public int getTopIndex() {
        return this.myTable.getTopIndex();
    }

    public ScrollBar getVerticalBar() {
        return this.myTable.getVerticalBar();
    }

    public boolean getVisible() {
        return this.myTable.getVisible();
    }

    public int hashCode() {
        return this.myTable.hashCode();
    }

    public int indexOf(E item) {
        return this.items.indexOf(item);
    }

    public void internal_dispose_GC(int hdc, GCData data) {
        this.myTable.internal_dispose_GC(hdc, data);
    }

    public boolean isDisposed() {
        return this.myTable.isDisposed();
    }

    public boolean isEnabled() {
        return this.myTable.isEnabled();
    }

    public boolean isFocusControl() {
        return this.myTable.isFocusControl();
    }

    public boolean isListening(int eventType) {
        return this.myTable.isListening(eventType);
    }

    public boolean isReparentable() {
        return this.myTable.isReparentable();
    }

    public boolean isSelected(int index) {
        return this.myTable.isSelected(index);
    }

    public boolean isVisible() {
        return this.myTable.isVisible();
    }

    public void moveAbove(Control control) {
        this.myTable.moveAbove(control);
    }

    public void moveBelow(Control control) {
        this.myTable.moveBelow(control);
    }

    public void notifyListeners(int eventType, Event event) {
        this.myTable.notifyListeners(eventType, event);
    }

    public void pack() {
        this.myTable.pack();
    }

    public void pack(boolean changed) {
        this.myTable.pack(changed);
    }

    public void redraw() {
        this.myTable.redraw();
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.myTable.redraw(x, y, width, height, all);
    }

    public void remove(int start, int end) {
        this.items.removeAll(this.items.subList(start, end));
        this.myTable.remove(start, end);
    }

    public void remove(int index) {
        this.items.remove(index);
        this.myTable.remove(index);
    }

    public void remove(Collection<E> c) {
        for (E e : c) {
            this.remove(e);
        }
    }

    public void remove(int[] indices) {
        int i = 0;
        while (i < indices.length) {
            this.items.remove(i);
            ++i;
        }
        this.myTable.remove(indices);
    }

    public void remove(E item) {
        int index = this.items.indexOf(item);
        if (index != -1) {
            this.items.remove(index);
            this.myTable.remove(index);
        }
    }

    public void removeAll() {
        this.items.clear();
        this.myTable.deselectAll();
        this.myTable.clearAll();
        this.myTable.removeAll();
        this.myTable.setItemCount(0);
    }

    public void removeControlListener(ControlListener listener) {
        this.myTable.removeControlListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.myTable.removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.myTable.removeFocusListener(listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.myTable.removeHelpListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.myTable.removeKeyListener(listener);
    }

    public void removeListener(int eventType, Listener listener) {
        this.myTable.removeListener(eventType, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.myTable.removeMouseListener(listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.myTable.removeMouseMoveListener(listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.myTable.removeMouseTrackListener(listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.myTable.removePaintListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.myTable.removeSelectionListener(listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.myTable.removeTraverseListener(listener);
    }

    public void select(List<E> items) {
        this.myTable.select(this.getIndicesOf(items));
    }

    public void setChecked(E ... items) {
        this.setChecked(Arrays.asList(items));
    }

    public void setChecked(List<E> items) {
        TableItem[] items2;
        int[] indicesOf = this.getIndicesOf(items);
        Object[] objectArray = items2 = this.myTable.getItems();
        int n = items2.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = objectArray[n2];
            item.setChecked(false);
            ++n2;
        }
        objectArray = indicesOf;
        n = indicesOf.length;
        n2 = 0;
        while (n2 < n) {
            TableItem i = objectArray[n2];
            items2[i].setChecked(true);
            ++n2;
        }
    }

    public void select(E item) {
        this.myTable.select(this.items.indexOf(item));
    }

    public void select(int start, int end) {
        this.myTable.select(start, end);
    }

    public void select(int index) {
        this.myTable.select(index);
    }

    public void select(int[] indices) {
        this.myTable.select(indices);
    }

    public void selectAll() {
        this.myTable.selectAll();
    }

    public void setBackground(Color color) {
        this.myTable.setBackground(color);
    }

    public void setBackgroundImage(Image image) {
        this.myTable.setBackgroundImage(image);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.myTable.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle rect) {
        this.myTable.setBounds(rect);
    }

    public void setCapture(boolean capture) {
        this.myTable.setCapture(capture);
    }

    public void setCursor(Cursor cursor) {
        this.myTable.setCursor(cursor);
    }

    public void setData(Object data) {
        this.myTable.setData(data);
    }

    public void setData(String key, Object value) {
        this.myTable.setData(key, value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTable.setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.myTable.setFocus();
    }

    public void setFont(Font font) {
        this.myTable.setFont(font);
    }

    public void setForeground(Color color) {
        this.myTable.setForeground(color);
    }

    public void setItems(E[] items) {
        this.removeAll();
        if (items != null) {
            E[] EArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                E e = EArray[n2];
                this.add(e);
                ++n2;
            }
        }
    }

    public void setItems(Collection<E> items) {
        this.removeAll();
        if (items != null) {
            for (E e : items) {
                this.add(e);
            }
        }
    }

    public void setLayoutData(Object layoutData) {
        this.myTable.setLayoutData(layoutData);
    }

    public void setLocation(int x, int y) {
        this.myTable.setLocation(x, y);
    }

    public void setLocation(Point location) {
        this.myTable.setLocation(location);
    }

    public void setMenu(Menu menu) {
        this.myTable.setMenu(menu);
    }

    public boolean setParent(Composite parent) {
        return this.myTable.setParent(parent);
    }

    public void setRedraw(boolean redraw) {
        this.myTable.setRedraw(redraw);
    }

    public void setSelection(int start, int end) {
        this.myTable.setSelection(start, end);
    }

    public void setSelection(int index) {
        this.myTable.setSelection(index);
    }

    public void setSelection(int[] indices) {
        this.myTable.setSelection(indices);
    }

    public void setSize(int width, int height) {
        this.myTable.setSize(width, height);
    }

    public void setSize(Point size) {
        this.myTable.setSize(size);
    }

    public void setToolTipText(String string) {
        this.myTable.setToolTipText(string);
    }

    public void setTopIndex(int index) {
        this.myTable.setTopIndex(index);
    }

    public void setVisible(boolean visible) {
        this.myTable.setVisible(visible);
    }

    public void showSelection() {
        this.myTable.showSelection();
    }

    public Point toControl(int x, int y) {
        return this.myTable.toControl(x, y);
    }

    public Point toControl(Point point) {
        return this.myTable.toControl(point);
    }

    public Point toDisplay(int x, int y) {
        return this.myTable.toDisplay(x, y);
    }

    public Point toDisplay(Point point) {
        return this.myTable.toDisplay(point);
    }

    public String toString() {
        return this.myTable.toString();
    }

    public boolean traverse(int traversal) {
        return this.myTable.traverse(traversal);
    }

    public void update() {
        this.myTable.update();
    }

    public Table getControl() {
        return this.myTable;
    }

    public int getGridLineWidth() {
        return this.myTable.getGridLineWidth();
    }

    public int getHeaderHeight() {
        return this.myTable.getHeaderHeight();
    }

    public boolean getHeaderVisible() {
        return this.myTable.getHeaderVisible();
    }

    public boolean getLinesVisible() {
        return this.myTable.getLinesVisible();
    }

    public TableColumn getSortColumn() {
        return this.myTable.getSortColumn();
    }

    public int getSortDirection() {
        return this.myTable.getSortDirection();
    }

    public void setHeaderVisible(boolean show) {
        this.myTable.setHeaderVisible(show);
    }

    public void setLinesVisible(boolean show) {
        this.myTable.setLinesVisible(show);
    }

    public void setOrientation(int orientation) {
        this.myTable.setOrientation(orientation);
    }

    public void setSortColumn(TableColumn column) {
        this.myTable.setSortColumn(column);
    }

    public void setSortDirection(int direction) {
        this.myTable.setSortDirection(direction);
    }
}

