/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.assistant.gabarit.tools;

import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.DRaw;
import ca.infodata.ofys.client.modules.template.TemplateDefinitionParser;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import ca.infodata.ofys.ui.controls.template.TemplateAssistTextDialog;
import ca.infodata.ofys.ui.controls.webbrowser.AdvancedBrowser;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.IPair;
import java.util.List;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class TemplateHelper {
    private static final TemplateDefinitionParser parser = new TemplateDefinitionParser();
    private static TemplateAccessorClient accessor = TemplateAccessorClient.getInstance();

    public static String getDescriptionString(XTemplate t) {
        if (t != null && t.getText() != null) {
            return TemplateHelper.getDescriptionString(t.getText());
        }
        return "";
    }

    public static String getDescriptionString(String text) {
        if (text == null) {
            return "";
        }
        List fields = parser.parse(text);
        String s = "";
        for (DField f : fields) {
            s = f instanceof DRaw ? String.valueOf(s) + ((DRaw)f).raw : String.valueOf(s) + "[" + f.name + "]";
        }
        s = s.replaceAll("\n", "<br>").replaceAll(" ", "&nbsp;");
        return s;
    }

    public static String getFinalString(XTemplate element) {
        String text = element.getText();
        if (Boolean.TRUE.equals(element.getIsHtml())) {
            AdvancedBrowser browser = new AdvancedBrowser(UI.getWorkbenchShell(), text);
            browser.open();
            if (browser.isOkPressed()) {
                text = browser.getHtml();
            }
        } else {
            text = TemplateHelper.getFinalString(text);
        }
        if (text != null) {
            accessor.use(element.getId());
        }
        return text;
    }

    public static String getFinalString(String text) {
        return TemplateHelper.getFinalString(text, null);
    }

    public static String getFinalString(String text, TemplateHelperComplexCallback repCallBack) {
        TemplateDefinitionParser parser = new TemplateDefinitionParser();
        List fields = parser.parse(text);
        if (TemplateHelper.containsNonRaw(fields)) {
            ShellAdapter shellAdapter;
            final TemplateAssistTextDialog dialog = new TemplateAssistTextDialog(UI.getWorkbenchShell(), "", text);
            IPair<Shell, Integer> rep = dialog.buildAndOpen2(shellAdapter = new ShellAdapter(){

                public void shellActivated(ShellEvent shellevent) {
                    for (Control list : dialog.getLstListe()) {
                        if (list.isDisposed()) continue;
                        list.notifyListeners(13, new Event());
                    }
                }
            });
            if (rep.getSecond() != null && (Integer)rep.getSecond() == 0) {
                String s;
                text = s = dialog.getWriteText();
                if (repCallBack != null) {
                    repCallBack.callback(dialog);
                }
            } else {
                text = "";
            }
        }
        return text;
    }

    private static boolean containsNonRaw(List<DField> fields) {
        for (DField f : fields) {
            if (f instanceof DRaw) continue;
            return true;
        }
        return false;
    }

    public static abstract class TemplateHelperComplexCallback {
        public abstract void callback(Object ... var1);
    }

    public static abstract class TemplateHelperSimpleCallback {
        public abstract void callback();
    }
}

