/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.util1.ProviderAR;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import net.miginfocom.swt.MigLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TimeZoneChooser {
    private final MyCombo<String> control;
    private final Map<String, String> IDmapDisplay = TimeZoneChooser.getIDMapDisplay(Locale.getDefault(), false);

    public static String getDisplayName(String ID, Locale locale, boolean dst) {
        TimeZone timeZone = TimeZone.getTimeZone(ID);
        int rawOffset = timeZone.getRawOffset() / 60000;
        int hours = rawOffset / 60;
        int minutes = Math.abs(rawOffset) % 60;
        String hrStr = "";
        hrStr = Math.abs(hours) < 10 ? (hours < 0 ? "-0" + Math.abs(hours) : "0" + Math.abs(hours)) : Integer.toString(hours);
        String minStr = minutes < 10 ? "0" + Integer.toString(minutes) : Integer.toString(minutes);
        String str = "(UTC " + (timeZone.getRawOffset() >= 0 ? "+" : "") + hrStr + ":" + minStr + ") " + timeZone.getID().replace('_', ' ');
        return str;
    }

    public static Map<String, String> getIDMapDisplay(Locale locale, boolean dst) {
        TreeMap<String, String> IDmapDisplay = new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String id1, String id2) {
                return TimeZone.getTimeZone(id1).getRawOffset() - TimeZone.getTimeZone(id2).getRawOffset() - 1;
            }
        });
        String[] stringArray = TimeZone.getAvailableIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ID = stringArray[n2];
            if (ID.startsWith("Canada") || ID.startsWith("America")) {
                IDmapDisplay.put(ID, TimeZoneChooser.getDisplayName(ID, locale, dst));
            }
            ++n2;
        }
        IDmapDisplay = new LinkedHashMap(IDmapDisplay);
        return IDmapDisplay;
    }

    public TimeZoneChooser(Composite parent, int style, FormToolkit toolkit) {
        this.control = new MyCombo(parent, style | 8, toolkit);
        this.control.setLabelProvider(new ProviderAR<String, String>(){

            public String get(String ID) {
                return (String)TimeZoneChooser.this.IDmapDisplay.get(ID);
            }
        });
        this.control.setItems(this.IDmapDisplay.keySet());
        this.control.setVisibleItemCount(25);
    }

    public TimeZoneChooser(Composite parent, int style) {
        this.control = new MyCombo(parent, style | 8);
        this.control.setLabelProvider(new ProviderAR<String, String>(){

            public String get(String ID) {
                return (String)TimeZoneChooser.this.IDmapDisplay.get(ID);
            }
        });
        this.control.setItems(this.IDmapDisplay.keySet());
        this.control.setVisibleItemCount(25);
    }

    public void setDefaultSelection(String ID) {
        try {
            this.control.setDefaultSelection(ID);
        }
        catch (Exception exception) {}
    }

    public void addListener(int eventType, Listener listener) {
        this.control.addListener(eventType, listener);
    }

    public Control getControl() {
        return this.control.getControl();
    }

    public Object getData() {
        return this.control.getData();
    }

    public Object getData(String key) {
        return this.control.getData(key);
    }

    public int getItemCount() {
        return this.control.getItemCount();
    }

    public String getSelectedID() {
        return this.control.getSelection();
    }

    public String getText() {
        return this.control.getText();
    }

    public boolean getVisible() {
        return this.control.getVisible();
    }

    public boolean isAutoComplete() {
        return this.control.isAutoComplete();
    }

    public void notifyListeners(int eventType, Event event) {
        this.control.notifyListeners(eventType, event);
    }

    public void removeListener(int eventType, Listener listener) {
        this.control.removeListener(eventType, listener);
    }

    public void selectID(String ID) {
        this.control.select(ID);
    }

    public void selectNone() {
        this.control.selectNone();
    }

    public void setAutoComplete(boolean enable) {
        this.control.setAutoComplete(enable);
    }

    public void setData(Object obj) {
        this.control.setData(obj);
    }

    public void setData(String key, Object obj) {
        this.control.setData(key, obj);
    }

    public boolean setFocus() {
        return this.control.setFocus();
    }

    public void setText(String text) {
        this.control.setText(text);
    }

    public void setTextLimit(int limit) {
        this.control.setTextLimit(limit);
    }

    public void setVisible(boolean visible) {
        this.control.setVisible(visible);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new MigLayout("wrap 1, fillx"));
        final TimeZoneChooser chooser = new TimeZoneChooser((Composite)shell, 8);
        chooser.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                System.out.println("chooser1 : " + chooser.getSelectedID());
            }
        });
        TimeZoneChooser chooser2 = new TimeZoneChooser((Composite)shell, 8);
        chooser2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                System.out.println("chooser2 : " + chooser.getSelectedID());
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

