/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.TimeMask;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TimeText
extends MyMaskedText
implements IControl {
    private static final Logger logger = Logger.getLogger(TimeText.class.getName());

    public TimeText(Composite parent, int style, FormToolkit formToolkit) {
        super(parent, style, formToolkit);
        this.init();
    }

    public TimeText(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    @Override
    public void setMask(MyMask mask) {
        if (!(mask instanceof TimeMask)) {
            throw new IllegalArgumentException("mask must be instance of TimeMask");
        }
        super.setMask(mask);
    }

    protected void init() {
        this.setMask(TimeMask.getInstance());
        this.setValidStyle(8);
        this.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == 'n' || e.character == 'N') {
                    TimeText.this.setToCurrentTime();
                } else if (e.character == 'q' || e.character == 'Q') {
                    TimeText.this.minusOneHour();
                } else if (e.character == 'w' || e.character == 'W') {
                    TimeText.this.addOneHour();
                } else if (e.character == 'a' || e.character == 'A') {
                    TimeText.this.addXMinute(-1);
                } else if (e.character == 's' || e.character == 'S') {
                    TimeText.this.addXMinute(1);
                }
            }
        });
        this.setToolTipText("N --> maintenant\nQ --> enlever 1 heure\nW --> ajouter 1 heure\nA --> enlever 1 minute\nS --> ajouter 1 minute");
    }

    public Integer getHour() {
        String text = null;
        try {
            text = this.getText();
            if (text.length() >= 2) {
                return Integer.parseInt(text.substring(0, 2));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get time for text " + text, e);
        }
        return null;
    }

    public Integer getMinutes() {
        String text = null;
        try {
            text = this.getText();
            if (text.length() == 4) {
                return Integer.parseInt(text.substring(2, 4));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get minutes for text " + text, e);
        }
        return null;
    }

    public void setTimeKeepSelection(Integer minutesFromMidnight) {
        if (minutesFromMidnight == null) {
            this.clear();
        } else {
            this.setTimeKeepSelection(minutesFromMidnight / 60, minutesFromMidnight % 60);
        }
    }

    public void setTime(Integer minutesFromMidnight) {
        if (minutesFromMidnight == null) {
            this.clear();
        } else {
            try {
                this.setTime(minutesFromMidnight / 60, minutesFromMidnight % 60);
            }
            catch (IllegalArgumentException e) {
                System.out.println("minutesFromMidnight was " + minutesFromMidnight);
                throw e;
            }
        }
    }

    public Integer getTime() {
        Integer minutes;
        Integer time = null;
        Integer hour = this.getHour();
        if (hour != null && (minutes = this.getMinutes()) != null) {
            time = hour * 60 + minutes;
        }
        return time;
    }

    public void setTimeKeepSelection(int hour, int minutes) {
        this.setTime(hour, minutes, true);
    }

    public void setTime(int hour, int minutes) {
        this.setTime(hour, minutes, false);
    }

    private void setTime(int hour, int minutes, boolean keepSelection) {
        if (hour > 24 || hour < 0) {
            throw new IllegalArgumentException("hour must be in [0..24] but was " + hour);
        }
        if (minutes < 0 || minutes > 59) {
            throw new IllegalArgumentException("minutes must be in [0..59] but was " + minutes);
        }
        StringBuilder b = new StringBuilder(5);
        if (hour < 10) {
            b.append(0);
        }
        b.append(hour);
        b.append(':');
        if (minutes < 10) {
            b.append(0);
        }
        b.append(minutes);
        if (keepSelection) {
            this.setRawTextKeepSelection(b.toString());
        } else {
            this.setRawText(b.toString());
        }
    }

    public void setToCurrentTime() {
        Calendar c = Calendar.getInstance();
        this.setTime(c.get(11), c.get(12));
    }

    public void addOneHour() {
        Integer time = this.getTime();
        if (time == null) {
            Calendar c = Calendar.getInstance();
            this.setTime(c.get(11) + 1, c.get(12));
        } else {
            int min = time + 60;
            if (min >= 1440) {
                min = 1439;
            }
            this.setTime(min);
        }
    }

    public void minusOneHour() {
        Integer time = this.getTime();
        if (time == null) {
            Calendar c = Calendar.getInstance();
            this.setTime(c.get(11) - 1, c.get(12));
        } else {
            int min = time - 60;
            if (min < 0) {
                min = 0;
            }
            this.setTime(min);
        }
    }

    public void addXMinute(int x) {
        Integer time = this.getTime();
        if (time == null) {
            Calendar c = Calendar.getInstance();
            this.setTime(c.get(11), c.get(12) + x);
        } else {
            int min = time + x;
            if (min >= 1440) {
                min = 1439;
            }
            if (min < 0) {
                min = 0;
            }
            this.setTime(min);
        }
    }

    @Override
    public Point computeSize(int xhint, int yhint) {
        Point size = super.computeSize(35, yhint);
        return size;
    }
}

