/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PostalCodeText {
    private final MyMaskedText maskedText;
    private String country;

    public PostalCodeText(Composite parent, int style, FormToolkit toolkit) {
        this.maskedText = new MyMaskedText(parent, style, toolkit);
    }

    public PostalCodeText(Composite parent, int style) {
        this.maskedText = new MyMaskedText(parent, style);
    }

    public MyMaskedText getMaskedText() {
        return this.maskedText;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
        if ("CANADA".equalsIgnoreCase(country)) {
            this.maskedText.setMask(MyMasks.canadaPostalCode);
            this.maskedText.setValidStyle(this.maskedText.getValidStyle() | 8 | 2);
        } else {
            this.maskedText.setMask(MyMasks.otherPostalCode);
            this.maskedText.setValidStyle(this.maskedText.getValidStyle() & 0xFFFFFFF7);
        }
    }

    public String getText() {
        return this.maskedText.getText();
    }

    public void setText(String string) {
        this.maskedText.setRawText(string);
    }

    public void setRawText(String string) {
        this.maskedText.setRawText(string);
    }

    public void setRawTextKeepSelection(String string) {
        this.maskedText.setRawTextKeepSelection(string);
    }

    public Control getControl() {
        return this.maskedText.getControl();
    }

    public void setVisible(boolean b) {
        this.maskedText.setVisible(b);
    }
}

