/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.dataaccess.util.MyMessageDialog;
import ca.infodata.util1.http.download.SyncProgressMonitor;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class DownloadProgressDialogSWT
extends MyMessageDialog {
    private ProgressBar progressBar;
    private SyncProgressMonitor monitor = new SyncProgressMonitor(){

        public void update() {
            DownloadProgressDialogSWT.this.update();
        }

        public void setDone() {
            DownloadProgressDialogSWT.this.setDone();
        }

        public void setCurrentFile(String currentFile) {
            super.setCurrentFile(currentFile);
        }

        public void setCurrentFileTotalBytes(Long currentFileTotalBytes) {
            super.setCurrentFileTotalBytes(currentFileTotalBytes);
            this.setTotalBytes(currentFileTotalBytes);
        }

        public void setCurrentFileWorkedBytes(Long currentFileWorkedBytes) {
            super.setCurrentFileWorkedBytes(currentFileWorkedBytes);
            this.setWorkedBytes(currentFileWorkedBytes);
        }
    };
    private Label lblFile;
    private String lblFileText;
    private Label lblMessage;
    private String lblMessageText;

    public DownloadProgressDialogSWT(Shell parent) {
        super(parent, "T\u00e9l\u00e9chargement...", "", -1, new String[]{"Annuler"}, -1);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.monitor.setPaused(true);
            boolean doCancel = MyMessageDialog.openConfirm((Shell)this.getShell(), (String)"Question", (String)"\u00cates-vous certains de vouloir annuler le t\u00e9l\u00e9chargement?");
            if (doCancel) {
                this.monitor.setMessage("L'utilisateur a annul\u00e9");
                this.monitor.setCanceled();
                this.close();
            } else {
                this.monitor.setPaused(false);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        this.lblFile = new Label(main, 16384);
        this.lblFile.setText(this.lblFileText == null ? "" : this.lblFileText);
        this.lblMessage = new Label(main, 16384);
        this.lblMessage.setText(this.lblMessageText == null ? "" : this.lblMessageText);
        this.progressBar = new ProgressBar(main, 65536);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        main.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblFile.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.lblFile);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblMessage.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.lblMessage);
        data.left = new FormAttachment(0);
        data.width = 300;
        this.progressBar.setLayoutData((Object)data);
        return main;
    }

    protected void update() {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DownloadProgressDialogSWT.this.update_f2();
                }
            });
        } else {
            this.lblFileText = this.monitor.getCurrentFile();
            this.lblMessageText = this.monitor.getMessage();
        }
    }

    private void update_f2() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        this.lblFile.setText(this.monitor.getCurrentFile() == null ? "" : this.monitor.getCurrentFile());
        if (this.monitor.getMessage() != null) {
            this.lblMessage.setText(this.monitor.getMessage());
        }
        this.progressBar.setMinimum(0);
        if (this.monitor.getTotalBytes() != null) {
            this.progressBar.setMaximum((int)(this.monitor.getTotalBytes() / 1024L));
        }
        if (this.monitor.getWorkedBytes() != null) {
            this.progressBar.setSelection((int)(this.monitor.getWorkedBytes() / 1024L));
        }
        this.progressBar.update();
    }

    public void setDone() {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    DownloadProgressDialogSWT.this.close();
                }
            });
        }
    }

    public SyncProgressMonitor getMonitor() {
        return this.monitor;
    }

    public int open() {
        int open = super.open();
        return open;
    }
}

