/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.TimeText;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.TimeZoneProvider;
import java.util.Calendar;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.mb.listeners.GenListenerManager;

public class DateTimeText
extends Composite {
    private MyCalendarText dateText;
    private TimeText timeText;
    private GenListenerManager<IDateTimeListener> listenerManager = new GenListenerManager(IDateTimeListener.class, false);
    private Button btnShowCalendar;

    public DateTimeText(Composite parent, int style) {
        this(parent, style, null, true);
    }

    public DateTimeText(Composite parent, int style, FormToolkit toolkit, boolean withCalendarButton) {
        super(parent, style);
        this.dateText = new MyCalendarText(this, style, toolkit, false);
        this.timeText = new TimeText(this, style, toolkit);
        if (withCalendarButton) {
            if (toolkit == null) {
                this.btnShowCalendar = new Button((Composite)this, 0x800000);
                this.btnShowCalendar.setText("...");
            } else {
                this.btnShowCalendar = toolkit.createButton((Composite)this, "...", 0x800000);
            }
        }
        if (toolkit != null) {
            toolkit.adapt((Composite)this);
        }
        this.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        this.dateText.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(this.dateText.getControl());
        data.right = new FormAttachment(100, withCalendarButton ? -20 : 0);
        this.timeText.setLayoutData(data);
        if (withCalendarButton) {
            data = new FormData();
            data.left = new FormAttachment(this.timeText.getControl(), 0);
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(this.timeText.getControl(), 0, 1024);
            data.right = new FormAttachment(100, 0);
            this.btnShowCalendar.setLayoutData((Object)data);
            this.btnShowCalendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (DateTimeText.this.dateText.isCalendarVisible()) {
                        DateTimeText.this.dateText.closeCalendar();
                    } else {
                        DateTimeText.this.dateText.showCalendar();
                    }
                }
            });
        }
        this.dateText.addDateListener(new DateText.DateAdapter(){

            @Override
            public void dateChanged(LocalDate date) {
                ((IDateTimeListener)DateTimeText.this.listenerManager.getProxy()).datetimeChanged();
            }
        });
        this.timeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((IDateTimeListener)DateTimeText.this.listenerManager.getProxy()).datetimeChanged();
            }
        });
    }

    public void setDateTime(Long millis) {
        if (millis == null) {
            this.dateText.setDate(null);
            this.timeText.clear();
        } else {
            Calendar c = Calendar.getInstance(TimeZoneProvider.getTimeZone(), LocaleProvider.getLocale());
            c.setTimeInMillis(millis);
            LocalDate date = LocalDate.fromCalendar((Calendar)c);
            this.dateText.setDate((IPartialDate)date);
            this.timeText.setTime(c.get(11), c.get(12));
        }
    }

    public Long getDateTimeAsMilis() {
        LocalDate date = this.dateText.getDate();
        if (date != null) {
            Calendar c = date.toCalendar();
            Integer hour = this.timeText.getHour();
            if (hour != null) {
                c.set(11, hour);
                Integer minutes = this.timeText.getMinutes();
                if (minutes != null) {
                    c.set(12, minutes);
                }
            }
            return c.getTimeInMillis();
        }
        return null;
    }

    public void addDateTimeListener(IDateTimeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listenerManager.addListener((Object)listener);
    }

    public void removeDateTimeListener(IDateTimeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listenerManager.removeListener((Object)listener);
    }

    public Control getControl() {
        return this;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point dateSize = this.dateText.computeSize(-1, -1);
        Point timeSize = this.timeText.computeSize(-1, -1);
        return new Point(dateSize.x + timeSize.x + 20, dateSize.y);
    }

    public static interface IDateTimeListener {
        public void datetimeChanged();
    }
}

