/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XFormatDate;
import ca.infodata.ofys.ui.controls.DateMask;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.IRelativeDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import ca.infodata.util1.date.PartialDate;
import ca.infodata.util1.date.RelativeDate;
import ca.infodata.util1.date.RelativeDateParser;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DateText
extends MyMaskedText {
    private static final Logger logger = Logger.getLogger(IDateListener.class.getName());
    public static IPartialDate dateIdem;
    private String rawTextCache;
    private IPartialDate dateCache;
    private boolean allowPartial;
    private boolean allowRelative;
    private ArrayList<IDateListener> dateListeners = new ArrayList();
    static boolean ignore;

    static {
        ignore = false;
    }

    public DateText(Composite parent, int style, FormToolkit formToolkit) {
        super(parent, style, formToolkit);
        this.init();
    }

    public DateText(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    private void init() {
        this.setMask(DateMask.getInstance());
        this.setValidStyle(8);
        Listener listener = new Listener(){
            private IPartialDate dateCache2;
            private LocalDate dateCache3;

            public void handleEvent(Event e) {
                if (!DateText.this.getEditable()) {
                    return;
                }
                switch (e.type) {
                    case 1: {
                        DateText.this.processCustomKeys(e);
                        break;
                    }
                    case 15: {
                        DateText.this.selectAll();
                        DateText.this.showMask(false);
                        break;
                    }
                    case 16: {
                        dateIdem = DateText.this.getDate();
                        if (!DateText.this.allowPartial && dateIdem == null && !DateText.this.getText().isEmpty()) {
                            DateText.this.autoComplete();
                        }
                        DateText.this.showMask(true);
                        break;
                    }
                    case 24: {
                        LocalDate date;
                        IPartialDate partial;
                        if (DateText.this.allowPartial && this.dateCache2 != (partial = DateText.this.getPartialDate())) {
                            DateText.this.firePartialDateChanged(partial);
                            this.dateCache2 = partial;
                        }
                        if (this.dateCache3 == (date = DateText.this.getDate())) break;
                        DateText.this.fireDateChanged(date);
                        this.dateCache3 = date;
                        break;
                    }
                }
            }
        };
        this.addListener(1, listener);
        this.addListener(15, listener);
        this.addListener(16, listener);
        this.addListener(24, listener);
        this.showMask(true);
        this.setToolTipText(Messages.getString((String)"DATE_TTT", (String[])new String[0]));
    }

    private void showMask(boolean v) {
    }

    @Override
    public void setMask(MyMask mask) {
        if (!this.allowRelative && !(mask instanceof DateMask)) {
            throw new IllegalArgumentException("mask must be instance of DateMask");
        }
        super.setMask(mask);
    }

    @Override
    public void setRawText(String string) {
        if (string == null || string.length() == 0) {
            super.setRawText(string);
            this.showMask(true);
        } else {
            this.showMask(false);
            super.setRawText(string);
        }
    }

    @Override
    public void setRawTextKeepSelection(String string) {
        if (string == null || string.length() == 0) {
            this.showMask(true);
        } else {
            this.showMask(false);
            super.setRawTextKeepSelection(string);
        }
    }

    @Override
    public void setText(String string) {
        if (string == null || string.length() == 0) {
            this.showMask(true);
        } else {
            this.showMask(false);
            super.setText(string);
        }
    }

    private void autoComplete() {
        XFormatDate formatDate = FormatDateProvider.getFormatDate();
        if (XFormatDate.YYYY_MM_DD.equals((Object)formatDate)) {
            String rawText = this.getRawText();
            int length = rawText.length();
            LocalDate date = LocalDate.today().withDay(1);
            if (length >= 4) {
                try {
                    int year = Integer.parseInt(rawText.substring(0, 4));
                    date = date.withYear(year);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (length >= 5) {
                try {
                    int month = Integer.parseInt(rawText.substring(5, Math.min(7, length)));
                    date = date.withMonth(month);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.setDate((IPartialDate)date);
        } else if (XFormatDate.MM_DD_YYYY.equals((Object)formatDate)) {
            String rawText = this.getRawText();
            int length = rawText.length();
            if (length >= 3 && length <= 4) {
                try {
                    int day = Integer.parseInt(rawText.substring(0, 2));
                    int month = Integer.parseInt(rawText.substring(2));
                    this.setDate((IPartialDate)LocalDate.today().withMonth(month).withDay(day));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (length >= 1 && length <= 2) {
                try {
                    int month = Integer.parseInt(rawText);
                    this.setDate((IPartialDate)LocalDate.today().withDay(month));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else if (XFormatDate.DD_MM_YYYY.equals((Object)formatDate)) {
            String rawText = this.getRawText();
            int length = rawText.length();
            if (length >= 3 && length <= 4) {
                try {
                    int month = Integer.parseInt(rawText.substring(0, 2));
                    int day = Integer.parseInt(rawText.substring(2));
                    this.setDate((IPartialDate)LocalDate.today().withMonth(month).withDay(day));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (length >= 1 && length <= 2) {
                try {
                    int day = Integer.parseInt(rawText);
                    this.setDate((IPartialDate)LocalDate.today().withDay(day));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    private void processCustomKeys(Event e) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getEditable()) {
            return;
        }
        if (this.allowRelative) {
            return;
        }
        if (e.keyCode == 127) {
            this.setDate(null);
            return;
        }
        if (e.character == '\u0000' && e.keyCode == 0) {
            return;
        }
        IPartialDate date = this.getPartialDate();
        if (date == null) {
            date = LocalDate.today();
        }
        switch (e.character) {
            case 'T': 
            case 't': {
                this.setDate((IPartialDate)LocalDate.today());
                break;
            }
            case 'D': 
            case 'd': {
                break;
            }
            case 'X': 
            case 'x': {
                this.plusDay(date, 1);
                break;
            }
            case 'Z': 
            case 'z': {
                this.plusDay(date, -1);
                break;
            }
            case 'S': 
            case 's': {
                this.plusDay(date, 7);
                break;
            }
            case 'A': 
            case 'a': {
                this.plusDay(date, -7);
                break;
            }
            case 'W': 
            case 'w': {
                this.plusMonth(date, 1);
                break;
            }
            case 'Q': 
            case 'q': {
                this.plusMonth(date, -1);
                break;
            }
            case 'E': 
            case 'e': {
                this.plusYear(date, -1);
                break;
            }
            case 'R': 
            case 'r': {
                this.plusYear(date, 1);
                break;
            }
            case 'M': 
            case 'm': {
                this.withMonthFirst(date);
                break;
            }
            case 'H': 
            case 'h': {
                this.withMonthEnd(date);
                break;
            }
            case 'I': 
            case 'i': {
                if (dateIdem == null) break;
                this.setDate(dateIdem);
            }
        }
    }

    private void withMonthEnd(IPartialDate date) {
        assert (date != null);
        if (date instanceof LocalDate) {
            this.setDate((IPartialDate)((LocalDate)date).withDay(((LocalDate)date).getMonthEnd()));
        }
        if (date instanceof PartialDate) {
            LocalDate today = LocalDate.today();
            PartialDate partial = (PartialDate)date;
            int day2 = partial.getDay() == null ? today.day : partial.getDay();
            int month2 = partial.getMonth() == null ? today.month : partial.getMonth();
            int year2 = partial.getYear() == null ? today.year : partial.getYear();
            LocalDate date2 = LocalDate.from((int)day2, (int)month2, (int)year2);
            this.setDate((IPartialDate)date2.withDay(date2.getMonthEnd()));
        }
    }

    private void withMonthFirst(IPartialDate date) {
        assert (date != null);
        if (date instanceof LocalDate) {
            this.setDate((IPartialDate)((LocalDate)date).withDay(1));
        }
        if (date instanceof PartialDate) {
            LocalDate today = LocalDate.today();
            PartialDate partial = (PartialDate)date;
            int day2 = partial.getDay() == null ? today.day : partial.getDay();
            int month2 = partial.getMonth() == null ? today.month : partial.getMonth();
            int year2 = partial.getYear() == null ? today.year : partial.getYear();
            this.setDate((IPartialDate)LocalDate.from((int)day2, (int)month2, (int)year2).withDay(1));
        }
    }

    private void plusDay(IPartialDate partial, int day) {
        assert (partial != null);
        LocalDate today = LocalDate.today();
        int day2 = partial.getDay() == null ? today.day : partial.getDay();
        int month2 = partial.getMonth() == null ? today.month : partial.getMonth();
        int year2 = partial.getYear() == null ? today.year : partial.getYear();
        this.setDate((IPartialDate)LocalDate.from((int)day2, (int)month2, (int)year2).plusDay(day));
    }

    private void plusMonth(IPartialDate partial, int month) {
        assert (partial != null);
        LocalDate newDate = LocalDate.from((IPartialDate)partial).plusMonth(month);
        Integer day2 = partial.getDay();
        if (day2 != null) {
            if (day2 > newDate.getMonthEnd()) {
                day2 = newDate.getMonthEnd();
            } else if (day2 < 1) {
                day2 = 1;
            }
            newDate.withDay(day2.intValue());
        }
        PartialDate newPartial = PartialDate.from((LocalDate)newDate);
        this.setDate((IPartialDate)PartialDate.from((Integer)(day2 == null ? null : newPartial.getDay()), (Integer)newPartial.getMonth(), (Integer)newPartial.getYear()));
    }

    private void plusYear(IPartialDate partial, int year) {
        Integer day2;
        assert (partial != null);
        LocalDate today = LocalDate.today();
        int year2 = partial.getYear() == null ? today.year : partial.getYear();
        LocalDate newDate = today.withYear(year2 += year);
        Integer month2 = partial.getMonth();
        if (month2 != null) {
            if (month2 < 1) {
                month2 = 1;
            } else if (month2 > 12) {
                month2 = 12;
            }
            newDate = newDate.withMonth(month2.intValue());
        }
        if ((day2 = partial.getDay()) != null) {
            if (day2 > newDate.getMonthEnd()) {
                day2 = newDate.getMonthEnd();
            } else if (day2 < 1) {
                day2 = 1;
            }
        }
        this.setDate((IPartialDate)PartialDate.from((Integer)day2, (Integer)month2, (Integer)year2));
    }

    public void setDate(IPartialDate date) {
        if (date == null) {
            this.clear();
        } else if (date == this.dateCache) {
            this.setRawText(this.getRawText());
        } else if (date instanceof LocalDate) {
            this.setRawText(LocalDateFormat.format((LocalDate)((LocalDate)date), (String)FormatDateProvider.getFormatDate().toString()));
        } else {
            this.setRawText(XFormatDate.formatPartialDate((IPartialDate)date));
        }
    }

    public void setRelativeDate(IRelativeDate date) {
        if (date == null) {
            this.clear();
        } else {
            this.setRawText(RelativeDate.format((IRelativeDate)date));
        }
    }

    public IRelativeDate getRelativeDate() {
        IPartialDate date = this.getPartialDate();
        if (date != null) {
            return date;
        }
        return new RelativeDateParser().parse(this.getText());
    }

    public LocalDate getDate() {
        IPartialDate date = this.getPartialDate();
        if (date == null) {
            return null;
        }
        if (date instanceof LocalDate) {
            return (LocalDate)date;
        }
        if (date.isComplete()) {
            return LocalDate.from((IPartialDate)date);
        }
        return null;
    }

    public IPartialDate getPartialDate() {
        IPartialDate date = this.dateCache;
        String rawText = this.getText();
        if (rawText.equals(this.rawTextCache)) {
            return this.dateCache;
        }
        int len = rawText.length();
        if (len == 0) {
            date = null;
        } else {
            int[] yPos = FormatDateProvider.getFormatDate().getYearPosition();
            int[] mPos = FormatDateProvider.getFormatDate().getMonthPosition();
            int[] dPos = FormatDateProvider.getFormatDate().getDayPosition();
            if (len <= 4 && this.allowPartial) {
                try {
                    int year = Integer.parseInt(rawText);
                    date = PartialDate.from(null, null, (Integer)year);
                }
                catch (Exception exception) {
                    date = null;
                }
            } else if (len <= 6 && this.allowPartial) {
                try {
                    int year = yPos[0] == 0 ? Integer.parseInt(rawText.substring(0, 4)) : Integer.parseInt(rawText.substring(len - 4, len));
                    int month = mPos[0] == 4 ? Integer.parseInt(rawText.substring(4, len)) : Integer.parseInt(rawText.substring(0, len - 4));
                    System.out.println(String.valueOf(year) + " " + month);
                    date = PartialDate.from(null, (Integer)(month == 0 ? null : Integer.valueOf(month)), (Integer)year);
                }
                catch (Exception exception) {
                    date = null;
                }
            } else if (len < 8 && this.allowPartial) {
                try {
                    int month;
                    int year;
                    int n = year = yPos[0] == 0 ? Integer.parseInt(rawText.substring(0, 4)) : Integer.parseInt(rawText.substring(len - 4, len));
                    int n2 = mPos[0] == 4 ? Integer.parseInt(rawText.substring(4, 6)) : (month = mPos[0] == 0 ? Integer.parseInt(rawText.substring(mPos[0], len - 6)) : Integer.parseInt(rawText.substring(mPos[0], mPos[1])));
                    int day = dPos[0] == 6 ? Integer.parseInt(rawText.substring(6, len)) : (dPos[0] == 0 ? Integer.parseInt(rawText.substring(dPos[0], len - 6)) : Integer.parseInt(rawText.substring(dPos[0], dPos[1])));
                    date = PartialDate.from((Integer)(day == 0 ? null : Integer.valueOf(day)), (Integer)month, (Integer)year);
                }
                catch (Exception exception) {
                    date = null;
                }
            } else if (len == 8) {
                try {
                    int year = Integer.parseInt(rawText.substring(yPos[0], yPos[1]));
                    int month = Integer.parseInt(rawText.substring(mPos[0], mPos[1]));
                    int day = Integer.parseInt(rawText.substring(dPos[0], dPos[1]));
                    date = PartialDate.from((Integer)(day == 0 ? null : Integer.valueOf(day)), (Integer)month, (Integer)year);
                }
                catch (Exception exception) {
                    date = null;
                }
            } else if (len > 8 && len < 10) {
                try {
                    int year = Integer.parseInt(rawText.substring(0, 4));
                    int month = Integer.parseInt(rawText.substring(4, 6));
                    int day = Integer.parseInt(rawText.substring(6, 8));
                    date = PartialDate.from((Integer)(day == 0 ? null : Integer.valueOf(day)), (Integer)month, (Integer)year);
                }
                catch (Exception exception) {
                    date = null;
                }
            } else if (rawText.length() == 10) {
                try {
                    date = LocalDateFormat.parse((String)rawText, (String)FormatDateProvider.getFormatDate().toString());
                }
                catch (Exception exception) {
                    date = null;
                }
            } else {
                date = null;
            }
        }
        this.rawTextCache = rawText;
        this.dateCache = date;
        return date;
    }

    public void addDateListener(IDateListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.dateListeners.add(listener);
    }

    public void removeDateListener(IDateListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.dateListeners.remove(listener);
    }

    private void firePartialDateChanged(IPartialDate date) {
        try {
            for (IDateListener listener : this.dateListeners) {
                listener.partialChanged(date);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while notifying dateChanged event", e);
        }
    }

    private void fireDateChanged(LocalDate date) {
        try {
            for (IDateListener listener : this.dateListeners) {
                listener.dateChanged(date);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while notifying dateChanged event", e);
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        final DateText dateText = new DateText((Composite)shell, 2048);
        dateText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ignore) {
                    return;
                }
                System.out.println(dateText.getDate());
                ignore = true;
                dateText.setRawTextKeepSelection(dateText.getRawText());
                ignore = false;
            }
        });
        Button button = new Button((Composite)shell, 8);
        button.setText("test");
        button.setFocus();
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                dateText.clear();
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public boolean getAllowPartial() {
        return this.allowPartial;
    }

    public void setAllowPartial(boolean allowPartial) {
        this.allowPartial = allowPartial;
    }

    public boolean getAllowRelative() {
        return this.allowRelative;
    }

    public void setAllowRelative(boolean allowRelative) {
        this.allowRelative = allowRelative;
        if (this.allowRelative) {
            this.setMask(null);
        }
    }

    public static class DateAdapter
    implements IDateListener {
        @Override
        public void dateChanged(LocalDate date) {
        }

        @Override
        public void partialChanged(IPartialDate date) {
        }
    }

    public static interface IDateListener {
        public void dateChanged(LocalDate var1);

        public void partialChanged(IPartialDate var1);
    }
}

