/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator2;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.ISwitchTable;
import ca.infodata.ofys.ui.controls.ISwitchTableListener;
import ca.infodata.ofys.ui.controls.ListTable;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseSwitchTable<E extends EditableDataObject>
extends Composite
implements ISwitchTable {
    public static final int BUTTON_WIDTH = 150;
    protected FormToolkit toolkit;
    private Composite cEdit;
    private ListTable<E> listTableSwitch;
    private int maxHeight = -1;
    private IBaseEditor2 parentEditor;
    private int styleList;
    private final List<ISwitchTableListener> listeners = new ArrayList<ISwitchTableListener>(1);
    private boolean switchOnNextLeave = true;
    private boolean isInEdition = false;

    public BaseSwitchTable(Composite parent, IBaseEditor2 parentEditor, int styleList, FormToolkit toolkit) {
        this(parent, parentEditor, styleList, toolkit, false);
    }

    public BaseSwitchTable(Composite parent, IBaseEditor2 parentEditor, int styleList, FormToolkit toolkit, boolean waitForControlCreation) {
        super(parent, 0);
        parentEditor.registerSwitchTable(this);
        this.toolkit = toolkit;
        this.parentEditor = parentEditor;
        this.styleList = styleList;
        toolkit.adapt((Composite)this);
        if (!waitForControlCreation) {
            this.createPartControl(this, styleList);
        }
    }

    public void createControls() {
        this.createPartControl(this, this.styleList);
    }

    private void switchFocus() {
        this.listTableSwitch.setVisible(!this.listTableSwitch.getVisible());
        this.cEdit.setVisible(!this.cEdit.getVisible());
        FormData data = new FormData();
        if (!this.cEdit.isVisible()) {
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(0);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(0);
        } else {
            data.top = new FormAttachment(0);
            data.bottom = new FormAttachment(100);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
        }
        this.cEdit.setLayoutData((Object)data);
        this.getParent().getParent().pack();
        this.switched();
    }

    public void createPartControl(Composite parent, int styleList) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        this.cEdit = this.toolkit.createComposite(parent);
        this.cEdit.setLayout((Layout)layout);
        final BaseSwitchTable baseSwitch = this;
        this.listTableSwitch = new ListTable<E>(parent, this.parentEditor, this.toolkit, styleList){

            @Override
            public E initializeNewDataObject() {
                return baseSwitch.initializeNewDataObject();
            }

            @Override
            protected void enterEditionMode(E selection) {
                if ((this.style | HIDE_NEW_DELETE) != this.style) {
                    BaseSwitchTable.this.setInEdition(true);
                    BaseSwitchTable.this.showDataObject(selection);
                    if (BaseSwitchTable.this.switchOnNextLeave) {
                        BaseSwitchTable.this.switchFocus();
                    }
                }
            }

            @Override
            protected void leaveEditionMode() {
                BaseSwitchTable.this.setInEdition(false);
                baseSwitch.leaveEditionMode();
                if (BaseSwitchTable.this.switchOnNextLeave) {
                    BaseSwitchTable.this.switchFocus();
                }
            }

            @Override
            public IPreValidator getPreValidatorNewInstance() {
                return baseSwitch.getPreValidatorNewInstance();
            }

            @Override
            public IPreValidator2<E> getPreValidatorNewInstance2() {
                return baseSwitch.getPreValidatorNewInstance2();
            }

            @Override
            public String getToolTip() {
                return null;
            }

            @Override
            protected boolean saving(E dataObject) {
                return baseSwitch.saving(dataObject);
            }

            @Override
            protected boolean deleting(E dataObject) {
                return baseSwitch.deleting(dataObject);
            }
        };
        this.cEdit.setLayout((Layout)new FormLayout());
        Composite editionComposite = this.toolkit.createComposite(this.cEdit);
        final Composite buttonsComposite = this.toolkit.createComposite(this.cEdit);
        FormLayout buttonsLayout = new FormLayout();
        buttonsLayout.spacing = 5;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        final MyButton btnSave = new MyButton(buttonsComposite, Messages.getString((String)"OK", (String[])new String[0]), 8, this.toolkit);
        final MyButton btnSaveNext = new MyButton(buttonsComposite, Messages.getString((String)"OKNOUVEAU", (String[])new String[0]), 8, this.toolkit);
        final MyButton btnCancel = new MyButton(buttonsComposite, Messages.getString((String)"ANNULER", (String[])new String[0]), 8, this.toolkit);
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BaseSwitchTable.this.getListTableSwitch().save();
            }
        });
        btnSaveNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BaseSwitchTable.this.switchOnNextLeave = false;
                if (BaseSwitchTable.this.getListTableSwitch().save()) {
                    BaseSwitchTable.this.getListTableSwitch().editItem(BaseSwitchTable.this.initializeNewDataObject());
                }
                BaseSwitchTable.this.switchOnNextLeave = true;
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BaseSwitchTable.this.getListTableSwitch().cancel();
            }
        });
        buttonsComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                FormData data = new FormData();
                data.left = new FormAttachment(0);
                if (buttonsComposite.getSize().x > 450) {
                    data.width = 150;
                } else {
                    data.right = new FormAttachment(32);
                }
                btnSave.setLayoutData(data);
                data = new FormData();
                data.left = new FormAttachment(btnSave.getControl());
                if (buttonsComposite.getSize().x > 450) {
                    data.width = 150;
                } else {
                    data.right = new FormAttachment(66);
                }
                btnSaveNext.setLayoutData(data);
                data = new FormData();
                data.left = new FormAttachment(btnSaveNext.getControl());
                if (buttonsComposite.getSize().x > 450) {
                    data.width = 150;
                } else {
                    data.right = new FormAttachment(100);
                }
                btnCancel.setLayoutData(data);
            }
        });
        this.createEditionControl(editionComposite);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        parent.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(0);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(0);
        this.cEdit.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        if (this.getMaxHeight() > -1) {
            data.height = this.getMaxHeight();
        } else {
            data.bottom = new FormAttachment(100);
        }
        this.listTableSwitch.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        editionComposite.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)editionComposite);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        buttonsComposite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.width = 150;
        btnSave.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(btnSave.getControl());
        data.width = 150;
        btnSaveNext.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(btnSaveNext.getControl());
        data.width = 150;
        btnCancel.setLayoutData(data);
        this.listTableSwitch.setVisible(true);
        this.cEdit.setVisible(false);
        this.toolkit.paintBordersFor(parent);
    }

    protected boolean saving(E dataObject) {
        return true;
    }

    protected boolean deleting(E dataObject) {
        return true;
    }

    protected abstract IPreValidator getPreValidatorNewInstance();

    protected abstract IPreValidator2<E> getPreValidatorNewInstance2();

    protected abstract void leaveEditionMode();

    protected abstract void createEditionControl(Composite var1);

    protected abstract E initializeNewDataObject();

    protected abstract void switched();

    protected abstract void showDataObject(E var1);

    public IBaseEditor2 getParentEditor() {
        return this.parentEditor;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public int getItemCount() {
        return this.listTableSwitch.getItemCount();
    }

    public ListTable<E> getListTableSwitch() {
        return this.listTableSwitch;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setStatusList(IEditableDataObjectList<E> statusList) {
        if (statusList == null) {
            throw new NullPointerException("statusList");
        }
        this.listTableSwitch.setStatusList(statusList);
    }

    @Override
    public boolean isInEdition() {
        return this.isInEdition;
    }

    protected void setInEdition(boolean isInEdition) {
        this.isInEdition = isInEdition;
        for (ISwitchTableListener listener : this.listeners) {
            listener.editionStateChanged();
        }
    }

    public void addRowListener(ListTable.IRowCountListener listener) {
        this.listTableSwitch.addRowListener(listener);
    }

    public void addToolTipListener(ListTable.IToolTipChanged listener) {
        this.listTableSwitch.addToolTipListener(listener);
    }

    @Override
    public void cancel() {
        this.listTableSwitch.cancel();
    }

    @Override
    public boolean save() {
        return this.listTableSwitch.save();
    }

    public IEditableDataObjectList<E> getStatusList() {
        return this.listTableSwitch.statusList;
    }

    public void addColumn(int width) {
        this.listTableSwitch.addColumn(width);
    }

    public void addColumn(int width, String title) {
        this.listTableSwitch.addColumn(width, title);
    }

    public void refresh() {
        this.listTableSwitch.refresh();
    }

    public void select(int index) {
        this.listTableSwitch.select(index);
    }

    public boolean delete() {
        return this.listTableSwitch.delete();
    }

    public ProviderAR<E, String[]> getLabelProvider() {
        return this.listTableSwitch.getLabelProvider();
    }

    public void setLabelProvider(ProviderAR<E, String[]> labelProvider) {
        this.listTableSwitch.setLabelProvider(labelProvider);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.listTableSwitch.setEnabled(enabled);
    }

    public void setBtnDeleteEnabled(boolean enabled) {
        this.listTableSwitch.setBtnDeleteEnabled(enabled);
    }

    public void addListSelectionChangeListener(SelectionListener listener) {
        this.listTableSwitch.addListSelectionChangeListener(listener);
    }

    public E getFirstSelectedItem() {
        return this.listTableSwitch.getFirstSelectedItem();
    }

    public PredicateA<E> getDisplayPredicate() {
        return this.listTableSwitch.getDisplayPredicate();
    }

    public void setDisplayPredicate(PredicateA<E> displayPredicate) {
        this.listTableSwitch.setDisplayPredicate(displayPredicate);
    }

    @Override
    public void addListener(ISwitchTableListener listener) {
        this.listeners.add(listener);
    }
}

