/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import ca.infodata.ofys.ui.browser.ClasspathResourceHandler;
import ca.infodata.ofys.ui.browser.InMemoryResource;
import ca.infodata.ofys.ui.browser.resource.BadResource;
import ca.infodata.ofys.ui.library.file.FileUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.osgi.framework.BundleContext;

public class ClasspathDevModeResourceHandler
extends ClasspathResourceHandler {
    private static final Logger logger = Logger.getLogger(ClasspathDevModeResourceHandler.class.getName());
    private PathMap pathMap;
    String toolsBase = System.getProperty("toolsBaseDir");
    String dashboardBase = System.getProperty("dashboardBaseDir");

    public static boolean shouldTakeOverTheApplication() {
        String toolsBaseDir = System.getProperty("toolsBaseDir");
        String dashboardBaseDir = System.getProperty("dashboardBaseDir");
        return StringUtil.isNotBlank((String)toolsBaseDir) && StringUtil.isNotBlank((String)dashboardBaseDir);
    }

    @Override
    public void addClassLoader(String pattern, BundleContext context) {
        if (context == null) {
            throw new NullPointerException("classLoader");
        }
        if (pattern == null || pattern.length() == 0 || !pattern.startsWith("/")) {
            throw new IllegalArgumentException("pattern");
        }
        if (this.pathMap == null) {
            this.pathMap = new PathMap(true);
        }
        if (pattern.equals("/tools/*")) {
            this.pathMap.put(pattern, (Object)new File(System.getProperty("toolsBaseDir")));
        } else if (pattern.equals("/dashboard/resources/*")) {
            this.pathMap.put(pattern, (Object)new File(System.getProperty("dashboardBaseDir")));
        } else {
            throw new IllegalArgumentException("unsuppored pattern " + pattern);
        }
    }

    @Override
    public void removeClassLoader(String pattern) {
        if (pattern == null || pattern.length() == 0 || !pattern.startsWith("/")) {
            throw new IllegalArgumentException("pattern");
        }
        if (this.pathMap != null && this.pathMap.containsKey((Object)pattern)) {
            this.pathMap.remove((Object)pattern);
        }
    }

    @Override
    public Resource getResource(String path) throws MalformedURLException {
        if (this.pathMap != null) {
            PathMap.MappedEntry match = this.pathMap.getMatch(path);
            if (match != null) {
                File baseDir = (File)match.getValue();
                if (path.contains("tools")) {
                    baseDir = new File(this.toolsBase);
                } else if (path.contains("dashboard")) {
                    baseDir = new File(this.dashboardBase);
                }
                File file = new File(baseDir, path);
                if (file.exists()) {
                    return ClasspathDevModeResourceHandler.newResource(file);
                }
                System.out.println("no resource found for path " + file);
            } else if (path.contains("login.html")) {
                File file = new File(new File(this.dashboardBase), "/dashboard" + path);
                if (file.exists()) {
                    return ClasspathDevModeResourceHandler.newResource(file);
                }
                System.out.println("no resource found for path " + file);
            }
        }
        return null;
    }

    protected static Resource newResource(File file) throws MalformedURLException {
        try {
            byte[] data = FileUtil.readFileAsByteArray((File)file);
            return new InMemoryResource(file.getName(), data);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading resource with file " + file, e);
            return new BadResource(file.toURI().toURL(), e.toString());
        }
    }
}

