/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import ca.infodata.ofys.data.dataaccess.service.apss.ApssAccessorClient;
import ca.infodata.ofys.data.dataaccess.service.apss.ProxyAccessorClient;
import ca.infodata.ofys.ui.browser.ApssEntityInject;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.util1.IntegerRange;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.MutablePair;
import ca.infodata.util1.Pair;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.util.EntityUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.MultiPartInputStreamParser;

public class ApssResourceHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(ApssResourceHandler.class.getName());
    private ServerConnector connector;
    private final String proxy = "apss";
    private final ProxyAccessorClient proxyAccessorClient;
    private final ApssAccessorClient apssAccessorClient;

    public ApssResourceHandler(ServerConnector connector) throws UnknownHostException {
        this.connector = connector;
        this.proxyAccessorClient = new ProxyAccessorClient();
        this.apssAccessorClient = new ApssAccessorClient();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getServerPort() != this.connector.getPort()) {
            return;
        }
        if ("GET".equals(baseRequest.getMethod())) {
            if (target.startsWith("/Requetes/resources/JQuery/js/jquery.min.map")) {
                baseRequest.setHandled(true);
                response.setStatus(404);
            } else if (target.startsWith("/Requetes/resources")) {
                baseRequest.setHandled(true);
                String cacheKey = new JoinList("~", new Object[]{"apss", target}).toString();
                this.forwardGetToServer(cacheKey, "apss", this.getPath(target, baseRequest), response);
            } else if (target.startsWith("/Requetes/notification.html")) {
                baseRequest.setHandled(true);
                this.forwardGetToServer(null, "apss", this.getPath(target, baseRequest), response);
            } else if (target.startsWith("/Requetes/api/web/v1/succes.html")) {
                baseRequest.setHandled(true);
                this.forwardGetToServer(null, "apss", this.getPath(target, baseRequest), response);
            } else if (target.startsWith("/Requetes/api")) {
                baseRequest.setHandled(true);
                this.forwardGetToServer(null, "apss", this.getPath(target, baseRequest), response);
            } else if (target.startsWith("/Requetes")) {
                baseRequest.setHandled(true);
                this.forwardGetToServer(null, "apss", this.getPath(target, baseRequest), response);
            }
        } else if ("POST".equals(baseRequest.getMethod())) {
            if (target.startsWith("/Requetes/api/web")) {
                baseRequest.setHandled(true);
                this.submit("apss", this.getPath(target, baseRequest), request, response);
            } else if (target.equals("/Requetes/logging/error.json")) {
                baseRequest.setHandled(true);
            }
        }
    }

    private String getPath(String target, Request baseRequest) {
        String queryString = baseRequest.getQueryString();
        if (StringUtils.isNotEmpty((String)queryString)) {
            return String.valueOf(target) + "?" + queryString;
        }
        return target;
    }

    private void submit(String proxy, String path, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        CloseableHttpResponse r = null;
        try {
            try {
                ArrayList<Pair> headerList = new ArrayList<Pair>();
                Enumeration headerNames = request.getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    if ("Content-Length".equals(headerName) || "Transfer-Encoding".equals(headerName) || "Cookie".equals(headerName) || "Origin".equals(headerName) || "Accept".equals(headerName) || "Referer".equals(headerName) || "Host".equals(headerName) || "DNT".equals(headerName) || "Accept-Encoding".equals(headerName) || "Cache-Control".equals(headerName) || "Upgrade-Insecure-Requests".equals(headerName) || "Accept-Language".equals(headerName)) continue;
                    Enumeration headers = request.getHeaders(headerName);
                    while (headers.hasMoreElements()) {
                        String header = (String)headers.nextElement();
                        headerList.add(new Pair((Object)headerName, (Object)header));
                    }
                }
                Integer formDataId = this.parseIdEformDataFromQueryParams(request);
                path = path.replaceAll("&formDataId=[0-9]+", "");
                path = path.replaceAll("\\?formDataId=[0-9]+", "");
                r = this.apssAccessorClient.submit(formDataId.intValue(), path, headerList, IOUtils.toByteArray((InputStream)request.getInputStream()));
                response.setStatus(r.getStatusLine().getStatusCode());
                response.setLocale(r.getLocale());
                HttpEntity entity = r.getEntity();
                response.setContentType(entity.getContentType().getValue());
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String entityContent = EntityUtils.toString((HttpEntity)entity);
                String html = new ApssEntityInject().inject(entityContent);
                StringEntity stringEntity = new StringEntity(html, contentType);
                byte[] byteArray = EntityUtils.toByteArray((HttpEntity)stringEntity);
                response.setContentLengthLong((long)byteArray.length);
                response.getOutputStream().write(byteArray);
            }
            catch (Error e) {
                e.printStackTrace();
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (Exception e2) {
                    logger.log(Level.WARNING, "Failed to close CloseableHttpResponse", e2);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in submit", e);
                throw new ServletException((Throwable)e);
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Failed to close CloseableHttpResponse", e2);
            }
        }
    }

    private Integer parseIdEformDataFromQueryParams(HttpServletRequest request) throws ServletException {
        String value;
        Map parameterMap = request.getParameterMap();
        if (parameterMap.containsKey("formDataId") && StringUtils.isNotBlank((String)(value = ((String[])parameterMap.get("formDataId"))[0]))) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                throw new ServletException("invalid formDataId value in queryParams");
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MutablePair<Integer, HttpEntity> extractFormDataIdAndReturnNewEntity(HttpServletRequest request) throws IOException, ServletException {
        MultiPartInputStreamParser parser;
        MutablePair r;
        block3: {
            r = new MutablePair();
            ByteArrayInputStream inputStream2 = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)request.getInputStream()));
            MultipartConfigElement config = MultiPartInputStreamParser.__DEFAULT_MULTIPART_CONFIG;
            parser = new MultiPartInputStreamParser((InputStream)inputStream2, request.getContentType(), config, null);
            Part part = parser.getPart("formDataId");
            if (part == null) throw new ServletException("no formDataId input in form");
            String value = IOUtils.toString((InputStream)part.getInputStream(), (Charset)StandardCharsets.UTF_8);
            try {
                System.out.println("formDataId=<" + value + ">");
                r.first = Integer.parseInt(value);
            }
            catch (Exception exception) {
                r.first = Integer.parseInt(request.getParameter("formDataId"));
                if (r.first == null) break block3;
                throw new ServletException("invalid formDataId value");
            }
        }
        MultipartEntityBuilder message = MultipartEntityBuilder.create();
        message.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        message.setBoundary(request.getContentType().split(";")[1].split("=")[1].trim());
        message.setCharset(StandardCharsets.UTF_8);
        for (Part part : parser.getParts()) {
            if ("formDataId".equals(part.getName())) continue;
            message.addPart(part.getName(), (ContentBody)new InputStreamBody(part.getInputStream(), part.getContentType()));
        }
        r.second = message.build();
        return r;
    }

    private void forwardGetToServer(String cacheKey, String proxy, String path, HttpServletResponse response) throws ServletException, IOException {
        CachedResponse cache;
        if (cacheKey != null && (cache = (CachedResponse)LibPlugin.getDefault().getEncryptedFS().get(cacheKey)) != null) {
            this.loadFromCache(cache, response);
            return;
        }
        CloseableHttpResponse r = null;
        try {
            try {
                byte[] byteArray;
                r = this.proxyAccessorClient.get(proxy, path);
                Header[] headerArray = r.getAllHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Header header = headerArray[n2];
                    if (!header.getName().equals("Transfer-Encoding") && !header.getName().equals("Cookie")) {
                        response.addHeader(header.getName(), header.getValue());
                    }
                    ++n2;
                }
                response.setStatus(r.getStatusLine().getStatusCode());
                response.setLocale(r.getLocale());
                HttpEntity entity = r.getEntity();
                response.setContentLengthLong(entity.getContentLength());
                response.setContentType(entity.getContentType().getValue());
                if (path.startsWith("/Requetes/api/web/v1/")) {
                    ContentType contentType = ContentType.get((HttpEntity)entity);
                    String entityContent = EntityUtils.toString((HttpEntity)entity);
                    String html = new ApssEntityInject().inject(entityContent);
                    StringEntity stringEntity = new StringEntity(html, contentType);
                    byteArray = EntityUtils.toByteArray((HttpEntity)stringEntity);
                    response.setContentLengthLong((long)byteArray.length);
                    response.getOutputStream().write(byteArray);
                } else {
                    byteArray = EntityUtils.toByteArray((HttpEntity)entity);
                    response.getOutputStream().write(byteArray);
                }
                if (new IntegerRange(Integer.valueOf(200), Integer.valueOf(300), RangeNotation.LEFT_CLOSED).contains((Comparable)Integer.valueOf(r.getStatusLine().getStatusCode())) && cacheKey != null) {
                    CachedResponse cache2 = new CachedResponse();
                    cache2.contentLength = entity.getContentLength();
                    cache2.entity = byteArray;
                    cache2.locale = r.getLocale();
                    cache2.statusCode = r.getStatusLine().getStatusCode();
                    Header[] headerArray2 = r.getAllHeaders();
                    int n3 = headerArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Header header = headerArray2[n4];
                        if (!header.getName().equals("Transfer-Encoding")) {
                            cache2.headers.add((Pair<String, String>)new Pair((Object)header.getName(), (Object)header.getValue()));
                        }
                        ++n4;
                    }
                    LibPlugin.getDefault().getEncryptedFS().put(cacheKey, (Object)cache2);
                }
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Failed to close CloseableHttpResponse", e2);
            }
        }
    }

    private void loadFromCache(CachedResponse cache, HttpServletResponse response) throws IOException {
        for (Pair<String, String> header : cache.headers) {
            response.addHeader((String)header.first, (String)header.second);
        }
        response.setStatus(cache.statusCode);
        response.setLocale(cache.locale);
        response.setContentLengthLong(cache.contentLength);
        response.getOutputStream().write(cache.entity);
    }

    static class CachedResponse
    implements Serializable {
        private static final long serialVersionUID = 1L;
        ArrayList<Pair<String, String>> headers = new ArrayList();
        int statusCode;
        Locale locale;
        long contentLength;
        byte[] entity;

        CachedResponse() {
        }
    }
}

