/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.search;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.appointment.search.AbstractCriteriaControl;
import ca.infodata.ofys.ui.appointment.search.ComplexSearchController;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.NumberMask;
import ca.infodata.ofys.ui.controls.SimpleNumberText;
import ca.infodata.ofys.ui.controls.TimeText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DateCriteriaControl
extends AbstractCriteriaControl {
    private SimpleNumberText txtInX;
    private MyButton btnInXDay;
    private MyButton btnInXMonth;
    private MyButton btnInXWeek;
    private SimpleNumberText txtMoreOrLess;
    private MyButton btnMoreOrLessDay;
    private MyButton btnMoreOrLessMonth;
    private MyButton btnMoreOrLessWeek;
    private DateText txtFromDate;
    private DateText txtToDate;
    private TimeText txtFromDateAfterHour;
    private boolean doit = true;

    public DateCriteriaControl(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, Messages.getString((String)"DATES", (String[])new String[0]), toolkit);
    }

    public void propertyChanged(int propertyId) {
        if (propertyId == 4 || propertyId == 11) {
            this.refreshPopup();
        }
    }

    @Override
    protected void refreshPopup() {
        if (this.getPopup() == null || this.getPopup().isDisposed()) {
            return;
        }
        ComplexSearchController controller = this.getController();
        if (controller != null) {
            if (controller.getInXDays() != null) {
                this.txtInX.setNumberKeepSelection(controller.getInXDays());
            } else if (controller.getInXMonths() != null) {
                this.txtInX.setNumberKeepSelection(controller.getInXMonths());
            } else if (controller.getInXWeeks() != null) {
                this.txtInX.setNumberKeepSelection(controller.getInXWeeks());
            } else {
                this.txtInX.setNumber(null);
            }
            this.btnInXDay.setSelection(controller.getInXDays() != null);
            this.btnInXMonth.setSelection(controller.getInXMonths() != null);
            this.btnInXWeek.setSelection(controller.getInXWeeks() != null);
            if (controller.getMoreOrLessXDays() != null) {
                this.txtMoreOrLess.setNumberKeepSelection(controller.getMoreOrLessXDays());
            } else if (controller.getMoreOrLessXMonths() != null) {
                this.txtMoreOrLess.setNumberKeepSelection(controller.getMoreOrLessXMonths());
            } else if (controller.getMoreOrLessXWeeks() != null) {
                this.txtMoreOrLess.setNumberKeepSelection(controller.getMoreOrLessXWeeks());
            } else {
                this.txtMoreOrLess.setNumber(null);
            }
            this.btnMoreOrLessDay.setSelection(controller.getMoreOrLessXDays() != null);
            this.btnMoreOrLessMonth.setSelection(controller.getMoreOrLessXMonths() != null);
            this.btnMoreOrLessWeek.setSelection(controller.getMoreOrLessXWeeks() != null);
            this.doit = false;
            this.txtToDate.setDate((IPartialDate)controller.getToDate());
            this.txtFromDate.setDate((IPartialDate)controller.getFromDate());
            this.txtFromDateAfterHour.setTime(controller.getFromDateAfterHour());
            this.doit = true;
        }
    }

    @Override
    protected Shell createPopupControlOverride(Shell parent, FormToolkit toolkit) {
        Shell shell = new Shell(parent, 2048);
        toolkit.adapt((Composite)shell);
        MyLabel lblInX = new MyLabel((Composite)shell, Messages.getString((String)"DANS", (String[])new String[0]), 0, toolkit);
        this.txtInX = new SimpleNumberText((Composite)shell, 0, toolkit);
        NumberMask mask = new NumberMask();
        mask.setAllowNegative(false);
        this.txtInX.setMask((MyMask)mask);
        this.btnInXDay = new MyButton((Composite)shell, 2);
        this.btnInXDay.setText(Messages.getString((String)"JOURS", (String[])new String[0]).toLowerCase());
        this.btnInXMonth = new MyButton((Composite)shell, 2);
        this.btnInXMonth.setText(Messages.getString((String)"MOIS", (String[])new String[0]).toLowerCase());
        this.btnInXWeek = new MyButton((Composite)shell, 2);
        this.btnInXWeek.setText(Messages.getString((String)"SEMAINES", (String[])new String[0]).toLowerCase());
        MyLabel lblFrom = new MyLabel((Composite)shell, Messages.getString((String)"OU_APRES", (String[])new String[0]), 0, toolkit);
        this.txtFromDate = new DateText((Composite)shell, 0, toolkit);
        MyLabel lblFromDateAfterHour = new MyLabel((Composite)shell, Messages.getString((String)"HEURE", (String[])new String[0]), 0, toolkit);
        this.txtFromDateAfterHour = new TimeText((Composite)shell, 0, toolkit);
        MyLabel lblTo = new MyLabel((Composite)shell, Messages.getString((String)"AVANT_LE", (String[])new String[0]), 0, toolkit);
        this.txtToDate = new DateText((Composite)shell, 0, toolkit);
        Label sep = new Label((Composite)shell, 258);
        MyLabel lblMoreOrLess = new MyLabel((Composite)shell, Messages.getString((String)"PLUS_OU_MOINS", (String[])new String[0]), 0, toolkit);
        this.txtMoreOrLess = new SimpleNumberText((Composite)shell, 0, toolkit);
        this.txtMoreOrLess.setToolTipText(Messages.getString((String)"PLUS_OU_MOINS_TT", (String[])new String[0]));
        this.txtMoreOrLess.setMask((MyMask)mask);
        this.btnMoreOrLessDay = new MyButton((Composite)shell, 2);
        this.btnMoreOrLessDay.setText(Messages.getString((String)"JOURS", (String[])new String[0]).toLowerCase());
        this.btnMoreOrLessMonth = new MyButton((Composite)shell, 2);
        this.btnMoreOrLessMonth.setText(Messages.getString((String)"MOIS", (String[])new String[0]).toLowerCase());
        this.btnMoreOrLessWeek = new MyButton((Composite)shell, 2);
        this.btnMoreOrLessWeek.setText(Messages.getString((String)"SEMAINES", (String[])new String[0]).toLowerCase());
        this.btnInXDay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateCriteriaControl.this.btnInXMonth.setSelection(false);
                DateCriteriaControl.this.btnInXWeek.setSelection(false);
                Integer number = DateCriteriaControl.this.txtInX.getNumber();
                if (DateCriteriaControl.this.getController() != null && number != null) {
                    DateCriteriaControl.this.getController().setInXDays(number);
                }
            }
        });
        this.btnInXMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateCriteriaControl.this.btnInXDay.setSelection(false);
                DateCriteriaControl.this.btnInXWeek.setSelection(false);
                Integer number = DateCriteriaControl.this.txtInX.getNumber();
                if (DateCriteriaControl.this.getController() != null && number != null) {
                    DateCriteriaControl.this.getController().setInXMonths(number);
                }
            }
        });
        this.btnInXWeek.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateCriteriaControl.this.btnInXMonth.setSelection(false);
                DateCriteriaControl.this.btnInXDay.setSelection(false);
                Integer number = DateCriteriaControl.this.txtInX.getNumber();
                if (DateCriteriaControl.this.getController() != null && number != null) {
                    DateCriteriaControl.this.getController().setInXWeeks(number);
                }
            }
        });
        this.btnMoreOrLessDay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateCriteriaControl.this.btnMoreOrLessMonth.setSelection(false);
                DateCriteriaControl.this.btnMoreOrLessWeek.setSelection(false);
                Integer number = DateCriteriaControl.this.txtMoreOrLess.getNumber();
                if (DateCriteriaControl.this.getController() != null && number != null) {
                    DateCriteriaControl.this.getController().setMoreOrLessXDays(number);
                }
            }
        });
        this.btnMoreOrLessMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateCriteriaControl.this.btnMoreOrLessMonth.setSelection(false);
                DateCriteriaControl.this.btnMoreOrLessDay.setSelection(false);
                Integer number = DateCriteriaControl.this.txtMoreOrLess.getNumber();
                if (DateCriteriaControl.this.getController() != null && number != null) {
                    DateCriteriaControl.this.getController().setMoreOrLessXMonths(number);
                }
            }
        });
        this.btnMoreOrLessWeek.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateCriteriaControl.this.btnMoreOrLessDay.setSelection(false);
                DateCriteriaControl.this.btnMoreOrLessWeek.setSelection(false);
                Integer number = DateCriteriaControl.this.txtMoreOrLess.getNumber();
                if (DateCriteriaControl.this.getController() != null && number != null) {
                    DateCriteriaControl.this.getController().setMoreOrLessXWeeks(number);
                }
            }
        });
        this.txtFromDate.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                if (DateCriteriaControl.this.getController() != null && DateCriteriaControl.this.doit) {
                    DateCriteriaControl.this.doit = false;
                    DateCriteriaControl.this.getController().setFromDate(date);
                    DateCriteriaControl.this.doit = true;
                }
            }
        });
        this.txtToDate.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                if (DateCriteriaControl.this.getController() != null && DateCriteriaControl.this.doit) {
                    DateCriteriaControl.this.doit = false;
                    DateCriteriaControl.this.getController().setToDate(date);
                    DateCriteriaControl.this.doit = true;
                }
            }
        });
        this.txtInX.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComplexSearchController controller = DateCriteriaControl.this.getController();
                if (controller != null && DateCriteriaControl.this.doit) {
                    DateCriteriaControl.this.doit = false;
                    Integer number = DateCriteriaControl.this.txtInX.getNumber();
                    if (controller.getInXDays() != null) {
                        controller.setInXDays(number);
                    } else if (controller.getInXWeeks() != null) {
                        controller.setInXWeeks(number);
                    } else if (controller.getInXMonths() != null) {
                        controller.setInXMonths(number);
                    }
                    DateCriteriaControl.this.doit = true;
                }
            }
        });
        this.txtMoreOrLess.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComplexSearchController controller = DateCriteriaControl.this.getController();
                if (controller != null && DateCriteriaControl.this.doit) {
                    DateCriteriaControl.this.doit = false;
                    Integer number = DateCriteriaControl.this.txtMoreOrLess.getNumber();
                    if (controller.getMoreOrLessXDays() != null) {
                        controller.setMoreOrLessXDays(number);
                    } else if (controller.getMoreOrLessXWeeks() != null) {
                        controller.setMoreOrLessXWeeks(number);
                    } else if (controller.getMoreOrLessXMonths() != null) {
                        controller.setMoreOrLessXMonths(number);
                    }
                    DateCriteriaControl.this.doit = true;
                }
            }
        });
        this.txtFromDateAfterHour.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!DateCriteriaControl.this.doit) {
                    return;
                }
                Integer number = DateCriteriaControl.this.txtFromDateAfterHour.getTime();
                if (DateCriteriaControl.this.getController() != null) {
                    DateCriteriaControl.this.getController().setFromDateAfterHour(number);
                }
            }
        });
        int btnWidth = 90;
        int txtWidth = 25;
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        shell.setLayout((Layout)layout);
        int labelOffset = lblInX.computeSize((int)-1, (int)-1).x;
        labelOffset = Math.max(labelOffset, lblMoreOrLess.computeSize((int)-1, (int)-1).x);
        labelOffset = Math.max(labelOffset, lblFrom.computeSize((int)-1, (int)-1).x);
        labelOffset = Math.max(labelOffset, lblTo.computeSize((int)-1, (int)-1).x);
        labelOffset += 5;
        int top = 10;
        FormData data = new FormData();
        data.top = new FormAttachment(top);
        data.left = new FormAttachment(0);
        lblInX.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(top);
        data.left = new FormAttachment(0, labelOffset);
        data.width = txtWidth;
        this.txtInX.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(top);
        data.left = new FormAttachment(this.txtInX.getControl());
        data.bottom = new FormAttachment(this.txtInX.getControl(), 0, 1024);
        data.width = btnWidth;
        this.btnInXDay.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(top);
        data.left = new FormAttachment(this.btnInXDay.getControl());
        data.bottom = new FormAttachment(this.txtInX.getControl(), 0, 1024);
        data.width = btnWidth;
        this.btnInXWeek.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(top);
        data.left = new FormAttachment(this.btnInXWeek.getControl());
        data.bottom = new FormAttachment(this.txtInX.getControl(), 0, 1024);
        data.width = btnWidth;
        this.btnInXMonth.setLayoutData((Object)data);
        Control topControl = this.txtInX.getControl();
        data = new FormData();
        data.top = new FormAttachment(topControl);
        data.left = new FormAttachment(0);
        lblFrom.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(topControl);
        data.left = new FormAttachment(0, labelOffset);
        data.width = Math.max(80, UI.stringExtent((Control)this.txtFromDate.getControl(), (String)"2222-22-22 ").x);
        this.txtFromDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtFromDate.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(this.txtFromDate.getControl(), 5);
        lblFromDateAfterHour.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(topControl);
        data.left = new FormAttachment(lblFromDateAfterHour.getControl(), 5);
        this.txtFromDateAfterHour.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtFromDate.getControl());
        data.left = new FormAttachment(0);
        lblTo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtFromDate.getControl());
        data.left = new FormAttachment(0, labelOffset);
        data.width = Math.max(80, UI.stringExtent((Control)this.txtToDate.getControl(), (String)"2222-22-22 ").x);
        this.txtToDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtToDate.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        sep.setLayoutData((Object)data);
        topControl = sep;
        data = new FormData();
        data.top = new FormAttachment(topControl);
        data.left = new FormAttachment(0);
        lblMoreOrLess.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(topControl);
        data.left = new FormAttachment(0, labelOffset);
        data.width = txtWidth;
        this.txtMoreOrLess.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(topControl);
        data.left = new FormAttachment(this.txtMoreOrLess.getControl());
        data.bottom = new FormAttachment(this.txtMoreOrLess.getControl(), 0, 1024);
        data.width = btnWidth;
        this.btnMoreOrLessDay.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(topControl);
        data.left = new FormAttachment(this.btnMoreOrLessDay.getControl());
        data.bottom = new FormAttachment(this.txtMoreOrLess.getControl(), 0, 1024);
        data.width = btnWidth;
        this.btnMoreOrLessWeek.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(topControl);
        data.left = new FormAttachment(this.btnMoreOrLessWeek.getControl());
        data.bottom = new FormAttachment(this.txtMoreOrLess.getControl(), 0, 1024);
        data.width = btnWidth;
        this.btnMoreOrLessMonth.setLayoutData((Object)data);
        shell.pack();
        return shell;
    }

    @Override
    protected void reset() {
        ComplexSearchController controller = this.getController();
        if (controller != null) {
            controller.reset();
        }
        this.refreshPopup();
    }

    @Override
    protected String computeLabel() {
        Integer moreOrLessXWeeks;
        Integer moreOrLessXMonths;
        Integer moreOrLessXDays;
        Integer inXWeeks;
        Integer inXMonths;
        Integer inXDays;
        ComplexSearchController controller = this.getController();
        if (controller == null) {
            return null;
        }
        String text = "";
        LocalDate fromDate = controller.getFromDate();
        LocalDate toDate = controller.getToDate();
        if (fromDate != null) {
            text = String.valueOf(text) + " " + Messages.getString((String)"DU", (String[])new String[0]).toLowerCase() + " " + LocalDateFormat.format((LocalDate)fromDate, (String)FormatDateProvider.getFormatDate().toString());
            Integer after = controller.getFromDateAfterHour();
            if (after != null) {
                text = String.valueOf(text) + " " + DateUtil.convertTimeToString((Integer)after, (Character)Character.valueOf('h'));
            }
        }
        if (toDate != null) {
            text = String.valueOf(text) + " " + Messages.getString((String)"AU", (String[])new String[0]).toLowerCase() + " " + LocalDateFormat.format((LocalDate)toDate, (String)FormatDateProvider.getFormatDate().toString());
        }
        if ((inXDays = controller.getInXDays()) != null) {
            text = String.valueOf(text) + " " + Messages.getString((String)"DANS", (String[])new String[0]).toLowerCase() + " " + inXDays + " " + Messages.getString((String)"JOURS", (String[])new String[0]).toLowerCase();
        }
        if ((inXMonths = controller.getInXMonths()) != null) {
            text = String.valueOf(text) + " " + Messages.getString((String)"DANS", (String[])new String[0]).toLowerCase() + " " + inXMonths + " " + Messages.getString((String)"MOIS", (String[])new String[0]).toLowerCase();
        }
        if ((inXWeeks = controller.getInXWeeks()) != null) {
            text = String.valueOf(text) + " " + Messages.getString((String)"DANS", (String[])new String[0]).toLowerCase() + " " + inXWeeks + " " + Messages.getString((String)"SEMAINES", (String[])new String[0]).toLowerCase();
        }
        if ((moreOrLessXDays = controller.getMoreOrLessXDays()) != null) {
            text = String.valueOf(text) + " +/- " + moreOrLessXDays + " " + Messages.getString((String)"JOURS", (String[])new String[0]).toLowerCase();
        }
        if ((moreOrLessXMonths = controller.getMoreOrLessXMonths()) != null) {
            text = String.valueOf(text) + " +/- " + moreOrLessXMonths + " " + Messages.getString((String)"MOIS", (String[])new String[0]).toLowerCase();
        }
        if ((moreOrLessXWeeks = controller.getMoreOrLessXWeeks()) != null) {
            text = String.valueOf(text) + " +/- " + moreOrLessXWeeks + " " + Messages.getString((String)"SEMAINES", (String[])new String[0]).toLowerCase();
        }
        return text;
    }
}

