/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.recall;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecall;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientRecallSearchCriteria;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.editor.recall.BasePatientRecallEditor;
import ca.infodata.ofys.ui.appointment.editor.recall.PatientRecallEditor2;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class PatientRecallEditor
extends BasePatientRecallEditor {
    private static final Logger logger = Logger.getLogger(PatientRecallEditor.class.getName());

    public PatientRecallEditor(PatientMultiEditor parentEditor) {
        super(parentEditor);
    }

    public void load() {
        XPatient patient = this.getPatient();
        if (patient == null) {
            this.showDataObjectOverride();
            return;
        }
        Integer idPatient = patient.getId();
        if (idPatient != null) {
            XSession session;
            block24: {
                block23: {
                    session = Application.get().getGlobalInstances().getSession();
                    this.idPatientBeforeCall = idPatient;
                    this.recallComp.showLoadingComposite();
                    try {
                        XPatientRecallSearchCriteria criteria = new XPatientRecallSearchCriteria();
                        criteria.patientId = idPatient;
                        criteria.status = EnumSet.allOf(XStatus.class);
                        AppointmentAccessorClient.getInstance().findPatientRecall(session, (ICallback)this.recallComp.getCallback(), criteria);
                    }
                    catch (CannotConnectToServerException cannotConnectToServerException) {
                        MessageUtil.cannotConnectToServerExceptionMsg();
                        this.recallComp.getCallback().kill();
                        break block23;
                    }
                    catch (Exception e) {
                        try {
                            logger.log(Level.SEVERE, "Failed to findPatientRecallsByPatient idPatient=" + idPatient, e);
                            break block23;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.recallComp.getCallback().kill();
                        }
                    }
                    this.recallComp.getCallback().kill();
                }
                this.futurAppointmentComp.showLoadingComposite();
                try {
                    AppointmentAccessorClient.getInstance().findFutureAppointmentsByPatient(((Object)((Object)this)).hashCode(), session, (ICallback)this.futurAppointmentComp.getCallback(), idPatient.intValue());
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    this.futurAppointmentComp.getCallback().kill();
                    break block24;
                }
                catch (Exception e) {
                    try {
                        logger.log(Level.SEVERE, "Failed to findPatientRecallsByPatient idPatient=" + idPatient, e);
                        break block24;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.futurAppointmentComp.getCallback().kill();
                    }
                }
                this.futurAppointmentComp.getCallback().kill();
            }
            this.pastAppointmentComp.showLoadingComposite();
            try {
                try {
                    AppointmentAccessorClient.getInstance().findPastAppointmentsByPatient(((Object)((Object)this)).hashCode(), session, (ICallback)this.pastAppointmentComp.getCallback(), idPatient.intValue());
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    this.pastAppointmentComp.getCallback().kill();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to findPatientRecallsByPatient idPatient=" + idPatient, e);
                    this.pastAppointmentComp.getCallback().kill();
                }
            }
            finally {
                this.pastAppointmentComp.getCallback().kill();
            }
        }
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/clock-icon16.png");
    }

    public void showDataObjectOverride() {
        XPatient patient = this.getPatient();
        this.linkNewRecall.setEnabled(patient != null && patient.getId() != null);
        this.showPatientRecalls();
        this.showPatientPastAppointments();
        this.showPatientFuturAppointments();
    }

    @Override
    protected void showPatientRecalls() {
        if (this.tblRecalls != null && !this.tblRecalls.isDisposed()) {
            boolean showPatientOther = true;
            XPatient patient = this.getPatient();
            if (patient != null) {
                showPatientOther = patient.hasActiveConsentement(Application.get().getGlobalInstances().getSession().getUser().getId(), XConsentement.RIGHT_PATIENT_OTHER);
            }
            List<Object> list = showPatientOther ? this.getPatientRecallsList() : Collections.emptyList();
            this.tblRecalls.setVisible(showPatientOther);
            this.tblRecalls.setItems(list);
        }
    }

    private List<XPatientRecall> getPatientRecallsList() {
        XPatient patient = this.getPatient();
        ArrayList<XPatientRecall> list = new ArrayList<XPatientRecall>();
        if (patient != null && this.lstRecalls != null) {
            for (XPatientRecall e : this.lstRecalls) {
                if (e == null) continue;
                if (this.showCanceledAndGivenPatientRecall) {
                    list.add(e);
                    continue;
                }
                if (e.getStatus() == XStatus.APPOINTMENT_GIVEN || e.getStatus() == XStatus.CANCELED) continue;
                list.add(e);
            }
        }
        return list;
    }

    @Override
    protected void showPatientPastAppointments() {
        if (this.tblPastAppointments != null && !this.tblPastAppointments.isDisposed()) {
            boolean showPatientOther = true;
            XPatient patient = this.getPatient();
            if (patient != null) {
                showPatientOther = patient.hasActiveConsentement(Application.get().getGlobalInstances().getSession().getUser().getId(), XConsentement.RIGHT_PATIENT_OTHER);
            }
            List<Object> list = showPatientOther ? this.getPatientPastAppointmentList() : Collections.emptyList();
            this.tblPastAppointments.setVisible(showPatientOther);
            this.tblPastAppointments.setItems(list);
        }
    }

    private List<IAppointment> getPatientPastAppointmentList() {
        XPatient patient = this.getPatient();
        ArrayList<IAppointment> list = new ArrayList<IAppointment>();
        if (patient != null && this.lstPastAppointments != null) {
            for (IAppointment e : this.lstPastAppointments) {
                if (e == null) continue;
                if (this.showDeletedPastAppointment) {
                    list.add(e);
                    continue;
                }
                if (Boolean.TRUE.equals(e.getIsDeleted())) continue;
                list.add(e);
            }
        }
        return list;
    }

    @Override
    protected void showPatientFuturAppointments() {
        if (this.tblFutureAppointments != null && !this.tblFutureAppointments.isDisposed()) {
            boolean showPatientOther = true;
            XPatient patient = this.getPatient();
            if (patient != null) {
                showPatientOther = patient.hasActiveConsentement(Application.get().getGlobalInstances().getSession().getUser().getId(), XConsentement.RIGHT_PATIENT_OTHER);
            }
            List<Object> list = showPatientOther ? this.getPatientFuturAppointmentList() : Collections.emptyList();
            this.tblFutureAppointments.setVisible(showPatientOther);
            this.tblFutureAppointments.setItems(list);
        }
    }

    private List<IAppointment> getPatientFuturAppointmentList() {
        XPatient patient = this.getPatient();
        ArrayList<IAppointment> list = new ArrayList<IAppointment>();
        if (patient != null && this.lstFutureAppointments != null) {
            for (IAppointment e : this.lstFutureAppointments) {
                if (e == null) continue;
                if (this.showDeletedFuturAppointment) {
                    list.add(e);
                    continue;
                }
                if (Boolean.TRUE.equals(e.getIsDeleted())) continue;
                list.add(e);
            }
        }
        return list;
    }

    @Override
    protected void appointmentDoubleClicked(IAppointment appointment) {
        if (appointment != null) {
            AppointmentPlugin.getDefault().openAppointmentEditor("PatientRecallEditor", appointment);
        }
    }

    @Override
    protected void recallDoubleClicked(XPatientRecall recall) {
        if (recall != null) {
            BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)recall.clone()), (String)PatientRecallEditor2.class.getName());
        }
    }
}

