/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.model2;

import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.ui.appointment.editor.model2.IXAppointmentDateMapListener;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.collections4.map.MultiValueMap;
import org.mb.listeners.GenListenerManager;

public class XAppointmentDateMap {
    private static final Logger logger = Logger.getLogger(XAppointmentDateMap.class.getName());
    private final GenListenerManager<IXAppointmentDateMapListener<XAppointmentDate>> manager;
    private final MultiValueMap mapAppointmentDateByDate;
    private final MultiKeyMap mapAppointmentDateByDateProfessional;
    private final MultiValueMap mapAppointmentDateByProfessional;
    private final IXAppointmentDateMapListener<XAppointmentDate> proxy;
    private final PredicateA predicate;

    public XAppointmentDateMap(PredicateA<Object> predicate) {
        this.predicate = predicate;
        this.mapAppointmentDateByDate = new MultiValueMap();
        this.mapAppointmentDateByProfessional = new MultiValueMap();
        this.mapAppointmentDateByDateProfessional = new MultiKeyMap();
        this.manager = new GenListenerManager(IXAppointmentDateMapListener.class);
        this.proxy = (IXAppointmentDateMapListener)this.manager.getProxy();
    }

    private boolean isValid(Object object) {
        return this.predicate == null || this.predicate.evaluate(object);
    }

    private boolean internal_add(XAppointmentDate date) {
        boolean added;
        boolean bl = added = this.isValid(date) && !this.contains(date);
        if (added) {
            this.mapAppointmentDateByDate.put((Object)date.getDate(), (Object)date);
            this.mapAppointmentDateByProfessional.put((Object)date.getProfessional(), (Object)date);
            this.mapAppointmentDateByDateProfessional.put((Object)date.getDate(), (Object)date.getProfessional(), (Object)date);
        }
        return added;
    }

    private boolean internal_remove(XAppointmentDate date) {
        boolean removed;
        XAppointmentDate xdate = this.get(date.getDate(), date.getProfessional());
        boolean bl = removed = xdate != null;
        if (removed) {
            this.mapAppointmentDateByDate.remove((Object)date.getDate(), (Object)date);
            this.mapAppointmentDateByProfessional.remove((Object)date.getProfessional(), (Object)date);
            this.mapAppointmentDateByDateProfessional.remove((Object)new MultiKey((Object)date.getDate(), (Object)date.getProfessional()));
        }
        return removed;
    }

    public boolean add(XAppointmentDate date) {
        boolean added = this.internal_add(date);
        if (added) {
            this.proxy.add(date);
        }
        logger.exiting("XAppointmentDateMap", "add" + date, added);
        return added;
    }

    public boolean addAll(Collection<? extends XAppointmentDate> lstDate) {
        boolean added = false;
        for (XAppointmentDate xAppointmentDate : lstDate) {
            boolean bl = added = this.internal_add(xAppointmentDate) || added;
        }
        if (added) {
            this.proxy.addAll(lstDate);
        }
        return added;
    }

    public void clear() {
        this.mapAppointmentDateByDate.clear();
        this.mapAppointmentDateByProfessional.clear();
        this.mapAppointmentDateByDateProfessional.clear();
        this.proxy.clear();
    }

    public boolean contains(XAppointmentDate date) {
        return this.get(date.getDate(), date.getProfessional()) != null;
    }

    public Collection<XAppointmentDate> get(LocalDate date) {
        return (Collection)this.mapAppointmentDateByDate.get((Object)date);
    }

    public XAppointmentDate get(LocalDate date, Integer professional) {
        return (XAppointmentDate)this.mapAppointmentDateByDateProfessional.get((Object)new MultiKey((Object)date, (Object)professional));
    }

    public Collection<XAppointmentDate> get(Integer professional) {
        return (Collection)this.mapAppointmentDateByProfessional.get((Object)professional);
    }

    public boolean remove(XAppointmentDate date) {
        boolean removed = this.internal_remove(date);
        if (removed) {
            this.proxy.remove(date);
        }
        logger.exiting("XAppointmentDateMap", "remove " + date, removed);
        return removed;
    }

    public boolean removeAll(Collection<? extends XAppointmentDate> lstDate) {
        boolean removed = false;
        for (XAppointmentDate xAppointmentDate : lstDate) {
            boolean bl = removed = this.internal_remove(xAppointmentDate) || removed;
        }
        if (removed) {
            this.proxy.removeAll(lstDate);
        }
        return removed;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(1000);
        b.append("XAppointmentDateMap");
        MapIterator mapIterator = this.mapAppointmentDateByDateProfessional.mapIterator();
        while (mapIterator.hasNext()) {
            b.append("\n");
            b.append(mapIterator.next().toString());
        }
        return b.toString();
    }

    public void addListener(IXAppointmentDateMapListener<XAppointmentDate> listener) {
        this.manager.addListener(listener);
    }

    public void removeListener(IXAppointmentDateMapListener<XAppointmentDate> listener) {
        this.manager.removeListener(listener);
    }

    public Collection<? extends XAppointmentDate> values() {
        return new ArrayList(this.mapAppointmentDateByDateProfessional.values());
    }

    public int size() {
        return this.mapAppointmentDateByDateProfessional.size();
    }
}

