/*
 * Dynamic search assistant widget
 * (c) 2017 Infodata Inc.
 */

var AssistDynaText = {};
var getFirstBrowserLanguage = function () {
    var nav = window.navigator,
    browserLanguagePropertyKeys = ['language', 'browserLanguage', 'systemLanguage', 'userLanguage'],
    i,
    language;

    // support for HTML 5.1 "navigator.languages"
    if (Array.isArray(nav.languages)) {
      for (i = 0; i < nav.languages.length; i++) {
        language = nav.languages[i];
        if (language && language.length) {
          return language;
        }
      }
    }

    // support for other well known properties in browsers
    for (i = 0; i < browserLanguagePropertyKeys.length; i++) {
      language = nav[browserLanguagePropertyKeys[i]];
      if (language && language.length) {
        return language;
      }
    }

    return null;
  };

(function(){
	
	var lang = getFirstBrowserLanguage();
	var isCtrl = false;
	var listAssist = [];
	
	AssistDynaText = function AssistDynaText(options) {
		var dxA = this;
		//Default config options
		dxA.config = {};
		
		function doNothingFunction(){}
		
		var defaultConfigOptions = {
				asyncLoading: true,
				selectOnBlur: false,
				continuePropagationOnEsc: false,
				ingoreBackSpace: false,
				angular: false,
				minChar: 1,
				nextTabOnTab: false,
				nextTabOnEnter: false,
				selectOnEnter: true,
				selectOnTab: false,
				hasHeader: true,
				alwaysShowHeader: false,
				actions: [],
				hasDetails: true,
				hasResultList: true,
				listWidth: 350,
				descWidth: 300,
				maxHeight: 300,
				keepOnScreen: false,
				detailsOnLeft: false,
				displayOnBottom: false,
				updateOnKeyStroke:true,
				helpText: "'ESC' pour fermer, \u2191 et \u2193 pour déplacer, 'ENTRER' pour sélectionner.",
				helpHtml: null,
				assistId: "",
				trigger:  'res',
				debounce: 0,
				onItemSelected: function(itemSelected){},
				updateDataSourceWithValues: doNothingFunction,
				getKey: doNothingFunction,
				getDescription: doNothingFunction,
				getList: function(data){	return data;},
				getAjaxData: null,//Used for http ajax calls, relies on success and error function to resolve calls for jquery calls 
				getAsyncData: null,// Used for promises, relies on .then syntax to resolve calls $q
				onClose: function(){return true;},
				
				//Return true to stop default assistant behaviour
				//Allows action after server response. pre-selection or ordering data before display
				suggestOnDataLoaded: function(data, query){return true;},
				
				//Called after all dom elements are added, useful for clean up or ui refresh
				onListShow: function(data, query){},
				onOpen(dxA){},
				
		};
		var optionsBack= [];
		var optionsForward= [];
		
		dxA.templates = {
				'dynaAssistContainer':["",""].join(),
		};
		
		/**
		 * Initiate assist object. bootstrap the component.
		 * 
		 */
		function init(){
			initOptions(options);
			dxA.buildBase();
		}
		
		/**
		 * Set configuration options of the assist object.
		 * @param {Object} userConfig - Configuration options
		 */
		function initOptions(userConfig){
					
			dxA.baseElement = wasDeclared(userConfig.elem) ? typeof userConfig.elem === "string" ? $("#"+userConfig.elem).get(0) : userConfig.elem : 
				new Error("An input id must be declared to bind with Dynamic assist widget, no element was declared");
			
			//if the input to attach the assist object cannot be found throw and error
			if (!$(dxA.baseElement)[0]){
				Console.error("Could not find the element to attach the assist object."+" " +
						"An element id or a jquery element must be set to the elem configuration option.");
			}
			
			if(userConfig.dynaType){
				if(userConfig.dynaType == "popover"){
					dxA.parentDiv = userConfig.elem.offsetParent
				}else{
					dxA.parentDiv = userConfig.dynaType;
				}
			} 
			
			dxA.setOptions(userConfig);
			
			dxA.selectionMade = false;
			
			dxA.assistElement = null;
			dxA.search = null;
			dxA.isOpen = false;
			dxA.actionMap = new Map();
			dxA.addAction(dxA.config.actions);
					
			var attr = $(dxA.baseElement).attr('assistId');
			
			if ((typeof attr === typeof undefined || attr === false) && dxA.config.assistId) {
				$(dxA.baseElement).attr("assistId",dxA.config.assistId);
				$(dxA.baseElement).attr("autocomplete","off");
				$(dxA.baseElement)[0].dxA = dxA;
			}
		}
		
		dxA.setOptions = function(newConfigs){
			var previousOptions = $.isEmptyObject(dxA.config) ? $.extend({},defaultConfigOptions): dxA.config;
			$.extend(dxA.config, previousOptions, newConfigs);
			optionsBack.push(previousOptions);
			optionsFoward= [];
		};
		
		dxA.setPreviousOptions = function(){
			$.extend(dxA.config, previousOptions, optionsBack.pop());
		};
		dxA.setNextOptions = function(){
			optionsBack.pop();
		};
		
		/**
		 * Verify if an option entry was declared and is not undefined.
		 * @param {object} configEntry - Option entry to verify the declration
		 */
		function wasDeclared(configEntry){
			return typeof configEntry !== 'undefined';
		}
		
		
		dxA.addAction = function(actionItems){
			var key;
			if(actionItems instanceof Array){
				for(i = 0; i < actionItems.length; i++){
					if(!($.isEmptyObject(actionItems[i].key) && $.isEmptyObject(actionItems[i].callback))){
//#multiKeyMap						key = actionItems[i].altKey ? 'alt+' + actionItems[i].key : actionItems[i].key.charAt(0);
						key = actionItems[i].altKey ? 'alt' + actionItems[i].key : actionItems[i].key.charAt(0);
						dxA.actionMap.set(key, actionItems[i].callback);
					}else{
						console.log("A key and a callback is required.");
					}
				}
			}else if (angular.isDefined(actionItems)){
				if(!($.isEmptyObject(actionItems.key) && $.isEmptyObject(actionItems.callback))){
					key = actionItems.altKey ? 'alt' + actionItems.key : actionItems.key.charAt(0);
					dxA.actionMap.set(key, actionItems.callback);
				}else{
					console.log("A key and a callback is required.");
				}
			}
		};
		
		
		dxA.focusIn = function() {
//			dxA.resetSearch(); // causes zombie list elements where the list contains elements but the search.elems model is empty
			if(dxA == null)return;
			if(dxA.config.hasResultList){
				var v = dxA.config.updateDataSourceWithValues(dxA);
				if (v!==undefined && v!=null && v!='') {
					dxA.showHist = true;
					dxA.updateDataSource(v);
				} else {
					dxA.showHist = false;
				}			
			}else{
				dxA.open();
			}
		};
		
		dxA.entryLocked = false;
		
		dxA.unlockEntry = function(){
			$(dxA.baseElement).unbind( "keypress.tempLock" );
			$(dxA.baseElement).unbind( "keyup.tempLock" );
			$(dxA.baseElement).unbind( "blur.tempLock" );
			dxA.entryLocked = false;
			dxA.showHist = false;
		};
		
		dxA.lockEntry = function(){
			dxA.entryLocked = true;
			
			$(dxA.baseElement).bind("blur.tempLock", function(envent){
				dxA.unlockEntry();
			});
			$(dxA.baseElement).bind( "keyup.tempLock", function(event){
				var v = $(dxA.baseElement).val();
				//deactivate lock on 'backspace' '=' '+' 'Enter' 'tab'
				//Check to see if input is empty (means unlock on blur failed)
				if(event.keyCode == 8 || event.keyCode == 172 ||
					event.keyCode == 190 ||  event.keyCode == 187 ||
					event.keyCode == 9 || event.keyCode == 13 || v == ""){
					dxA.unlockEntry();
				}
			});
			$(dxA.baseElement).bind( "keypress.tempLock", function(event){
				var v = $(dxA.baseElement).val();
				if(event.keyCode == 8 || event.keycode == 172 ||
					event.keyCode == 190 ||  event.keyCode == 187  ){
				}else if (v == "") {
					dxA.unlockEntry();
				}else{
					event.preventDefault();
					return;
				}
			} );
		};
		
		function asyncCall(value){
			if(dxA.config.getAjaxData != null && typeof dxA.config.getAjaxData === 'function'){
				var ajaxObject = dxA.config.getAjaxData(value);
				if(ajaxObject){
					if(dxA.config.asyncLoading) dxA.buildInner(true);
					ajaxObject.success = dxA.setData;
					
					ajaxObject.error = function(query, status, error) {
					};
					$.ajax(ajaxObject);
				}
			}else if(dxA.config.getAsyncData != null && typeof dxA.config.getAsyncData === 'function'){
				dxA.config.getAsyncData(value, dxA)
				.then(function(res){
					if(res !== undefined){
						var val;
						if(Array.isArray(res)){//List
							val = res;
						}else if(res.data){//Ajax Response
							val = res.data.obj?res.data.obj:res.data;//Ajax with return object or Ajax with list.
						}else if(res.obj){//ReturnObject
							val = res.obj;
						}
						dxA != null && dxA.setData(val, value);
					} else{
						
					}
				},function error(){});
			}
		}
		
		dxA.setData = function (data, value) {
			if(typeof data === "string"){//Prevent undefined when string is received try parsing to json
				try { data = JSON.parse(data); }
				catch(err) { 
					data = [];
				} //Close quietly assume error never happened
			}
			if (dxA) {
				dxA.search.elems = dxA.config.getList(data);
				if(dxA.config.suggestOnDataLoaded(data, value)){
					dxA.buildInner();
					dxA.config.onListShow(data, value);
				}				
			}
		};
		
		dxA.open = function () {
			var val = dxA.baseElement.value;
			if (val.length >= dxA.config.minChar) {	// on affiche pas si aucune recherche possible
				dxA.openReady();
			}
		}
//		dxA.firstOpen = true;
		dxA.openReady = function () {
			dxA.selectionMade = false;
			if (dxA.assistElement == null && dxA.config.trigger != 'focus') return;
			if(!dxA.isOpen){
				dxA.assistPlacement = 'bottom';
				dxA.isOpen = true;
				setSide();
				if(dxA.parentDiv){
					$(dxA.parentDiv).on("click." + dxA.config.assistId, function(e) {
						// console.log(e.namespace);
						if(dxA){
							if(e.target != dxA.baseElement){
								dxA.close();
							}
						}
					});
				}
			}
			
			
//			dxA.assistElement[0].scrollIntoView(false);
			dxA.updateDataSource()// make's sure that the state of the found list is always up to date otherwise there is a sync error between the list and the selectables.
			dxA.config.onOpen(dxA);
//			if(dxA.firstOpen){
//				dxA.firstOpen = false;
//				dxA.close();
//				dxA.openReady();
//			}
		};
		
		function keepOnScreen(elem){
			if(dxA.config.keepOnScreen){
				var offset = $(elem).offset();
				var w = $(elem).width();
				var scrollParent = getScrollParent(elem)
				var scrollLeft = $(scrollParent).width();
				var leftbound = offset.left + w;
				if(leftbound > scrollLeft){
					//Magic no.. 30 find a better way to get the right scroll parent.
					var nleft = offset.left - (30 + (leftbound - scrollLeft));
					$(elem).offset({left: nleft})
				}
			}
		}
		
		function getScrollParent(node) {
			  var isElement = node instanceof HTMLElement;
			  var overflowX = isElement && window.getComputedStyle(node).overflowX;
			  var isScrollable = overflowX !== 'visible' && overflowX !== 'hidden';

			  if (!node) {
			    return null;
			  } else if (isScrollable && node.scrollWidth >= node.clientWidth) {
			    return node;
			  }

			  return getScrollParent(node.parentNode) || document.body;
			}
		
		function setSide(){
			var assistHeight = $(dxA.assistElement.children(".assist-main-div")).outerHeight();
			var bottom = $(dxA.baseElement).offset().top + 335;
			if(bottom > window.innerHeight){
				dxA.assistPlacement = 'top';
				$(dxA.assistElement.children(".assist-main-div")).css("display", "flex");
				$(dxA.assistElement.children(".assist-main-div").children(".assist-content-div")).css("display", "block").css("float", "right");
				$(dxA.assistElement.children(".assist-main-div")).css("flex-direction", "column-reverse");
			}else if(dxA.config.displayOnBottom){
				$(dxA.assistElement.children(".assist-main-div")).css("display", "flex");
				$(dxA.assistElement.children(".assist-main-div")).css("flex-direction", "column-reverse");
			}else{
				dxA.assistPlacement = 'bottom';
				$(dxA.assistElement.children(".assist-main-div")).css("display", "block");
			}
		}
		
		
		function placeOnScreen(elem){
			var rect = $(dxA.assistElement.children(".assist-main-div"))[0].getBoundingClientRect();
			var assistHeight = $(dxA.assistElement.children(".assist-main-div")).outerHeight();
			var nTop;
			if(dxA.assistPlacement === "top"){
				nTop = $(dxA.baseElement).offset().top - assistHeight;
				$(elem).offset({top: nTop});
			}else if(dxA.assistPlacement === "bottom"){
				var baseHeight = $(dxA.baseElement).outerHeight();
				nTop = $(dxA.baseElement).offset().top +baseHeight ;
				$(elem).offset({top: nTop});
			}else if(rect.top > window.innerHeight){
			}
		}
		
		
		function getScrollingParent(elem, includeHidden){
			var position = elem.css( "position" ),
				excludeStaticParent = position === "absolute",
				overflowRegex = includeHidden ? /(auto|scroll|hidden)/ : /(auto|scroll)/,
				scrollParent = elem.parents().filter( function() {
					var parent = $( elem );
					if ( excludeStaticParent && parent.css( "position" ) === "static" ) {
						return false;
					}
					return overflowRegex.test( parent.css( "overflow" ) + parent.css( "overflow-y" ) +
						parent.css( "overflow-x" ) );
				} ).eq( 0 );

			return position === "fixed" || !scrollParent.length ?
				$( elem[ 0 ].ownerDocument || document ) :
				scrollParent;
		}
		
		
		function isOffScreen(elem){
			var rect = elem.getBoundingClientRect();
		  return (rect.left + rect.width) > window.innerWidth ||
				   (rect.top + dxA.config.maxHeight) > window.innerHeight || 
				   (rect.left > window.innerWidth || rect.top > window.innerHeight);
		}
		
		dxA.debounceClose = function(){
			if(dxA.debounceTimeout){
				clearTimeout(dxA.debounceTimeout);
				delete dxA.debounceTimeout;
			}
		}
		dxA.close = function(dontReset) {
			if(!dxA.config.onClose()){
				//on close should return true to pursue the close of the modal otherwise the closing is skipped.
				return;
			}
			dxA.debounceClose();
			//Make reset as default
			var reset = !(dontReset || false);
			if (dxA.assistElement == null) return;
			dxA.assistElement.children(".assist-main-div").fadeOut(100);
			if (reset) {
				// probleme car reset si on utilise la souri pr le select
				dxA.resetOriginalText();
			}
			dxA.isOpen = false;
			$(dxA.parentDiv).off("click." + dxA.config.assistId);
			dxA.resetSearch();
		};
		
		dxA.closeifpossible = function(dontReset, type){
			if(type === dxA.config.trigger){
				dxA.close(dontReset);
			}
		};
		
		function getHeader(){
			var helpDiv = $("<div></div>");
			helpDiv.addClass("assist-help-div");
			var divWidth = dxA.config.hasDetails ? dxA.config.listWidth + dxA.config.descWidth
					: dxA.config.listWidth;
			helpDiv.css("width",(divWidth)+"px");
			if(dxA.config.helpHtml){
				helpDiv.html(dxA.config.helpHtml);
			}else{
				helpDiv.text(dxA.config.helpText);
			}
			return helpDiv;
		}
		
		function getListContentBody(){
			var assistListDiv = $("<div></div>");
			var assistListUL = $("<ul></ul>");
			assistListUL.addClass("assist-list-ul");
			assistListDiv.addClass("assist-list-div");
			assistListDiv.css("width",(dxA.config.listWidth-2)+"px");
			assistListDiv.append(assistListUL);
			
			return assistListDiv;
		}
		
		function getDetailsBody(){
			var assistDescDiv = $("<div></div>");
			assistDescDiv.addClass("assist-desc-div");
			assistDescDiv.css("width",(dxA.config.descWidth-2)+"px");
			setMaxHeight(assistDescDiv);
			return assistDescDiv;
		}
		
		var angularCompilation = function() {
            angular.element('body').injector().invoke(function($compile) {
            	var domspace = getassistElement();
                var scope = angular.element(domspace).scope();
                $compile(domspace)(scope);
                if(!scope.$$phase) {
                	scope.$digest();
            	}
            });
            return true;
        };
        
        function getassistElement(){
        	//Check if usable
			var e = $(dxA.baseElement);
			if (e.length != 1 || typeof e.attr("assistId") === 'undefined' || e.attr("assistId").length < 1) {
				new Error("An assist id must be declared to bind with Dynamic assist widget, no id was declared");
			}
			return $("#"+e.attr("assistId"));
        }
        
		dxA.buildBase = function() {
			this.assistElement = getassistElement();
			if (this.assistElement.length != 1) {
				this.assistElement = null;
				return;
			}
			
			//On va construire les prémisse asteur
			var assistMainDiv = $("<div></div>");
			var assistContentDiv = $("<div></div>");
			
			//On va rendre l'assistElement comme positionneur
			this.assistElement.children().remove();
			this.assistElement.css("position","relative");
			this.assistElement.css("top","0px");
			this.assistElement.css("left","0px");
			
			//On va ajuster les div
			assistMainDiv.addClass("assist-main-div");
			assistContentDiv.addClass("assist-content-div");
			var detailsLength = dxA.config.hasDetails && !dxA.config.displayOnBottom ?dxA.config.descWidth+6: 0;
			assistMainDiv.css("width",(dxA.config.listWidth+detailsLength)+"px");
			
			
			
			$(dxA.baseElement).focusin(function(e) {
				dxA.focusIn();
			});
			
			
	        //Add navigation and trigger events
	        //activate on focus, list navigation events (arrow key, e.t.c)
	        bindEvents();
	        
			//finir d'initaliser
			dxA.resetSearch();
			
			//On va les assembler
			if(dxA.config.hasHeader){
				assistMainDiv.append(getHeader());
			}
			
			if(dxA.config.hasResultList){
				if(dxA.config.hasDetails && dxA.config.detailsOnLeft){
					assistContentDiv.append(getDetailsBody());
				}
				assistContentDiv.append(getListContentBody());
				
				if(dxA.config.hasDetails && !dxA.config.detailsOnLeft){
					assistContentDiv.append(getDetailsBody());
				}
			}
			assistMainDiv.append(assistContentDiv);
			
			this.assistElement.append(assistMainDiv);
			
			if(dxA.config.angular){
				angularCompilation();
			}
			
			//S'enregistrer
			listAssist.push(this);
		};
		

		function eventHandled(e){
			e.preventDefault();
			if (e.which===27) {
				if (!dxA.config.continuePropagationOnEsc) {
					e.stopPropagation();
				}
			} else {
				e.stopPropagation();
			}
		}
		
		function isNotEmpty(v) {
			return v != undefined && v!==null && v!=='';
		}
		
		function bindEvents(){
			  var selectTab = {
		                tab: function($from, offset) {
		                    // Tab from focused element with offset, .tab(-1)
		                    if ($.isNumeric($from)) {
		                        offset = $from;
		                        $from = undefined;
		                    }
		                    $from = $from || selectTab.getFocused();
		                    offset = offset || +1;
		                    dxA.internal.emulateTabbing($from, offset);
		                },
		                forwardTab: function($from) {
		                    return selectTab.tab($from, +1);
		                },
		                reverseTab: function($from) {
		                    return selectTab.tab($from, -1);
		                },
		                getFocused: function() {
		                    return dxA.internal.getFocusedElement();
		                }
		            };
			  
			$(dxA.baseElement).keydown(function(e) {
				var key = e.altKey ? 'alt' + e.which : e.key == undefined ? String.fromCharCode(e.which) : e.key;
				if(dxA.actionMap.has(key)){
					dxA.actionMap.get(key)();
					eventHandled(e);
					return false;
				} else if (dxA.isOpen) {
					if (e.which == 40) {
						dxA.selectNext();
						eventHandled(e);
					} else if (e.which == 38) {
						dxA.selectPrev();
						eventHandled(e);
					} else if (e.which == 9) {//Tab
						// il ne faut pas que le Enter ait d'autres effets (comme activation d'une directive) que celui prévu dans le keyup.
						if(dxA.config.selectOnTab){
							eventHandled(e);
							if(!dxA.entryLocked){
								dxA.select();
								dxA.close();
								if (dxA.config.nextTabOnTab) {
									selectTab.forwardTab(this);
								}								
							}
						}
					} else if (e.which == 13) {//Enter
						// il ne faut pas que le Enter ait d'autres effets (comme activation d'une directive) que celui prévu dans le keyup.
						if(dxA.config.onEnterAction){
							dxA.config.onEnterAction(dxA);
						}
						if(dxA.config.selectOnEnter){
							eventHandled(e);
							if(!dxA.entryLocked){
								dxA.select();
								dxA.close();
								if (dxA.config.nextTabOnEnter) {
									selectTab.forwardTab(this);
								}								
							}
						}
					}
				}
			});
			
			
			$(dxA.baseElement).keyup(function(e) {
				eventHandled(e);
				if(!dxA.entryLocked){
					var hasVal = isNotEmpty(dxA.baseElement.value);
					if (dxA.isOpen) {
						if ((e.which == 40 || e.which == 38)) {
							//Ignore up(40) and down ( 38) arrow keys event already handled on keydown
						} else if (e.which == 27) { //Escape key(close assist)
							closeAllAssist();
						} else if (hasVal && dxA.config.updateOnKeyStroke &&
								dxA.baseElement.value.length >= dxA.config.minChar && 
								!isHelperKey(e.which, dxA.config)) { 
							dxA.updateDataSource();
						} else if (hasVal && dxA.baseElement.value.length < dxA.config.minChar) {
							if (!dxA.showHist) {
								closeAllAssist();
							}
						}
					} else {
						if (e.which == 32 && isCtrl) {
							closeAllAssist();
							dxA.updateDataSource();
						}else if (hasVal && dxA.baseElement.value.length >= dxA.config.minChar && !isHelperKey(e.which, dxA.config)) {
							dxA.updateDataSource();
						}
					}
				}
			});
			
			if(dxA.config.trigger === 'focus'){
				$(dxA.baseElement).focus(dxA.open);
			}
			
			if(!dxA.parentDiv){
				$(dxA.baseElement).blur(function() {
					if(dxA){
						if(dxA.config && dxA.config.selectOnBlur){
							dxA.select();
						}
						if(dxA.isOpen){
							dxA.close();
						}else{
							dxA.debounceClose()
						}
						dxA.selectionMade = false;
					}
				});
			}
			
//			if(dxA.parentDiv){
//				$(dxA.parentDiv).click(function(e) {
//					if(dxA){
//						if(e.target != dxA.baseElement){
//							dxA.close();
//						}
//					}
//					console.log('patate')
//				});
//			}
		}
		
	     
        var tabbable = "input, select, button, textarea ";	// pour être fonctionnel, il faut tabindex='-1' aux controles qui peuvent avoir le focus (en fait le tab)
//		nextOnEnter: true, dans la definition de l'assistant			
        var lastFocusedElement = null;
        
		dxA.internal = {
            escapeSelectorName: function(str) {
                // Based on http://api.jquery.com/category/selectors/
                // Still untested
                return str.replace(/(!"#$%&'\(\)\*\+,\.\/:;<=>\?@\[\]^`\{\|\}~)/g, "\\\\$1");
            },
            findNextTabbable: function($from, offset) {
                var $tabbable = $(tabbable)
                    .not(":disabled")
                    .not(":hidden")
                    .not("a[href]:empty");
                var currentIndex = $tabbable.index($from);
                var nextIndex = (currentIndex + offset) % $tabbable.length;
                if (nextIndex <= -1) {
                    nextIndex = $tabbable.length + nextIndex;
                }
                var $next = $tabbable.eq(nextIndex);
                return $next;
            },
            focusInElement: function(event) {
                lastFocusedElement = event.target;
            },
            tryGetElementAsNonEmptyJQueryObject: function(selector) {
                try {
                    var $element = $(selector);
                    if ( !! $element && $element.length() !== 0) {
                        return $element;
                    }
                } catch (e) {
                    // Could not use element. Do nothing.
                }
                return null;
            },
            getFocusedElement: function() {
                var $focused = dxA.internal.tryGetElementAsNonEmptyJQueryObject(":focus") || dxA.internal.tryGetElementAsNonEmptyJQueryObject(document.activeElement) || dxA.internal.tryGetElementAsNonEmptyJQueryObject(lastFocusedElement) || $();
                return $focused;
            },
            emulateTabbing: function($from, offset) {
                var $next = dxA.internal.findNextTabbable($from, offset);
                $next.focus();
            },
            initializeAtLoad: function() {
                $(document).on("focusin" + eventNamespace, dxA.internal.focusInElement);
            }
        };
		
		
		function setMaxHeight(elem){
			elem.css("overflow","auto");
			elem.css("max-height",dxA.config.maxHeight+"px"); 
		}
		this.buildInner = function(loading) {
			//Don't build the list if it's not to be rendered on screen
			if(dxA.hasResultList)return false;
			//On va aller voir si on doit faire un asyncCall
			//console.log(this.search.originalText+"/"+val.indexOf(this.search.originalText)
			var hasElems = !(this.search.elems == null || this.search.elems.length < 1) ;
			if (!hasElems && !loading && dxA.trigger === 'res' && !dxA.config.alwaysShowHeader) {
				this.close();
				return false;
			}
			
			//Gonna create elements : first : remove all old
			var ul = this.assistElement.children(".assist-main-div").children(".assist-content-div").children(".assist-list-div").children(".assist-list-ul");
			ul.children().remove();

			var li;
			if(hasElems){
				var count = 0;
				
				for (var i = 0; i < this.search.elems.length; i++) {
					var key = dxA.config.getKey(this.search.elems[i]);
					//On construit!
					li = $("<li></li>");
					if(dxA.config.useHtml){
						li.html(key);
					}else if (typeof key === "string") {
						li.text(key);
					} else {
						li.append(key);
					}
					li.attr("ref",i);
					li.addClass("assist-item-"+i);
					li.addClass("assist-item");
					
					li.mouseover(function() {
						var ind = $(this).attr("ref");
						if (typeof ind != 'undefined' && ind != null) {
							dxA.assistElement.find(".item-selected").removeClass("item-selected");
							dxA.selectThisOne(ind);
						}
					});
					li.mousedown(function() {
						dxA.select();
						if (dxA.config.nextTabOnEnter) {
							dxA.internal.emulateTabbing(dxA.baseElement, 1);
						}								
					});
					
					ul.append(li);
					count++;
				}
				
				if (count == 0) {
					this.closeifpossible(true, 'res');
					return false;
				} else {
					setMaxHeight(ul)
//					ul.css("overflow","auto");
//					ul.css("max-height",dxA.config.maxHeight+"px"); 
				}
				
				this.selectNext();
			}else if(loading){
				li = $("<div><img src='/tools/images/loading47.gif' style='height: 2.5em;' alt='Chargement des données'></div>");
				ul.append(li);
			}else{
				var t = "Aucun élément trouvé";
				if (lang.indexOf('en')>-1) {
					t = "Nothing found";
				}
				if(dxA.config.emptyListText){
					t = dxA.config.emptyListText;
				}
				li = $("<div><p>" + t + "</p></div>");
				ul.append(li);
			}
			dxA.open();
			return true;
		};
		
		this.updateDataSource = function(v){
			var argLength = arguments.length;
			if(dxA.config.debounce === 0){
				doUpdate();
			}else {
                if(dxA.debounceTimeout) clearTimeout(dxA.debounceTimeout);
                
				dxA.debounceTimeout = setTimeout(function(){
					dxA.debounceTimeout = null;
					doUpdate();
				}, dxA.config.debounce);
			}
			
			function doUpdate(){
				if (argLength) {
					dxA.resetSearch();
					asyncCall(v);
				} else {
					//On va aller chercher la valeur a rechercher
					var val = dxA.baseElement.value;
					if (val.length >= dxA.config.minChar && dxA.search.originalText != val) {
						dxA.resetSearch();
						dxA.search.originalText = val;
						asyncCall(val);
					}
				}
				setTimeout(function(){// do the screen placement after ui refresh
					var mainDiv = dxA.assistElement.children(".assist-main-div")
					var ul = mainDiv.children(".assist-content-div").children(".assist-list-div").children(".assist-list-ul");
					setMaxHeight(ul);
					setSide();
					keepOnScreen(mainDiv);
					placeOnScreen(dxA.assistElement[0]);
					mainDiv.fadeIn(100);
				}, 0);
			}
		};
		
		dxA.select = function(arg) {
			if(!dxA.selectionMade){
				var elem = null;
				if (typeof arg != 'undefined' && arg != null){
					elem = arg;
				}else{
					var i = this.assistElement.find(".item-selected").attr("ref");
					if (typeof i != 'undefined' && i != null) {
						var e = this.search.elems[i];
						if (typeof e != 'undefined' && e != null) 
							elem = e;
					}
				}
				
				this.closeifpossible(false, 'res');
				if (elem != null) {
					var selectedElem = dxA.config.selection(elem, dxA);
					dxA.selectionMade = true;
					$(dxA.baseElement).val(selectedElem);
					dxA.config.onItemSelected(selectedElem);
				}
			}
		};
		
		function scrollIfNecessary(s){
			var helpDiv = dxA.assistElement.find(".assist-help-div");
			//take in account the header div that displays on certain assist element if 'hasHeader': true,
			helpDiv = helpDiv.length > 0 ? helpDiv : helpDiv.prevObject;
			var ul = dxA.assistElement.children(".assist-main-div").children(".assist-content-div").children(".assist-list-div").children(".assist-list-ul");
			var offset = s.position();
			if (offset) {
				var outerH = helpDiv.outerHeight(true);
				var baseHeight =(dxA.assistPlacement === 'top'? 0 : outerH);
				if(offset.top < 0 + baseHeight){
					$(ul).scrollTop($(ul).scrollTop() -baseHeight +offset.top);
				}else if(offset.top + s.height()> $(ul)[0].clientHeight + baseHeight){
					var remaining = (offset.top + s.height()) - $(ul)[0].clientHeight;
					$(ul).scrollTop( $(ul).scrollTop() - baseHeight+ remaining);
				}
			}
		}
		
		dxA.selectThisOne = function(index) {
			var s = this.assistElement.find(".assist-item-"+index);
			
//			$("#log").text($(ul)[0]['clientHeight'] + " : " + $(ul).height() + " : " + s.height() + " : " + this.search.elems.length + " : " + offset.top + " : " + ul[0].scrollHeight + " : " + ($(ul).scrollTop()- helpDiv.outerHeight(true)));
			scrollIfNecessary(s);
			
			s.addClass("item-selected");
			var e = this.search.elems[index];
			var desc = null;
			if (typeof e != 'undefined' && e != null) {
				desc = dxA.config.getDescription(e);
			}
			this.assistElement.find(".assist-desc-div").children().remove();
			if (typeof desc != 'undefined' && desc != null) {
				if( typeof desc == "string"){
					var pres = $("<div></div>");
					pres.addClass("pres-name");
					pres.html(desc);
					desc = pres;
				}
				this.assistElement.find(".assist-desc-div").append(desc).show();
			} else {
				this.assistElement.find(".assist-desc-div").text("").hide();
			}
		};
		
		dxA.selectNext = function() {
			var s = this.assistElement.find(".item-selected").removeClass("item-selected");
			var i = 0, index;
			if (s.length > 0) {
				var next = s.next("li");
				if (next.length > 0) {
					index = next.attr("ref");
					if (typeof index != 'undefined' && index != null) {
						i = index;
					}
				} else {
					index = this.assistElement.find(".assist-item").first().attr("ref");
					if (typeof index != 'undefined' && index != null) {
						i = index;
					}
				}
			} else {
				index = this.assistElement.find(".assist-item").first().attr("ref");
				if (typeof index != 'undefined' && index != null) {
					i = index;
				}
			}
			
			this.selectThisOne(i);
		};
		
		dxA.selectPrev = function() {
			var s = this.assistElement.find(".item-selected").removeClass("item-selected");
			var i = 0, index;
			if (s.length > 0) {
				var prev = s.prev("li");
				if (prev.length > 0) {
					index = prev.attr("ref");
					if (typeof index != 'undefined' && index != null) {
						i = index;
					}
				} else {
					index = this.assistElement.find(".assist-item").last().attr("ref");
					if (typeof index != 'undefined' && index != null) {
						i = index;
					}
				}
			}
			
			this.selectThisOne(i);
		};
		
		dxA.resetOriginalText = function() {
			this.search.originalText= null;
		};
		
		dxA.resetSearch = function() {
			this.search = {originalText: null, elems: []};
			this.assistElement.children(".assist-main-div").children(".assist-content-div").children(".assist-list-div").children(".assist-list-ul").children().remove();
		};
		
		
		dxA.destroy = function(){
			$(dxA.baseElement).remove();
			dxA.baseElement = null;
			listAssist.splice(listAssist.indexOf(dxA), 1);
			dxA = null;
		};
		
		//Construct the assist element
		init();
	};
	
	function closeAllAssist() {
		for(var i = 0; i < listAssist.length; i++) {
			listAssist[i].close();
		}
	}
	
	function isHelperKey(value, config) {
		if(config !== undefined){
			config = {ingoreBackSpace: false};
		}
		if
		(value == 17 || 
			value == 27 || 
			value == 16 || 
			value == 20 || 
			value == 18 || 
			value == 144 || 
			value == 45 || 
			value == 145 || 
			value == 44 || 
			(config.ingoreBackSpace && value == 8 ) || 
			value == 9 || 
			value == 46 || 
			value == 35 || 
			value == 36 || 
			value == 33 || 
			value == 34 || 
			(value >= 112 && value <= 123)) {
			return true;
		}
		return false;
	}
	
	function getJavaAssist(val) {
		return [
		        {key:val+"a"+Math.floor((Math.random()*10)+1), desc: "a-desc"},
		        {key:val+"b"+Math.floor((Math.random()*10)+1), desc: "b-desc"},
		        {key:val+"c"+Math.floor((Math.random()*10)+1), desc: "c-desc"},
		        {key:val+"aa"+Math.floor((Math.random()*10)+1), desc: "aa-desc"},
		        {key:val+"bb"+Math.floor((Math.random()*10)+1), desc: "bb-desc"},
		        {key:val+"cc"+Math.floor((Math.random()*10)+1), desc: "cc-desc"}
		        ];
	}

})();


