/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util.kryoserializers;

import ca.infodata.ofys.util.EnumWithValue;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnumWithShortValueSerializer<T extends EnumWithValue<?>>
extends Serializer<T> {
    private static final Logger logger = Logger.getLogger(EnumWithShortValueSerializer.class.getName());

    public EnumWithShortValueSerializer() {
        this.setImmutable(true);
    }

    public T read(Kryo k, Input input, Class<? extends T> t) {
        byte value = input.readByte();
        if (value == Short.MIN_VALUE) {
            return null;
        }
        Object o = null;
        try {
            Method method = t.getMethod("from", Integer.class);
            o = method.invoke(null, new Integer(value));
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return (T)((EnumWithValue)o);
    }

    public void write(Kryo k, Output output, T s) {
        if (s == null) {
            output.writeByte(Short.MIN_VALUE);
        } else {
            output.writeByte((byte)s.getValue());
        }
    }
}

