/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util;

import ca.infodata.ofys.util.ITriplet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public final class Triplet<A, B, C>
implements Serializable,
ITriplet<A, B, C> {
    private static final long serialVersionUID = 1L;
    public A first;
    public B second;
    public C third;

    public static <A, B, C> Triplet<A, B, C> newTriplet(A first, B second, C third) {
        return new Triplet<A, B, C>(first, second, third);
    }

    public static <A, B, C> Collection<A> getFirsts(Collection<Triplet<A, B, C>> col) {
        ArrayList<A> firsts = new ArrayList<A>(col.size());
        for (Triplet<A, B, C> pair : col) {
            firsts.add(pair.first);
        }
        return firsts;
    }

    public static <A, B, C> Collection<B> getSeconds(Collection<Triplet<A, B, C>> col) {
        ArrayList<B> seconds = new ArrayList<B>(col.size());
        for (Triplet<A, B, C> pair : col) {
            seconds.add(pair.second);
        }
        return seconds;
    }

    public Triplet() {
    }

    public Triplet(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ITriplet)) {
            return false;
        }
        ITriplet other = (ITriplet)obj;
        if (this.first == null ? other.getFirst() != null : !this.first.equals(other.getFirst())) {
            return false;
        }
        if (this.second == null ? other.getSecond() != null : !this.second.equals(other.getSecond())) {
            return false;
        }
        return !(this.third == null ? other.getThird() != null : !this.third.equals(other.getThird()));
    }

    public String toString() {
        return "(" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ", " + String.valueOf(this.third) + ")";
    }

    @Override
    public A getFirst() {
        return this.first;
    }

    @Override
    public B getSecond() {
        return this.second;
    }

    @Override
    public C getThird() {
        return this.third;
    }
}

