/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.prevalidator;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBodyTemperature;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator;

public class BodyTemperaturePreValidator
implements IPreValidator {
    private StringBuilder error;

    @Override
    public boolean validForDelete(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    @Override
    public boolean validForEdition(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    @Override
    public boolean validForSave(EditableDataObject dataObject, EditableDataObject editorInput) {
        XBodyTemperature bodyTemperature = (XBodyTemperature)dataObject;
        boolean valid = true;
        this.error = new StringBuilder();
        if (bodyTemperature.getBodyTemperature().intValue() < 0) {
            this.error = this.error.append(Messages.getString("ENTREZ_TEMPERATURE", new String[0])).append("\r\n");
            valid = false;
        }
        if (bodyTemperature.getTimeVitalSign() == null) {
            this.error = this.error.append(Messages.getString("ENTREZ_HEURE_VALIDE", new String[0])).append("\r\n");
            valid = false;
        }
        if (this.error.length() > 0) {
            this.error = this.error.insert(0, Messages.getString("EXAMINATION_TEMPERATURE", new String[0]) + "\r\n");
        }
        return valid;
    }

    @Override
    public String getError() {
        return this.error == null ? "" : this.error.toString();
    }
}

