/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.interfaces;

import ca.infodata.ofys.data.middle.dataobjects.ExcludeField;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.Listenable;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ListenableEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ListenableList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ListenableSet;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatusManager;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.collections4.Closure;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public abstract class EditableDataObject
implements Listenable,
IEditableDataObject {
    private static final Logger logger = Logger.getLogger(EditableDataObject.class.getName());
    private static final long serialVersionUID = -5403661189808128425L;
    @ExcludeField
    private transient List<Property<?>> properties = new ArrayList();
    @ExcludeField
    protected transient IObjectListener<?> childrenListener;
    @ExcludeField
    private transient boolean isListenerEnabled = false;
    @ExcludeField
    public Property<ModificationStatus> modificationStatus = this.newProperty("modificationStatus", ModificationStatus.STATUS_NEUTRAL);
    @ExcludeField
    public Property<Integer> tag = this.newProperty("tag", null);
    @ExcludeField
    public Property<Integer> version = this.newProperty("version", null);
    @ExcludeField
    public Property<Long> versionDateTime = this.newProperty("versionDateTime", null);

    public static IntArrayList getIds(Collection<? extends IDataObject> dataObjects) {
        if (dataObjects == null) {
            return new IntArrayList(0);
        }
        IntArrayList ids = new IntArrayList(dataObjects.size());
        for (IDataObject iDataObject : dataObjects) {
            if (iDataObject == null || iDataObject.getId() == null) continue;
            ids.add(iDataObject.getId().intValue());
        }
        return ids;
    }

    public static <T extends IDataObject> T findById(Collection<T> c, int id) {
        if (c == null) {
            throw new IllegalArgumentException("collection is null");
        }
        Integer idInt = id;
        for (IDataObject t : c) {
            if (!idInt.equals(t.getId())) continue;
            return (T)t;
        }
        return null;
    }

    protected <T> Property<T> newProperty(String name, T initialValue) {
        Property<T> property = new Property<T>(name, initialValue);
        this.properties.add(property);
        return property;
    }

    protected <T> Property<T> newProperty(String name, T initialValue, boolean identityEquals) {
        Property<T> property = new Property<T>(name, initialValue, identityEquals);
        this.properties.add(property);
        return property;
    }

    protected <T> Property<T> clonePropertyTo(EditableDataObject target, Property<T> property) {
        EditableDataObject editableDataObject = target;
        editableDataObject.getClass();
        Property<Object> clone = editableDataObject.new Property<Object>(((Property)property).name, this.cloneValue(((Property)property).value));
        target.properties.add(clone);
        return clone;
    }

    protected <T> Property<T> clonePropertyToWithoutCloningValue(EditableDataObject target, Property<T> property, T value) {
        EditableDataObject editableDataObject = target;
        editableDataObject.getClass();
        Property<T> clone = editableDataObject.new Property<T>(((Property)property).name, value);
        target.properties.add(clone);
        return clone;
    }

    private <T> T cloneValue(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Cloneable) {
            return this.cloneClonableValue(value);
        }
        if (value instanceof Collection) {
            throw new IllegalStateException("value should be clonable but is not. value=" + value.getClass().getName() + StringUtils.safeToString((Logger)logger, value));
        }
        return value;
    }

    private <A> A cloneClonableValue(A value) {
        if (value instanceof int[]) {
            return (A)Arrays.copyOf((int[])value, ((int[])value).length);
        }
        if (value instanceof String[]) {
            return (A)Arrays.copyOf((String[])value, ((String[])value).length);
        }
        try {
            Method m_clone = value.getClass().getMethod("clone", new Class[0]);
            m_clone.setAccessible(true);
            return (A)((Cloneable)m_clone.invoke(value, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void read(Kryo k, Input input) {
        this.tag.plain_set(MiscUtil.toInt(input.readInt()));
        this.version.plain_set(MiscUtil.toInt(input.readInt()));
        this.versionDateTime.plain_set(MiscUtil.toLong(input.readLong()));
        this.modificationStatus.plain_set(ModificationStatus.from(Integer.valueOf(input.readShort())));
    }

    public void write(Kryo k, Output output) {
        output.writeInt(MiscUtil.fromInt(this.tag.get()));
        output.writeInt(MiscUtil.fromInt(this.version.get()));
        output.writeLong(MiscUtil.fromLong(this.getVersionDateTime()));
        output.writeShort(this.modificationStatus.get().getValue());
    }

    @Override
    public String toString() {
        return this.fullToString();
    }

    public String fullToString() {
        return "This object: " + ReflectionToStringBuilder.toString((Object)this);
    }

    public EditableDataObject() {
        this.childrenListener = new MyChildrenListener();
    }

    @Override
    public final void setModificationStatus(ModificationStatus newStatus) {
        this.modificationStatus.plain_set(ModificationStatusManager.modifyStatus(this.modificationStatus.get(), newStatus));
        this.meModified();
    }

    protected void childModified(Object object) {
        this.setModificationStatus(ModificationStatus.STATUS_CHILDREN_UPDATED);
    }

    public void meModified() {
        if (this.isListenerEnabled) {
            ObjectListenerManager.fireObjectModified(this);
        }
    }

    @Override
    public EditableDataObject clone() {
        EditableDataObject c = null;
        try {
            c = (EditableDataObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        c.properties = new ArrayList();
        c.isListenerEnabled = this.isListenerEnabled;
        c.tag = this.clonePropertyTo(c, this.tag);
        c.setTag(null);
        c.version = this.clonePropertyTo(c, this.version);
        c.childrenListener = c.new MyChildrenListener();
        c.modificationStatus = this.clonePropertyTo(c, this.modificationStatus);
        return c;
    }

    @Override
    public EditableDataObject cloneSetIdNull() {
        EditableDataObject oo = this.clone();
        oo.setId(null);
        return oo;
    }

    @Override
    public ModificationStatus getModificationStatus() {
        return this.modificationStatus.get();
    }

    @Override
    public Integer getTag() {
        return this.tag.get();
    }

    public final boolean isStatusDeleted() {
        return this.getModificationStatus() == ModificationStatus.STATUS_DELETED;
    }

    @Override
    public boolean isDirty() {
        return this.getModificationStatus() != ModificationStatus.STATUS_NEUTRAL;
    }

    public final boolean isChildrenUpdated() {
        return this.getModificationStatus() == ModificationStatus.STATUS_CHILDREN_UPDATED;
    }

    public final boolean isNeutral() {
        return this.getModificationStatus() == ModificationStatus.STATUS_NEUTRAL;
    }

    public final boolean isNew() {
        return this.getModificationStatus() == ModificationStatus.STATUS_NEW;
    }

    public final boolean isNewOrNewUpdated() {
        return this.isNew() || this.isNewUpdated();
    }

    public final boolean isNewUpdated() {
        return this.getModificationStatus() == ModificationStatus.STATUS_NEW_UPDATED;
    }

    public final boolean isNonExisting() {
        return this.getModificationStatus() == ModificationStatus.STATUS_NON_EXISTING;
    }

    public final boolean isUpdated() {
        return this.getModificationStatus() == ModificationStatus.STATUS_UPDATED;
    }

    public final boolean isUpdatedOrder() {
        return this.getModificationStatus() == ModificationStatus.STATUS_UPDATED_ORDER;
    }

    @Override
    public IStatus valid() {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validQuestion() {
        return Status.OK_STATUS;
    }

    public void setNeutral() {
        this.modificationStatus.plain_set(ModificationStatus.STATUS_NEUTRAL);
    }

    public void setDeleted() {
        this.setModificationStatus(ModificationStatus.STATUS_DELETED);
    }

    @Override
    public void setNew() {
        this.setModificationStatus(ModificationStatus.STATUS_NEW);
    }

    public void setNewUpdated() {
        this.setModificationStatus(ModificationStatus.STATUS_NEW_UPDATED);
    }

    @Override
    public void setTag() {
        this.setTag(System.identityHashCode(this));
    }

    @Override
    public void setTag(Integer tag) {
        this.tag.plain_set(tag);
    }

    @Override
    public Integer getVersion() {
        return this.version.get();
    }

    public void setVersion(Integer version) {
        this.version.plain_set(version);
    }

    public void setVersionDateTime(Long versionDateTime) {
        this.versionDateTime.plain_set(versionDateTime);
    }

    public Long getVersionDateTime() {
        return this.versionDateTime.get();
    }

    public Date getVersionDateTimeDate() {
        Long value = this.getVersionDateTime();
        if (value == null) {
            return null;
        }
        return new Date(value);
    }

    public final void setUpdated() {
        this.setModificationStatus(ModificationStatus.STATUS_UPDATED);
    }

    public final void setUpdatedOrder() {
        this.setModificationStatus(ModificationStatus.STATUS_UPDATED_ORDER);
    }

    @Override
    public final boolean isListenerEnabled() {
        return this.isListenerEnabled;
    }

    @Override
    public final void setListenerEnabled(boolean enable) {
        this.isListenerEnabled = enable;
        for (Property<?> property : this.properties) {
            this.setListenerEnabledForProperty(property);
        }
    }

    protected <T> void setListenerEnabledForProperty(Property<T> property) {
        if (((Property)property).value instanceof Listenable) {
            this.setListenerEnabledFor((Listenable)((Property)property).value);
        } else if (((Property)property).value instanceof IEditableDataObjectList) {
            ((Property)property).value = this.setListenerEnabledFor((IEditableDataObjectList)((Property)property).value);
        } else if (((Property)property).value instanceof List) {
            ((Property)property).value = this.setListenerEnabledFor((List)((Property)property).value);
        } else if (((Property)property).value instanceof Set) {
            ((Property)property).value = this.setListenerEnabledFor((Set)((Property)property).value);
        }
    }

    protected void setListenerEnabledFor(Listenable child) {
        if (this.isListenerEnabled) {
            ObjectListenerManager.addListener(child, this.childrenListener);
        } else {
            ObjectListenerManager.remove(child);
        }
        if (child != null) {
            child.setListenerEnabled(this.isListenerEnabled);
        }
    }

    protected List<?> setListenerEnabledFor(List<?> child) {
        if (this.isListenerEnabled) {
            List<?> decorated = child;
            if (!(child instanceof ListenableList)) {
                boolean listenToChildren = true;
                decorated = ListenableList.decorate(child, true);
            }
            this.setListenerEnabledFor((Listenable)((Object)decorated));
            return decorated;
        }
        if (child instanceof ListenableList) {
            ListenableList listenableList = (ListenableList)child;
            listenableList.setListenerEnabled(false);
            return (List)listenableList.collection;
        }
        return child;
    }

    protected Set<?> setListenerEnabledFor(Set<?> child) {
        if (this.isListenerEnabled) {
            Set<?> decorated = child;
            if (!(child instanceof ListenableSet)) {
                boolean listenToChildren = true;
                decorated = ListenableSet.decorate(child, true);
            }
            this.setListenerEnabledFor((Listenable)((Object)decorated));
            return decorated;
        }
        if (child instanceof ListenableSet) {
            ListenableSet listenableSet = (ListenableSet)child;
            listenableSet.setListenerEnabled(false);
            return (Set)listenableSet.collection;
        }
        return child;
    }

    protected IEditableDataObjectList<?> setListenerEnabledFor(IEditableDataObjectList<?> child) {
        if (this.isListenerEnabled) {
            IEditableDataObjectList<?> decorated = child;
            if (!(child instanceof ListenableEditableDataObjectList)) {
                boolean listenToChildren = true;
                decorated = ListenableEditableDataObjectList.decorate(child, true);
            }
            this.setListenerEnabledFor((Listenable)((Object)decorated));
            return decorated;
        }
        if (child instanceof ListenableEditableDataObjectList) {
            ListenableEditableDataObjectList list = (ListenableEditableDataObjectList)child;
            list.setListenerEnabled(false);
            return list.editableDataObjectList;
        }
        return child;
    }

    @Override
    public final boolean equalsByTag(IMinimalEditableDataObject other) {
        return other != null && this.getTag() != null && other.getTag() != null && this.getTag().equals(other.getTag());
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj instanceof EditableDataObject) {
            equals = this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : (this.getClass().getName() + this.getId()).hashCode();
        return hashCode;
    }

    @Override
    @Deprecated
    public void initialize() {
    }

    public List<Property<?>> debug_getProperties() {
        return this.properties;
    }

    public List<Property<?>> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property<?>> properties) {
        this.properties = properties;
    }

    public IObjectListener<?> getChildrenListener() {
        return this.childrenListener;
    }

    public void setChildrenListener(IObjectListener<?> childrenListener) {
        this.childrenListener = childrenListener;
    }

    public final class Property<T>
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 4433322512711940069L;
        private T value;
        private String name;
        private boolean identityEquals;

        public Property() {
        }

        public Property(String name, T initialValue) {
            this(name, initialValue, true);
        }

        public Property(String name, T initialValue, boolean identityEquals) {
            this.identityEquals = identityEquals;
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.name = name;
            this.setValue(initialValue);
        }

        public T get() {
            return this.value;
        }

        public void plain_set(T value) {
            this.value = value;
        }

        public void plain_set2(T value) {
            this.setValue(value);
        }

        public void set(T value) {
            this.set(value, ModificationStatus.STATUS_UPDATED);
        }

        public void set(T value, ModificationStatus newStatus) {
            this.set(value, newStatus, null);
        }

        public void set(T value, Closure customCode) {
            this.set(value, ModificationStatus.STATUS_UPDATED, customCode);
        }

        public void set(T value, ModificationStatus newStatus, Closure customCode) {
            boolean changed = this.setValue(value);
            if (changed) {
                this.executeCustomCode(customCode);
                EditableDataObject.this.setModificationStatus(newStatus);
            }
        }

        private boolean setValue(T newValue) {
            boolean changed;
            T oldValue = this.value;
            boolean bl = this.identityEquals ? oldValue != newValue : (changed = !MiscUtil.areObjectsEquals(oldValue, newValue));
            if (changed) {
                boolean isListenerCompatible;
                boolean bl2 = isListenerCompatible = this.isListenerCompatible(this.value) || this.isListenerCompatible(newValue);
                if (isListenerCompatible && oldValue != null) {
                    ObjectListenerManager.removeListener(oldValue, EditableDataObject.this.childrenListener);
                }
                this.value = newValue;
                if (isListenerCompatible) {
                    EditableDataObject.this.setListenerEnabledForProperty(this);
                }
            }
            return changed;
        }

        private boolean isListenerCompatible(Object o) {
            return o instanceof Listenable || o instanceof List;
        }

        private void executeCustomCode(Closure customCode) {
            if (customCode != null) {
                customCode.execute(this.value);
            }
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return "Property[" + this.name + "=" + String.valueOf(this.value) + "]";
        }

        public EditableDataObject getParent() {
            return EditableDataObject.this;
        }

        public boolean isIdentityEquals() {
            return this.identityEquals;
        }
    }

    public class MyChildrenListener
    implements IObjectListener<Object>,
    Serializable {
        private static final long serialVersionUID = 8960977581032704845L;

        @Override
        public void objectModified(Object object) {
            logger.entering(this.getClass().getName(), "objectModified");
            EditableDataObject.this.childModified(object);
        }

        public String toString() {
            return EditableDataObject.this.getClass().getName() + ".MyChildrenListener";
        }
    }
}

