/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XPersonReplacement;
import ca.infodata.ofys.data.middle.dataobjects.XPersonType;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnalSpeciality;
import ca.infodata.ofys.data.middle.dataobjects.billingnb.XProfessionnalFacturationNB;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.professionnal.RxVigilanceLicenceType;
import ca.infodata.ofys.data.middle.dataobjects.professionnal.XProfessionnalType;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

public final class XProfessionnal
extends XPerson
implements ICompletionComboItem,
KryoSerializable {
    public static final String DEFAULT_PROF_CODE = "9999999";
    private static final long serialVersionUID = 1L;
    public static final String[] PROFESSIONNAL_ON_CALL_TEXT = new String[]{Messages.getString("SUR_APPEL__ENDROIT_1", new String[0]), Messages.getString("SUR_APPEL__ENDROIT_2", new String[0]), Messages.getString("SUR_APPEL__ENDROIT_3", new String[0])};
    public static final int TYPE_TREATING_NONE = -1;
    public static final int TYPE_TREATING_ALL = 0;
    public static final int TYPE_TREATING_APPOINTMENT = 1;
    public static final int TYPE_TREATING_BILLING = 2;
    public static final int TYPE_TREATING_ENCOUNTER = 4;
    public static final int TYPE_TREATING_PRESCRIPTION = 8;
    public static final int TYPE_TREATING_SCANNING = 32;
    public Integer id;
    public String code;
    public String codeRamq;
    public String codeCollege;
    public XProfessionnalType type;
    public RxVigilanceLicenceType rxvLicence;
    public Integer speciality;
    public Integer onCallLocation;
    public boolean isProfTx;
    public boolean isSetSeenManual;
    public boolean isHubSynchro;
    public boolean useAppointment;
    public String encounterHeader;
    public Boolean isOnCallProfessionnal;
    public String noAgenceRamq;
    public String noGroup;
    public XProfessionnalFacturationNB facturationNB;
    public String[] replaces;
    public EditableDataObjectList<XPersonReplacement> listReplacements;
    public String b2bUserIdRamq;
    public String billingName;

    @Override
    public void write(Kryo k, Output out) {
        out.writeInt(MiscUtil.fromInt(this.id));
        out.writeString(MiscUtil.fromString(this.code));
        out.writeString(MiscUtil.fromString(this.codeRamq));
        out.writeString(MiscUtil.fromString(this.codeCollege));
        out.writeShort(this.type.getValue());
        out.writeShort((int)((short)(this.rxvLicence == null ? 0 : (short)this.rxvLicence.getValue())));
        out.writeInt(MiscUtil.fromInt(this.speciality));
        out.writeInt(MiscUtil.fromInt(this.onCallLocation));
        out.writeBoolean(this.isProfTx);
        out.writeBoolean(this.isSetSeenManual);
        out.writeBoolean(this.isHubSynchro);
        out.writeBoolean(this.useAppointment);
        out.writeString(MiscUtil.fromString(this.encounterHeader));
        out.writeByte(MiscUtil.fromBoolean(this.isOnCallProfessionnal));
        out.writeString(MiscUtil.fromString(this.noAgenceRamq));
        out.writeString(MiscUtil.fromString(this.noGroup));
        if (this.facturationNB == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            k.writeObject(out, (Object)this.facturationNB);
        }
        int size = this.listReplacements == null ? 0 : this.listReplacements.size();
        out.writeShort(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                k.writeObject(out, this.listReplacements.get(i));
            }
        }
        out.writeString(MiscUtil.fromString(this.b2bUserIdRamq));
        out.writeString(MiscUtil.fromString(this.billingName));
        super.write(k, out);
    }

    @Override
    public void read(Kryo k, Input in) {
        this.id = MiscUtil.toInt(in.readInt());
        this.code = MiscUtil.toString(in.readString());
        this.codeRamq = MiscUtil.toString(in.readString());
        this.codeCollege = MiscUtil.toString(in.readString());
        this.type = XProfessionnalType.from(Integer.valueOf(in.readShort()));
        this.rxvLicence = RxVigilanceLicenceType.from(Integer.valueOf(in.readShort()));
        this.speciality = MiscUtil.toInt(in.readInt());
        this.onCallLocation = MiscUtil.toInt(in.readInt());
        this.isProfTx = in.readBoolean();
        this.isSetSeenManual = in.readBoolean();
        this.isHubSynchro = in.readBoolean();
        this.useAppointment = in.readBoolean();
        this.encounterHeader = MiscUtil.toString(in.readString());
        this.isOnCallProfessionnal = MiscUtil.toBoolean(in.readByte());
        this.noAgenceRamq = MiscUtil.toString(in.readString());
        this.noGroup = MiscUtil.toString(in.readString());
        if (in.readByte() == 1) {
            this.facturationNB = (XProfessionnalFacturationNB)k.readObject(in, XProfessionnalFacturationNB.class);
        }
        short b = in.readShort();
        this.listReplacements = MiscUtil.extracted(k, in, b, XPersonReplacement.class);
        this.b2bUserIdRamq = MiscUtil.toString(in.readString());
        this.billingName = MiscUtil.toString(in.readString());
        super.read(k, in);
    }

    public XProfessionnal() {
        this.setPersonType(XPersonType.PROF);
    }

    @Override
    public void initialize() {
        this.setNew();
        this.setCode("");
        this.setCodeRamq("");
        this.setCodeCollege("");
        this.setProfessionnalType(XProfessionnalType.NONDEFINI);
        this.setRxvLicence(RxVigilanceLicenceType.NONE);
        this.setOnCallLocation(0);
        this.setUseAppointment(false);
        this.setSpeciality(new Integer(XProfessionnalSpeciality.SPECIALITY_NONE.value));
        this.setEncounterHeader("");
        this.setListReplacements(new EditableDataObjectList<XPersonReplacement>());
        this.setPersonType(XPersonType.PROF);
        super.initialize();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        this.setUpdated();
    }

    public final String getCodeRamq() {
        return this.codeRamq;
    }

    public final void setCodeRamq(String codeRamq) {
        this.codeRamq = codeRamq;
        this.setUpdated();
    }

    public final String getCodeCollege() {
        return this.codeCollege;
    }

    public final void setCodeCollege(String codeCollege) {
        this.codeCollege = codeCollege;
        this.setUpdated();
    }

    public final String[] getReplaces() {
        return this.replaces;
    }

    public final void setReplaces(String[] replaces) {
        this.replaces = replaces;
        this.setUpdated();
    }

    public XProfessionnalType getProfessionnalType() {
        return this.type;
    }

    public void setProfessionnalType(XProfessionnalType type) {
        this.type = type;
        this.setUpdated();
    }

    public RxVigilanceLicenceType getRxvLicence() {
        return this.rxvLicence;
    }

    public void setRxvLicence(RxVigilanceLicenceType rxvLicence) {
        this.rxvLicence = rxvLicence;
        this.setUpdated();
    }

    public Integer getOnCallLocation() {
        return this.onCallLocation;
    }

    public void setOnCallLocation(Integer onCallLocation) {
        this.onCallLocation = onCallLocation;
        this.setUpdated();
    }

    public Integer getSpeciality() {
        return this.speciality;
    }

    public void setSpeciality(Integer speciality) {
        this.speciality = speciality;
        this.setUpdated();
    }

    public boolean useAppointment() {
        return this.useAppointment;
    }

    public void setUseAppointment(boolean useAppointment) {
        this.useAppointment = useAppointment;
        this.setUpdated();
    }

    @Override
    public String toString() {
        String ret = this.str;
        if (ret == null) {
            ret = this.isNewOrNewUpdated() ? Messages.getString("NOUVEAU_DISPENSATEUR_DE_SERVICES", new String[0]) : this.getName() + " " + this.getCode();
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XProfessionnal" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public XProfessionnal clone() {
        XProfessionnal c = (XProfessionnal)super.clone();
        c.id = this.id;
        c.code = this.code;
        c.type = this.type;
        c.rxvLicence = this.rxvLicence;
        c.isProfTx = this.isProfTx;
        c.isSetSeenManual = this.isSetSeenManual;
        c.onCallLocation = this.onCallLocation;
        c.useAppointment = this.useAppointment;
        c.speciality = this.speciality;
        c.encounterHeader = this.encounterHeader;
        c.noAgenceRamq = this.noAgenceRamq;
        c.noGroup = this.noGroup;
        c.listReplacements = this.listReplacements == null ? null : this.listReplacements.deepClone();
        c.facturationNB = this.facturationNB == null ? null : this.facturationNB.clone();
        c.b2bUserIdRamq = this.b2bUserIdRamq == null ? null : this.b2bUserIdRamq;
        c.billingName = this.billingName == null ? null : this.billingName;
        super.copyTo(c);
        return c;
    }

    public boolean getIsProfTx() {
        return this.isProfTx;
    }

    public void setIsProfTx(boolean v) {
        this.isProfTx = v;
        this.setUpdated();
    }

    public boolean getIsSetSeenManual() {
        return this.isSetSeenManual;
    }

    public void setIsSetSeenManual(boolean v) {
        this.isSetSeenManual = v;
        this.setUpdated();
    }

    public boolean getIsHubSynchro() {
        return this.isHubSynchro;
    }

    public void setIsHubSynchro(boolean hs) {
        this.isHubSynchro = hs;
        this.setUpdated();
    }

    public String getEncounterHeader() {
        return this.encounterHeader;
    }

    public void setEncounterHeader(String encounterHeader) {
        this.encounterHeader = encounterHeader;
        this.setUpdated();
    }

    public Boolean getIsOnCallProfessionnal() {
        return this.isOnCallProfessionnal;
    }

    public void setIsOnCallProfessionnal(Boolean isOnCallProfessionnal) {
        this.isOnCallProfessionnal = isOnCallProfessionnal;
        this.setUpdated();
    }

    public String getNoAgenceRamq() {
        return this.noAgenceRamq;
    }

    public void setNoAgenceRamq(String noAgenceRamq) {
        this.noAgenceRamq = noAgenceRamq;
        this.setUpdated();
    }

    public String getNoGroup() {
        return this.noGroup;
    }

    public void setNoGroup(String n) {
        this.noGroup = n;
        this.setUpdated();
    }

    public EditableDataObjectList<XPersonReplacement> getListReplacements() {
        return this.listReplacements;
    }

    public void setListReplacements(EditableDataObjectList<XPersonReplacement> listReplacements) {
        this.listReplacements = listReplacements;
        this.setUpdated();
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.listReplacements != null && this.listReplacements.isDirty() || this.facturationNB != null && this.facturationNB.isDirty();
    }

    public XProfessionnalFacturationNB getFacturationNB() {
        if (this.facturationNB == null) {
            this.facturationNB = new XProfessionnalFacturationNB();
        }
        return this.facturationNB;
    }

    public void setFacturationNB(XProfessionnalFacturationNB facturationNB) {
        this.facturationNB = facturationNB;
        this.setUpdated();
    }

    public String getB2bUserIdRamq() {
        return this.b2bUserIdRamq;
    }

    public void setB2bUserIdRamq(String value) {
        this.b2bUserIdRamq = value;
        this.setUpdated();
    }

    public String getCode5chiffres() {
        String code5 = this.code;
        if (code5 != null && code5.length() > 5) {
            code5 = !code5.startsWith("1") ? code5.substring(0, 5) : code5.substring(1, 6);
        }
        return code5;
    }

    public String getCode6chiffres() {
        String code6 = this.code;
        if (this.code == null) {
            return null;
        }
        if (this.code.length() == 5) {
            code6 = "1" + this.code;
        }
        if (code6.length() > 6 && XProfessionnalType.MD_OMNIPRATICIEN.equals(this.getProfessionnalType())) {
            code6 = code6.substring(0, 6);
        }
        return code6;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getText() {
        return StringUtils.isEmpty((String)this.str) ? this.getName() : this.str;
    }

    @Override
    public boolean isActive() {
        return !Boolean.TRUE.equals(this.getIsDeleted());
    }

    public String getBillingName() {
        return this.billingName;
    }

    public void setBillingName(String billingName) {
        this.billingName = billingName;
    }
}

